/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.fx.particles;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.verdantartifice.primalmagick.client.fx.particles.SpellBoltParticleData;
import com.verdantartifice.primalmagick.client.renderers.types.ThickLinesRenderType;
import com.verdantartifice.primalmagick.common.util.LineSegment;
import com.verdantartifice.primalmagick.common.util.VectorUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4fStack;

public class SpellBoltParticle
extends Particle {
    protected static final float WIDTH = 6.0f;
    protected static final double MAX_DISPLACEMENT = 0.5;
    protected static final double PERTURB_DISTANCE = 0.002;
    protected static final int GENERATIONS = 5;
    protected final Vec3 delta;
    protected final List<LineSegment> segmentList;
    protected final List<Vec3> perturbList;

    protected SpellBoltParticle(ClientLevel world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, Vec3 target) {
        super(world, x, y, z, xSpeed, ySpeed, zSpeed);
        this.delta = target.subtract(new Vec3(x, y, z));
        this.xd = 0.0;
        this.yd = 0.0;
        this.zd = 0.0;
        this.lifetime = 10;
        this.segmentList = this.calcSegments();
        this.perturbList = this.calcPerturbs();
    }

    @Nonnull
    protected List<LineSegment> calcSegments() {
        ArrayList<LineSegment> retVal = new ArrayList<LineSegment>();
        double curDisplacement = 0.5;
        retVal.add(new LineSegment(Vec3.ZERO, this.delta));
        for (int gen = 0; gen < 5; ++gen) {
            ArrayList<LineSegment> tempList = new ArrayList<LineSegment>();
            for (LineSegment segment : retVal) {
                Vec3 midpoint = segment.getMiddle();
                midpoint = midpoint.add(VectorUtils.getRandomOrthogonalUnitVector(segment.getDelta(), this.level.random).scale(curDisplacement));
                tempList.add(new LineSegment(segment.getStart(), midpoint));
                tempList.add(new LineSegment(midpoint, segment.getEnd()));
            }
            retVal = tempList;
            curDisplacement /= 2.0;
        }
        return retVal;
    }

    @Nonnull
    protected List<Vec3> calcPerturbs() {
        ArrayList<Vec3> retVal = new ArrayList<Vec3>();
        retVal.add(Vec3.ZERO);
        for (LineSegment segment : this.segmentList) {
            retVal.add(segment.getEnd().equals((Object)this.delta) ? Vec3.ZERO : VectorUtils.getRandomUnitVector(this.level.random).scale(0.002 * this.level.random.nextDouble()));
        }
        return retVal;
    }

    public void render(VertexConsumer builder, Camera entityIn, float partialTicks) {
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)1);
        RenderSystem.disableCull();
        Matrix4fStack stack = RenderSystem.getModelViewStack();
        stack.pushMatrix();
        stack.translate((float)(this.x - entityIn.getPosition().x), (float)(this.y - entityIn.getPosition().y), (float)(this.z - entityIn.getPosition().z));
        MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
        VertexConsumer lineBuilder = buffer.getBuffer(ThickLinesRenderType.THICK_LINES);
        for (int index = 0; index < this.segmentList.size(); ++index) {
            LineSegment segment = this.segmentList.get(index);
            segment.perturb(this.perturbList.get(index), this.perturbList.get(index + 1));
            lineBuilder.addVertex((float)segment.getStart().x, (float)segment.getStart().y, (float)segment.getStart().z).setColor(this.rCol, this.gCol, this.bCol, 0.5f);
            lineBuilder.addVertex((float)segment.getEnd().x, (float)segment.getEnd().y, (float)segment.getEnd().z).setColor(this.rCol, this.gCol, this.bCol, 0.5f);
        }
        buffer.endBatch(ThickLinesRenderType.THICK_LINES);
        RenderSystem.enableCull();
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
        stack.popMatrix();
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.CUSTOM;
    }

    public static class Factory
    implements ParticleProvider<SpellBoltParticleData> {
        public Factory(SpriteSet spriteSet) {
        }

        public Particle createParticle(SpellBoltParticleData typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new SpellBoltParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, typeIn.getTargetVec());
        }
    }
}

