/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.fx.particles;

import com.verdantartifice.primalmagick.client.fx.particles.PotionExplosionParticleData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.NoRenderParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;

public class PotionExplosionParticle
extends NoRenderParticle {
    protected int timeSinceStart;
    protected final int maximumTime = 8;
    protected final boolean isInstant;

    protected PotionExplosionParticle(ClientLevel world, double x, double y, double z, boolean isInstant) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.isInstant = isInstant;
    }

    public void tick() {
        Minecraft mc = Minecraft.getInstance();
        for (int index = 0; index < 12; ++index) {
            double z;
            double y;
            double x;
            Particle p = mc.particleEngine.createParticle((ParticleOptions)(this.isInstant ? ParticleTypes.INSTANT_EFFECT : ParticleTypes.EFFECT), x = this.x + (this.random.nextDouble() - this.random.nextDouble()) * 4.0, y = this.y + (this.random.nextDouble() - this.random.nextDouble()) * 4.0, z = this.z + (this.random.nextDouble() - this.random.nextDouble()) * 4.0, (double)this.timeSinceStart / (double)this.maximumTime, 0.0, 0.0);
            if (p == null) continue;
            p.setColor(this.rCol, this.gCol, this.bCol);
        }
        if (++this.timeSinceStart >= this.maximumTime) {
            this.remove();
        }
    }

    public static class Factory
    implements ParticleProvider<PotionExplosionParticleData> {
        public Particle createParticle(PotionExplosionParticleData typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new PotionExplosionParticle(worldIn, x, y, z, typeIn.isInstant());
        }
    }
}

