/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.fx.particles;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class OfferingParticle
extends TextureSheetParticle {
    protected final float uVal;
    protected final float vVal;
    protected final double targetX;
    protected final double targetY;
    protected final double targetZ;

    protected OfferingParticle(ClientLevel world, double x, double y, double z, double tx, double ty, double tz, ItemStack stack) {
        super(world, x, y, z);
        this.setSprite(Minecraft.getInstance().getItemRenderer().getModel(stack, (Level)world, (LivingEntity)null, 0).getParticleIcon());
        this.targetX = tx;
        this.targetY = ty;
        this.targetZ = tz;
        this.gravity = 0.01f;
        this.uVal = this.random.nextFloat() * 3.0f;
        this.vVal = this.random.nextFloat() * 3.0f;
        double dx = this.targetX - this.x;
        double dy = this.targetY - this.y;
        double dz = this.targetZ - this.z;
        int base = (int)(Math.sqrt(dx * dx + dy * dy + dz * dz) * 10.0);
        if (base < 1) {
            base = 1;
        }
        this.lifetime = base / 2 + this.random.nextInt(base);
        this.xd = 0.03 * this.random.nextGaussian();
        this.yd = 0.03 * this.random.nextGaussian();
        this.zd = 0.03 * this.random.nextGaussian();
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.TERRAIN_SHEET;
    }

    protected float getU0() {
        return this.sprite.getU((this.uVal + 1.0f) / 4.0f);
    }

    protected float getU1() {
        return this.sprite.getU(this.uVal / 4.0f);
    }

    protected float getV0() {
        return this.sprite.getV(this.vVal / 4.0f);
    }

    protected float getV1() {
        return this.sprite.getV((this.vVal + 1.0f) / 4.0f);
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime || this.hasReachedTarget()) {
            this.remove();
        } else {
            this.move(this.xd, this.yd, this.zd);
            this.xd *= 0.985;
            this.yd *= 0.95;
            this.zd *= 0.985;
            double dx = this.targetX - this.x;
            double dy = this.targetY - this.y;
            double dz = this.targetZ - this.z;
            double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
            double clamp = Math.min(0.25, distance / 15.0);
            if (distance < 2.0) {
                this.quadSize *= 0.9f;
            }
            this.xd += (dx /= distance) * clamp;
            this.yd += (dy /= distance) * clamp;
            this.zd += (dz /= distance) * clamp;
            this.xd = Mth.clamp((double)this.xd, (double)(-clamp), (double)clamp);
            this.yd = Mth.clamp((double)this.yd, (double)(-clamp), (double)clamp);
            this.zd = Mth.clamp((double)this.zd, (double)(-clamp), (double)clamp);
            this.xd += this.random.nextGaussian() * 0.005;
            this.yd += this.random.nextGaussian() * 0.005;
            this.zd += this.random.nextGaussian() * 0.005;
        }
    }

    protected boolean hasReachedTarget() {
        return Mth.floor((double)this.x) == Mth.floor((double)this.targetX) && Mth.floor((double)this.y) == Mth.floor((double)this.targetY) && Mth.floor((double)this.z) == Mth.floor((double)this.targetZ);
    }

    public static class Factory
    implements ParticleProvider<ItemParticleOption> {
        public Factory(SpriteSet spriteSet) {
        }

        public Particle createParticle(ItemParticleOption typeIn, ClientLevel worldIn, double x, double y, double z, double tx, double ty, double tz) {
            return new OfferingParticle(worldIn, x, y, z, tx, ty, tz, typeIn.getItem());
        }
    }
}

