/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.fx.particles;

import com.verdantartifice.primalmagick.client.fx.particles.ParticleTypesPM;
import com.verdantartifice.primalmagick.common.sources.Sources;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.FastColor;

public class DripParticlePM
extends TextureSheetParticle {
    protected DripParticlePM(ClientLevel pLevel, double pX, double pY, double pZ) {
        super(pLevel, pX, pY, pZ);
        this.setSize(0.01f, 0.01f);
        this.gravity = 0.06f;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.preMoveUpdate();
        if (!this.removed) {
            this.yd -= (double)this.gravity;
            this.move(this.xd, this.yd, this.zd);
            this.postMoveUpdate();
            if (!this.removed) {
                this.xd *= (double)0.98f;
                this.yd *= (double)0.98f;
                this.zd *= (double)0.98f;
            }
        }
    }

    protected void preMoveUpdate() {
        if (this.lifetime-- <= 0) {
            this.remove();
        }
    }

    protected void postMoveUpdate() {
    }

    public void setColor(int packedColor) {
        float r = (float)FastColor.ARGB32.red((int)packedColor) / 255.0f;
        float g = (float)FastColor.ARGB32.green((int)packedColor) / 255.0f;
        float b = (float)FastColor.ARGB32.blue((int)packedColor) / 255.0f;
        this.setColor(r, g, b);
    }

    public static TextureSheetParticle createBloodDropHangParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
        Hang particle = new Hang(pLevel, pX, pY, pZ, (ParticleOptions)ParticleTypesPM.FALLING_BLOOD_DROP.get());
        particle.gravity *= 0.01f;
        particle.lifetime = 100;
        particle.setColor(Sources.BLOOD.getColor());
        return particle;
    }

    public static TextureSheetParticle createBloodDropFallParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
        Fall particle = new Fall(pLevel, pX, pY, pZ, (ParticleOptions)ParticleTypesPM.LANDING_BLOOD_DROP.get());
        particle.gravity = 0.01f;
        particle.setColor(Sources.BLOOD.getColor());
        return particle;
    }

    public static TextureSheetParticle createBloodDropLandParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
        Land particle = new Land(pLevel, pX, pY, pZ);
        particle.lifetime = (int)(28.0 / (Math.random() * 0.8 + 0.2));
        particle.setColor(Sources.BLOOD.getColor());
        return particle;
    }

    public static class Hang
    extends DripParticlePM {
        protected final ParticleOptions fallParticle;

        public Hang(ClientLevel pLevel, double pX, double pY, double pZ, ParticleOptions pFallParticle) {
            super(pLevel, pX, pY, pZ);
            this.fallParticle = pFallParticle;
        }

        @Override
        protected void preMoveUpdate() {
            super.preMoveUpdate();
            if (this.removed) {
                this.level.addParticle(this.fallParticle, this.x, this.y, this.z, this.xd, this.yd, this.zd);
            }
        }

        @Override
        protected void postMoveUpdate() {
            super.postMoveUpdate();
            this.xd *= 0.02;
            this.yd *= 0.02;
            this.zd *= 0.02;
        }
    }

    public static class Fall
    extends DripParticlePM {
        protected final ParticleOptions landParticle;

        public Fall(ClientLevel pLevel, double pX, double pY, double pZ, ParticleOptions pFallParticle) {
            super(pLevel, pX, pY, pZ);
            this.landParticle = pFallParticle;
            this.lifetime = (int)(64.0 / (Math.random() * 0.8 + 0.2));
        }

        @Override
        protected void postMoveUpdate() {
            super.postMoveUpdate();
            if (this.onGround) {
                this.remove();
                this.level.addParticle(this.landParticle, this.x, this.y, this.z, 0.0, 0.0, 0.0);
            }
        }
    }

    public static class Land
    extends DripParticlePM {
        public Land(ClientLevel pLevel, double pX, double pY, double pZ) {
            super(pLevel, pX, pY, pZ);
            this.lifetime = (int)(16.0 / (Math.random() * 0.8 + 0.2));
        }
    }
}

