/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.fx;

import com.verdantartifice.primalmagick.client.fx.particles.ManaSparkleParticle;
import com.verdantartifice.primalmagick.client.fx.particles.ParticleTypesPM;
import com.verdantartifice.primalmagick.client.fx.particles.PotionExplosionParticleData;
import com.verdantartifice.primalmagick.client.fx.particles.SpellBoltParticleData;
import com.verdantartifice.primalmagick.common.sounds.SoundsPM;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.FastColor;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class FxDispatcher {
    public static final FxDispatcher INSTANCE = new FxDispatcher();
    public static final int DEFAULT_PROP_MARKER_LIFETIME = 6000;
    protected static final Map<BlockPos, Particle> PROP_MARKER_PARTICLES = new HashMap<BlockPos, Particle>();

    protected Level getWorld() {
        Minecraft mc = Minecraft.getInstance();
        return mc.level;
    }

    public void wandPoof(double x, double y, double z, int color, boolean sound, Direction side) {
        float r = (float)FastColor.ARGB32.red((int)color) / 255.0f;
        float g = (float)FastColor.ARGB32.green((int)color) / 255.0f;
        float b = (float)FastColor.ARGB32.blue((int)color) / 255.0f;
        this.wandPoof(x, y, z, r, g, b, sound, side);
    }

    public void wandPoof(double x, double y, double z, float r, float g, float b, boolean sound, Direction side) {
        Minecraft mc = Minecraft.getInstance();
        Level world = this.getWorld();
        RandomSource rng = world.random;
        if (sound) {
            this.getWorld().playLocalSound(x, y, z, SoundsPM.POOF.get(), SoundSource.BLOCKS, 1.0f, 1.0f + (float)rng.nextGaussian() * 0.05f, false);
        }
        for (int index = 0; index < 8 + rng.nextInt(3); ++index) {
            Particle p;
            double dx = (double)rng.nextFloat() * 0.05 * (double)(rng.nextBoolean() ? 1 : -1);
            double dy = (double)rng.nextFloat() * 0.05 * (double)(rng.nextBoolean() ? 1 : -1);
            double dz = (double)rng.nextFloat() * 0.05 * (double)(rng.nextBoolean() ? 1 : -1);
            if (side != null) {
                dx += (double)side.getStepX() * 0.1;
                dy += (double)side.getStepY() * 0.1;
                dz += (double)side.getStepZ() * 0.1;
            }
            if ((p = mc.particleEngine.createParticle((ParticleOptions)ParticleTypesPM.WAND_POOF.get(), x + dx * 2.0, y + dy * 2.0, z + dz * 2.0, dx / 2.0, dy / 2.0, dz / 2.0)) == null) continue;
            p.setColor(r, g, b);
        }
    }

    public void manaSparkle(double x1, double y1, double z1, double x2, double y2, double z2, int maxAge, int color, double phase) {
        float r = (float)FastColor.ARGB32.red((int)color) / 255.0f;
        float g = (float)FastColor.ARGB32.green((int)color) / 255.0f;
        float b = (float)FastColor.ARGB32.blue((int)color) / 255.0f;
        this.manaSparkle(x1, y1, z1, x2, y2, z2, maxAge, r, g, b, phase);
    }

    public void manaSparkle(double x1, double y1, double z1, double x2, double y2, double z2, int maxAge, float r, float g, float b, double phase) {
        Minecraft mc = Minecraft.getInstance();
        double vx = (x2 - x1) / (double)maxAge;
        double vy = (y2 - y1) / (double)maxAge;
        double vz = (z2 - z1) / (double)maxAge;
        Particle p = mc.particleEngine.createParticle((ParticleOptions)ParticleTypesPM.MANA_SPARKLE.get(), x1, y1, z1, vx, vy, vz);
        if (p != null) {
            p.setColor(r, g, b);
            p.setLifetime(maxAge);
            if (p instanceof ManaSparkleParticle) {
                ManaSparkleParticle manaSparkleParticle = (ManaSparkleParticle)p;
                manaSparkleParticle.setPhase(phase);
            }
        }
    }

    public void spellTrail(double x, double y, double z, int color) {
        float r = (float)FastColor.ARGB32.red((int)color) / 255.0f;
        float g = (float)FastColor.ARGB32.green((int)color) / 255.0f;
        float b = (float)FastColor.ARGB32.blue((int)color) / 255.0f;
        this.spellTrail(x, y, z, r, g, b);
    }

    public void spellTrail(double x, double y, double z, float r, float g, float b) {
        Minecraft mc = Minecraft.getInstance();
        Particle p = mc.particleEngine.createParticle((ParticleOptions)ParticleTypesPM.SPELL_SPARKLE.get(), x, y, z, 0.0, 0.0, 0.0);
        if (p != null) {
            p.setColor(r, g, b);
        }
    }

    public void spellImpact(double x, double y, double z, int radius, int color) {
        float r = (float)FastColor.ARGB32.red((int)color) / 255.0f;
        float g = (float)FastColor.ARGB32.green((int)color) / 255.0f;
        float b = (float)FastColor.ARGB32.blue((int)color) / 255.0f;
        this.spellImpact(x, y, z, radius, r, g, b);
    }

    public void spellImpact(double x, double y, double z, int radius, float r, float g, float b) {
        Minecraft mc = Minecraft.getInstance();
        Level world = this.getWorld();
        RandomSource rng = world.random;
        int count = (15 + rng.nextInt(11)) * radius;
        for (int index = 0; index < count; ++index) {
            double dx = (double)rng.nextFloat() * 0.035 * (double)radius * (double)(rng.nextBoolean() ? 1 : -1);
            double dy = (double)rng.nextFloat() * 0.035 * (double)radius * (double)(rng.nextBoolean() ? 1 : -1);
            double dz = (double)rng.nextFloat() * 0.035 * (double)radius * (double)(rng.nextBoolean() ? 1 : -1);
            Particle p = mc.particleEngine.createParticle((ParticleOptions)ParticleTypesPM.SPELL_SPARKLE.get(), x, y, z, dx, dy, dz);
            if (p == null) continue;
            p.setColor(r, g, b);
        }
    }

    public void ritualGlow(BlockPos pos, int color) {
        Minecraft mc = Minecraft.getInstance();
        Level world = this.getWorld();
        RandomSource rng = world.random;
        float r = (float)FastColor.ARGB32.red((int)color) / 255.0f;
        float g = (float)FastColor.ARGB32.green((int)color) / 255.0f;
        float b = (float)FastColor.ARGB32.blue((int)color) / 255.0f;
        int count = 10 + rng.nextInt(6);
        for (int index = 0; index < count; ++index) {
            Particle p = mc.particleEngine.createParticle((ParticleOptions)ParticleTypesPM.SPELL_SPARKLE.get(), (double)pos.getX() + rng.nextDouble(), (double)pos.getY() + 1.0, (double)pos.getZ() + rng.nextDouble(), 0.0, 0.075, 0.0);
            if (p == null) continue;
            p.setColor(r, g, b);
        }
    }

    public void spellcraftingGlow(BlockPos pos, double dy, int color) {
        float r = (float)FastColor.ARGB32.red((int)color) / 255.0f;
        float g = (float)FastColor.ARGB32.green((int)color) / 255.0f;
        float b = (float)FastColor.ARGB32.blue((int)color) / 255.0f;
        this.spellcraftingGlow(pos, dy, r, g, b);
    }

    public void spellcraftingGlow(BlockPos pos, double dy, float r, float g, float b) {
        Minecraft mc = Minecraft.getInstance();
        Level world = this.getWorld();
        RandomSource rng = world.random;
        int count = 3 + rng.nextInt(3);
        for (int index = 0; index < count; ++index) {
            double x = (double)pos.getX() + 0.40625 + rng.nextDouble() * 0.1875;
            double y = (double)pos.getY() + dy;
            double z = (double)pos.getZ() + 0.40625 + rng.nextDouble() * 0.1875;
            Particle p = mc.particleEngine.createParticle((ParticleOptions)ParticleTypesPM.SPELL_SPARKLE.get(), x, y, z, 0.0, 0.0375, 0.0);
            if (p == null) continue;
            p.setColor(r, g, b);
        }
    }

    public void teleportArrival(double x, double y, double z) {
        Level world = this.getWorld();
        for (int i = 0; i < 32; ++i) {
            world.addParticle((ParticleOptions)ParticleTypes.PORTAL, x, y + world.random.nextDouble() * 2.0, z, world.random.nextGaussian(), 0.0, world.random.nextGaussian());
        }
    }

    public void spellBolt(double sx, double sy, double sz, double tx, double ty, double tz, int color) {
        float r = (float)FastColor.ARGB32.red((int)color) / 255.0f;
        float g = (float)FastColor.ARGB32.green((int)color) / 255.0f;
        float b = (float)FastColor.ARGB32.blue((int)color) / 255.0f;
        this.spellBolt(sx, sy, sz, tx, ty, tz, r, g, b);
    }

    public void spellBolt(double sx, double sy, double sz, double tx, double ty, double tz, float r, float g, float b) {
        Minecraft mc = Minecraft.getInstance();
        Particle p = mc.particleEngine.createParticle((ParticleOptions)new SpellBoltParticleData(tx, ty, tz), sx, sy, sz, 0.0, 0.0, 0.0);
        if (p != null) {
            p.setColor(r, g, b);
        }
    }

    public void offeringChannel(double sx, double sy, double sz, double tx, double ty, double tz, ItemStack stack) {
        Minecraft mc = Minecraft.getInstance();
        mc.particleEngine.createParticle((ParticleOptions)new ItemParticleOption(ParticleTypesPM.OFFERING.get(), stack), sx, sy, sz, tx, ty, tz);
    }

    public void propMarker(BlockPos pos) {
        this.propMarker(pos, 6000);
    }

    public void propMarker(BlockPos pos, int lifetimeTicks) {
        Minecraft mc = Minecraft.getInstance();
        Particle p = mc.particleEngine.createParticle((ParticleOptions)ParticleTypesPM.PROP_MARKER.get(), (double)pos.getX() + 0.5, (double)pos.getY() + 1.5, (double)pos.getZ() + 0.5, 0.0, 0.0, 0.0);
        p.setLifetime(lifetimeTicks);
        this.removePropMarker(pos);
        PROP_MARKER_PARTICLES.put(pos, p);
    }

    public void removePropMarker(BlockPos pos) {
        if (PROP_MARKER_PARTICLES.containsKey(pos)) {
            Particle oldParticle = PROP_MARKER_PARTICLES.remove(pos);
            oldParticle.remove();
        }
    }

    public void pixieDust(double x, double y, double z, int color) {
        float r = (float)FastColor.ARGB32.red((int)color) / 255.0f;
        float g = (float)FastColor.ARGB32.green((int)color) / 255.0f;
        float b = (float)FastColor.ARGB32.blue((int)color) / 255.0f;
        this.pixieDust(x, y, z, r, g, b);
    }

    public void pixieDust(double x, double y, double z, float r, float g, float b) {
        Minecraft mc = Minecraft.getInstance();
        Particle p = mc.particleEngine.createParticle((ParticleOptions)ParticleTypesPM.SPELL_SPARKLE.get(), x, y, z, 0.0, -0.1, 0.0);
        if (p != null) {
            p.setColor(r, g, b);
        }
    }

    public void crucibleBubble(double x, double y, double z, int color) {
        float r = (float)FastColor.ARGB32.red((int)color) / 255.0f;
        float g = (float)FastColor.ARGB32.green((int)color) / 255.0f;
        float b = (float)FastColor.ARGB32.blue((int)color) / 255.0f;
        this.crucibleBubble(x, y, z, r, g, b);
    }

    public void crucibleBubble(double x, double y, double z, float r, float g, float b) {
        Minecraft mc = Minecraft.getInstance();
        Particle p = mc.particleEngine.createParticle((ParticleOptions)ParticleTypes.BUBBLE, x, y, z, 0.0, 0.0, 0.0);
        if (p != null) {
            p.setColor(r, g, b);
        }
    }

    public void potionExplosion(double x, double y, double z, int color, boolean isInstant) {
        float r = (float)FastColor.ARGB32.red((int)color) / 255.0f;
        float g = (float)FastColor.ARGB32.green((int)color) / 255.0f;
        float b = (float)FastColor.ARGB32.blue((int)color) / 255.0f;
        this.potionExplosion(x, y, z, r, g, b, isInstant);
    }

    public void potionExplosion(double x, double y, double z, float r, float g, float b, boolean isInstant) {
        Minecraft mc = Minecraft.getInstance();
        Level world = this.getWorld();
        world.playLocalSound(x, y, z, (SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), SoundSource.NEUTRAL, 4.0f, (1.0f + (world.random.nextFloat() - world.random.nextFloat()) * 0.2f) * 0.7f, false);
        world.addParticle((ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, x, y, z, 1.0, 0.0, 0.0);
        Particle p = mc.particleEngine.createParticle((ParticleOptions)new PotionExplosionParticleData(isInstant), x, y, z, 1.0, 0.0, 0.0);
        if (p != null) {
            p.setColor(r, g, b);
        }
    }

    public void manaArrowTrail(double x, double y, double z, double dx, double dy, double dz, int color) {
        float r = (float)FastColor.ARGB32.red((int)color) / 255.0f;
        float g = (float)FastColor.ARGB32.green((int)color) / 255.0f;
        float b = (float)FastColor.ARGB32.blue((int)color) / 255.0f;
        this.manaArrowTrail(x, y, z, dx, dy, dz, r, g, b);
    }

    public void manaArrowTrail(double x, double y, double z, double dx, double dy, double dz, float r, float g, float b) {
        Minecraft mc = Minecraft.getInstance();
        Particle p = mc.particleEngine.createParticle((ParticleOptions)ParticleTypesPM.SPELL_SPARKLE.get(), x, y, z, dx, dy, dz);
        if (p != null) {
            p.setColor(r, g, b);
        }
    }

    public void spellcraftingRuneU(double x, double y, double z, double dx, double dy, double dz, int color) {
        float r = (float)FastColor.ARGB32.red((int)color) / 255.0f;
        float g = (float)FastColor.ARGB32.green((int)color) / 255.0f;
        float b = (float)FastColor.ARGB32.blue((int)color) / 255.0f;
        this.spellcraftingRuneU(x, y, z, dx, dy, dz, r, g, b);
    }

    public void spellcraftingRuneU(double x, double y, double z, double dx, double dy, double dz, float r, float g, float b) {
        Minecraft mc = Minecraft.getInstance();
        Particle p = mc.particleEngine.createParticle((ParticleOptions)ParticleTypesPM.SPELLCRAFTING_RUNE_U.get(), x, y, z, dx, dy, dz);
        if (p != null) {
            p.setColor(r, g, b);
        }
    }

    public void spellcraftingRuneV(double x, double y, double z, double dx, double dy, double dz, int color) {
        float r = (float)FastColor.ARGB32.red((int)color) / 255.0f;
        float g = (float)FastColor.ARGB32.green((int)color) / 255.0f;
        float b = (float)FastColor.ARGB32.blue((int)color) / 255.0f;
        this.spellcraftingRuneV(x, y, z, dx, dy, dz, r, g, b);
    }

    public void spellcraftingRuneV(double x, double y, double z, double dx, double dy, double dz, float r, float g, float b) {
        Minecraft mc = Minecraft.getInstance();
        Particle p = mc.particleEngine.createParticle((ParticleOptions)ParticleTypesPM.SPELLCRAFTING_RUNE_V.get(), x, y, z, dx, dy, dz);
        if (p != null) {
            p.setColor(r, g, b);
        }
    }

    public void spellcraftingRuneT(double x, double y, double z, double dx, double dy, double dz, int color) {
        float r = (float)FastColor.ARGB32.red((int)color) / 255.0f;
        float g = (float)FastColor.ARGB32.green((int)color) / 255.0f;
        float b = (float)FastColor.ARGB32.blue((int)color) / 255.0f;
        this.spellcraftingRuneT(x, y, z, dx, dy, dz, r, g, b);
    }

    public void spellcraftingRuneT(double x, double y, double z, double dx, double dy, double dz, float r, float g, float b) {
        Minecraft mc = Minecraft.getInstance();
        Particle p = mc.particleEngine.createParticle((ParticleOptions)ParticleTypesPM.SPELLCRAFTING_RUNE_T.get(), x, y, z, dx, dy, dz);
        if (p != null) {
            p.setColor(r, g, b);
        }
    }

    public void spellcraftingRuneD(double x, double y, double z, double dx, double dy, double dz, int color) {
        float r = (float)FastColor.ARGB32.red((int)color) / 255.0f;
        float g = (float)FastColor.ARGB32.green((int)color) / 255.0f;
        float b = (float)FastColor.ARGB32.blue((int)color) / 255.0f;
        this.spellcraftingRuneD(x, y, z, dx, dy, dz, r, g, b);
    }

    public void spellcraftingRuneD(double x, double y, double z, double dx, double dy, double dz, float r, float g, float b) {
        Minecraft mc = Minecraft.getInstance();
        Particle p = mc.particleEngine.createParticle((ParticleOptions)ParticleTypesPM.SPELLCRAFTING_RUNE_D.get(), x, y, z, dx, dy, dz);
        if (p != null) {
            p.setColor(r, g, b);
        }
    }

    public void bloodDrop(double x, double y, double z) {
        Minecraft mc = Minecraft.getInstance();
        mc.particleEngine.createParticle((ParticleOptions)ParticleTypesPM.DRIPPING_BLOOD_DROP.get(), x, y, z, 0.0, 0.0, 0.0);
    }
}

