/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.events;

import com.verdantartifice.primalmagick.common.blocks.BlocksPM;
import com.verdantartifice.primalmagick.common.blocks.misc.StainedSkyglassBlock;
import com.verdantartifice.primalmagick.common.blocks.misc.StainedSkyglassPaneBlock;
import com.verdantartifice.primalmagick.common.blocks.rituals.RitualCandleBlock;
import com.verdantartifice.primalmagick.common.blocks.rituals.SaltTrailBlock;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.items.entities.ManaArrowItem;
import com.verdantartifice.primalmagick.common.items.food.AmbrosiaItem;
import com.verdantartifice.primalmagick.common.items.misc.AttunementShacklesItem;
import com.verdantartifice.primalmagick.common.items.misc.HummingArtifactItem;
import java.util.function.Function;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.core.component.DataComponents;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.state.properties.Property;

public class ColorEvents {
    public static void onBlockColorInit(BlockColorRegistrar blockColors) {
        blockColors.register((state, lightReader, pos, dummy) -> SaltTrailBlock.colorMultiplier((Integer)state.getValue((Property)SaltTrailBlock.POWER)), BlocksPM.SALT_TRAIL.get());
        blockColors.register((state, lightReader, pos, dummy) -> state.getBlock() instanceof StainedSkyglassBlock ? ((StainedSkyglassBlock)state.getBlock()).getColor().getFireworkColor() : DyeColor.WHITE.getFireworkColor(), (Block)BlocksPM.STAINED_SKYGLASS_BLACK.get(), (Block)BlocksPM.STAINED_SKYGLASS_BLUE.get(), (Block)BlocksPM.STAINED_SKYGLASS_BROWN.get(), (Block)BlocksPM.STAINED_SKYGLASS_CYAN.get(), (Block)BlocksPM.STAINED_SKYGLASS_GRAY.get(), (Block)BlocksPM.STAINED_SKYGLASS_GREEN.get(), (Block)BlocksPM.STAINED_SKYGLASS_LIGHT_BLUE.get(), (Block)BlocksPM.STAINED_SKYGLASS_LIGHT_GRAY.get(), (Block)BlocksPM.STAINED_SKYGLASS_LIME.get(), (Block)BlocksPM.STAINED_SKYGLASS_MAGENTA.get(), (Block)BlocksPM.STAINED_SKYGLASS_ORANGE.get(), (Block)BlocksPM.STAINED_SKYGLASS_PINK.get(), (Block)BlocksPM.STAINED_SKYGLASS_PURPLE.get(), (Block)BlocksPM.STAINED_SKYGLASS_RED.get(), (Block)BlocksPM.STAINED_SKYGLASS_WHITE.get(), (Block)BlocksPM.STAINED_SKYGLASS_YELLOW.get());
        blockColors.register((state, lightReader, pos, dummy) -> state.getBlock() instanceof StainedSkyglassPaneBlock ? ((StainedSkyglassPaneBlock)state.getBlock()).getColor().getFireworkColor() : DyeColor.WHITE.getFireworkColor(), BlocksPM.STAINED_SKYGLASS_PANE_BLACK.get(), BlocksPM.STAINED_SKYGLASS_PANE_BLUE.get(), BlocksPM.STAINED_SKYGLASS_PANE_BROWN.get(), BlocksPM.STAINED_SKYGLASS_PANE_CYAN.get(), BlocksPM.STAINED_SKYGLASS_PANE_GRAY.get(), BlocksPM.STAINED_SKYGLASS_PANE_GREEN.get(), BlocksPM.STAINED_SKYGLASS_PANE_LIGHT_BLUE.get(), BlocksPM.STAINED_SKYGLASS_PANE_LIGHT_GRAY.get(), BlocksPM.STAINED_SKYGLASS_PANE_LIME.get(), BlocksPM.STAINED_SKYGLASS_PANE_MAGENTA.get(), BlocksPM.STAINED_SKYGLASS_PANE_ORANGE.get(), BlocksPM.STAINED_SKYGLASS_PANE_PINK.get(), BlocksPM.STAINED_SKYGLASS_PANE_PURPLE.get(), BlocksPM.STAINED_SKYGLASS_PANE_RED.get(), BlocksPM.STAINED_SKYGLASS_PANE_WHITE.get(), BlocksPM.STAINED_SKYGLASS_PANE_YELLOW.get());
        blockColors.register((state, lightReader, pos, dummy) -> state.getBlock() instanceof RitualCandleBlock ? ((RitualCandleBlock)state.getBlock()).getColor().getFireworkColor() : DyeColor.WHITE.getFireworkColor(), (Block)BlocksPM.RITUAL_CANDLE_BLACK.get(), (Block)BlocksPM.RITUAL_CANDLE_BLUE.get(), (Block)BlocksPM.RITUAL_CANDLE_BROWN.get(), (Block)BlocksPM.RITUAL_CANDLE_CYAN.get(), (Block)BlocksPM.RITUAL_CANDLE_GRAY.get(), (Block)BlocksPM.RITUAL_CANDLE_GREEN.get(), (Block)BlocksPM.RITUAL_CANDLE_LIGHT_BLUE.get(), (Block)BlocksPM.RITUAL_CANDLE_LIGHT_GRAY.get(), (Block)BlocksPM.RITUAL_CANDLE_LIME.get(), (Block)BlocksPM.RITUAL_CANDLE_MAGENTA.get(), (Block)BlocksPM.RITUAL_CANDLE_ORANGE.get(), (Block)BlocksPM.RITUAL_CANDLE_PINK.get(), (Block)BlocksPM.RITUAL_CANDLE_PURPLE.get(), (Block)BlocksPM.RITUAL_CANDLE_RED.get(), (Block)BlocksPM.RITUAL_CANDLE_WHITE.get(), (Block)BlocksPM.RITUAL_CANDLE_YELLOW.get());
        blockColors.register((state, lightReader, pos, dummy) -> 14731036, (Block)BlocksPM.ATTACHED_HYDROMELON_STEM.get());
        blockColors.register((state, lightReader, pos, dummy) -> {
            int i = (Integer)state.getValue((Property)StemBlock.AGE);
            int j = i * 32;
            int k = 255 - i * 8;
            int l = i * 4;
            return j << 16 | k << 8 | l;
        }, (Block)BlocksPM.HYDROMELON_STEM.get());
    }

    public static void onItemColorInit(ItemColorRegistrar itemColors) {
        itemColors.register((stack, dummy) -> {
            BlockItem blockItem;
            Block patt1$temp;
            Item patt0$temp = stack.getItem();
            if (patt0$temp instanceof BlockItem && (patt1$temp = (blockItem = (BlockItem)patt0$temp).getBlock()) instanceof StainedSkyglassBlock) {
                StainedSkyglassBlock skyglassBlock = (StainedSkyglassBlock)patt1$temp;
                int color = skyglassBlock.getColor().getFireworkColor();
                if (FastColor.ARGB32.alpha((int)color) == 0) {
                    color = FastColor.ARGB32.opaque((int)color);
                }
                return color;
            }
            return FastColor.ARGB32.opaque((int)DyeColor.WHITE.getFireworkColor());
        }, (ItemLike)ItemsPM.STAINED_SKYGLASS_BLACK.get(), (ItemLike)ItemsPM.STAINED_SKYGLASS_BLUE.get(), (ItemLike)ItemsPM.STAINED_SKYGLASS_BROWN.get(), (ItemLike)ItemsPM.STAINED_SKYGLASS_CYAN.get(), (ItemLike)ItemsPM.STAINED_SKYGLASS_GRAY.get(), (ItemLike)ItemsPM.STAINED_SKYGLASS_GREEN.get(), (ItemLike)ItemsPM.STAINED_SKYGLASS_LIGHT_BLUE.get(), (ItemLike)ItemsPM.STAINED_SKYGLASS_LIGHT_GRAY.get(), (ItemLike)ItemsPM.STAINED_SKYGLASS_LIME.get(), (ItemLike)ItemsPM.STAINED_SKYGLASS_MAGENTA.get(), (ItemLike)ItemsPM.STAINED_SKYGLASS_ORANGE.get(), (ItemLike)ItemsPM.STAINED_SKYGLASS_PINK.get(), (ItemLike)ItemsPM.STAINED_SKYGLASS_PURPLE.get(), (ItemLike)ItemsPM.STAINED_SKYGLASS_RED.get(), (ItemLike)ItemsPM.STAINED_SKYGLASS_WHITE.get(), (ItemLike)ItemsPM.STAINED_SKYGLASS_YELLOW.get());
        itemColors.register((stack, dummy) -> {
            BlockItem blockItem;
            Block patt1$temp;
            Item patt0$temp = stack.getItem();
            if (patt0$temp instanceof BlockItem && (patt1$temp = (blockItem = (BlockItem)patt0$temp).getBlock()) instanceof StainedSkyglassPaneBlock) {
                StainedSkyglassPaneBlock skyglassBlock = (StainedSkyglassPaneBlock)patt1$temp;
                int color = skyglassBlock.getColor().getFireworkColor();
                if (FastColor.ARGB32.alpha((int)color) == 0) {
                    color = FastColor.ARGB32.opaque((int)color);
                }
                return color;
            }
            return FastColor.ARGB32.opaque((int)DyeColor.WHITE.getFireworkColor());
        }, (ItemLike)ItemsPM.STAINED_SKYGLASS_PANE_BLACK.get(), (ItemLike)ItemsPM.STAINED_SKYGLASS_PANE_BLUE.get(), (ItemLike)ItemsPM.STAINED_SKYGLASS_PANE_BROWN.get(), (ItemLike)ItemsPM.STAINED_SKYGLASS_PANE_CYAN.get(), (ItemLike)ItemsPM.STAINED_SKYGLASS_PANE_GRAY.get(), (ItemLike)ItemsPM.STAINED_SKYGLASS_PANE_GREEN.get(), (ItemLike)ItemsPM.STAINED_SKYGLASS_PANE_LIGHT_BLUE.get(), (ItemLike)ItemsPM.STAINED_SKYGLASS_PANE_LIGHT_GRAY.get(), (ItemLike)ItemsPM.STAINED_SKYGLASS_PANE_LIME.get(), (ItemLike)ItemsPM.STAINED_SKYGLASS_PANE_MAGENTA.get(), (ItemLike)ItemsPM.STAINED_SKYGLASS_PANE_ORANGE.get(), (ItemLike)ItemsPM.STAINED_SKYGLASS_PANE_PINK.get(), (ItemLike)ItemsPM.STAINED_SKYGLASS_PANE_PURPLE.get(), (ItemLike)ItemsPM.STAINED_SKYGLASS_PANE_RED.get(), (ItemLike)ItemsPM.STAINED_SKYGLASS_PANE_WHITE.get(), (ItemLike)ItemsPM.STAINED_SKYGLASS_PANE_YELLOW.get());
        itemColors.register((stack, dummy) -> {
            BlockItem blockItem;
            Block patt1$temp;
            Item patt0$temp = stack.getItem();
            if (patt0$temp instanceof BlockItem && (patt1$temp = (blockItem = (BlockItem)patt0$temp).getBlock()) instanceof RitualCandleBlock) {
                RitualCandleBlock candleBlock = (RitualCandleBlock)patt1$temp;
                int color = candleBlock.getColor().getFireworkColor();
                if (FastColor.ARGB32.alpha((int)color) == 0) {
                    color = FastColor.ARGB32.opaque((int)color);
                }
                return color;
            }
            return FastColor.ARGB32.opaque((int)DyeColor.WHITE.getFireworkColor());
        }, (ItemLike)ItemsPM.RITUAL_CANDLE_BLACK.get(), (ItemLike)ItemsPM.RITUAL_CANDLE_BLUE.get(), (ItemLike)ItemsPM.RITUAL_CANDLE_BROWN.get(), (ItemLike)ItemsPM.RITUAL_CANDLE_CYAN.get(), (ItemLike)ItemsPM.RITUAL_CANDLE_GRAY.get(), (ItemLike)ItemsPM.RITUAL_CANDLE_GREEN.get(), (ItemLike)ItemsPM.RITUAL_CANDLE_LIGHT_BLUE.get(), (ItemLike)ItemsPM.RITUAL_CANDLE_LIGHT_GRAY.get(), (ItemLike)ItemsPM.RITUAL_CANDLE_LIME.get(), (ItemLike)ItemsPM.RITUAL_CANDLE_MAGENTA.get(), (ItemLike)ItemsPM.RITUAL_CANDLE_ORANGE.get(), (ItemLike)ItemsPM.RITUAL_CANDLE_PINK.get(), (ItemLike)ItemsPM.RITUAL_CANDLE_PURPLE.get(), (ItemLike)ItemsPM.RITUAL_CANDLE_RED.get(), (ItemLike)ItemsPM.RITUAL_CANDLE_WHITE.get(), (ItemLike)ItemsPM.RITUAL_CANDLE_YELLOW.get());
        itemColors.register((stack, color) -> color == 0 ? ((PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).getColor() : -1, (ItemLike)ItemsPM.CONCOCTION.get(), (ItemLike)ItemsPM.ALCHEMICAL_BOMB.get());
        AmbrosiaItem.getAllAmbrosias().forEach(ambrosia -> itemColors.register((stack, tintIndex) -> ColorEvents.getStackColor(stack, tintIndex, ambrosia::getColor), new ItemLike[]{ambrosia}));
        ManaArrowItem.getManaArrows().forEach(arrow -> itemColors.register((stack, tintIndex) -> ColorEvents.getStackColor(stack, tintIndex, arrow::getColor), new ItemLike[]{arrow}));
        HummingArtifactItem.getAllHummingArtifacts().forEach(artifact -> itemColors.register((stack, tintIndex) -> ColorEvents.getStackColor(stack, tintIndex, artifact::getColor), new ItemLike[]{artifact}));
        AttunementShacklesItem.getAllShackles().forEach(shackles -> itemColors.register((stack, tintIndex) -> ColorEvents.getStackColor(stack, tintIndex, shackles::getColor), new ItemLike[]{shackles}));
    }

    private static int getStackColor(ItemStack stack, int tintIndex, Function<Integer, Integer> baseColorGetter) {
        int color = baseColorGetter.apply(tintIndex);
        if (FastColor.ARGB32.alpha((int)color) == 0) {
            color = FastColor.ARGB32.opaque((int)color);
        }
        return color;
    }

    public static interface BlockColorRegistrar {
        public void register(BlockColor var1, Block ... var2);
    }

    public static interface ItemColorRegistrar {
        public void register(ItemColor var1, ItemLike ... var2);
    }
}

