/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.events;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import com.verdantartifice.primalmagick.client.config.KeyBindings;
import com.verdantartifice.primalmagick.client.util.GuiUtils;
import com.verdantartifice.primalmagick.common.affinities.AffinityManager;
import com.verdantartifice.primalmagick.common.affinities.AffinityTooltipComponent;
import com.verdantartifice.primalmagick.common.capabilities.ManaStorage;
import com.verdantartifice.primalmagick.common.components.DataComponentsPM;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.items.armor.IManaDiscountGear;
import com.verdantartifice.primalmagick.common.items.armor.WardingModuleItem;
import com.verdantartifice.primalmagick.common.research.ResearchManager;
import com.verdantartifice.primalmagick.common.runes.RuneManager;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import com.verdantartifice.primalmagick.common.sources.Sources;
import com.verdantartifice.primalmagick.common.wands.IManaContainer;
import com.verdantartifice.primalmagick.common.wands.IWand;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;

public class ClientRenderEvents {
    public static void renderTooltip(ItemStack stack, Player player, List<Component> tooltip) {
        ManaStorage manaStorage;
        IWand wand;
        Item item = stack.getItem();
        if (item instanceof IManaDiscountGear) {
            IManaDiscountGear discountItem = (IManaDiscountGear)item;
            int discount = discountItem.getBestManaDiscount(stack, player);
            Optional<Source> attunedSource = discountItem.getAttunedSource(stack, player);
            attunedSource.ifPresentOrElse(source -> tooltip.add((Component)Component.translatable((String)"tooltip.primalmagick.mana_discount_attuned", (Object[])new Object[]{discount, source.getNameText(ChatFormatting.DARK_AQUA)}).withStyle(ChatFormatting.DARK_AQUA)), () -> tooltip.add((Component)Component.translatable((String)"tooltip.primalmagick.mana_discount", (Object[])new Object[]{discount}).withStyle(ChatFormatting.DARK_AQUA)));
        }
        if (RuneManager.hasRunes(stack)) {
            tooltip.add((Component)Component.translatable((String)"tooltip.primalmagick.runescribed").withStyle(ChatFormatting.DARK_AQUA));
        }
        if ((item = stack.getItem()) instanceof IWand && (wand = (IWand)item).isGlamoured(stack)) {
            tooltip.add((Component)Component.translatable((String)"tooltip.primalmagick.glamoured").withStyle(ChatFormatting.DARK_AQUA));
        }
        if (WardingModuleItem.hasWardAttached(stack)) {
            MutableComponent levelComponent = Component.translatable((String)("enchantment.level." + WardingModuleItem.getAttachedWardLevel(stack)));
            tooltip.add((Component)Component.translatable((String)"tooltip.primalmagick.warded").append(CommonComponents.SPACE).append((Component)levelComponent).withStyle(ChatFormatting.DARK_AQUA));
        }
        if (!(stack.getItem() instanceof IManaContainer) && (manaStorage = (ManaStorage)stack.get(DataComponentsPM.CAPABILITY_MANA_STORAGE.get())) != null) {
            Sources.getAllSorted().stream().filter(source -> source.isDiscovered(player) && manaStorage.canStore((Source)source)).forEach(source -> tooltip.add((Component)Component.translatable((String)"tooltip.primalmagick.source.mana_container", (Object[])new Object[]{source.getNameText(), (double)manaStorage.getManaStored((Source)source) / 100.0})));
        }
    }

    public static void onRenderTooltipGatherComponents(ItemStack stack, List<Either<FormattedText, TooltipComponent>> elements) {
        Minecraft mc = Minecraft.getInstance();
        Screen gui = mc.screen;
        if (gui instanceof AbstractContainerScreen && Services.INPUT.isKeyDown(KeyBindings.VIEW_AFFINITY_KEY) != Services.CONFIG.showAffinities() && !mc.mouseHandler.isMouseGrabbed() && stack != null && !stack.isEmpty()) {
            AffinityManager.getInstance().getAffinityValues(stack, (Level)mc.level).ifPresentOrElse(sources -> {
                if (sources.isEmpty()) {
                    elements.add(Either.left((Object)Component.translatable((String)"tooltip.primalmagick.affinities.none")));
                } else if (!ResearchManager.isScanned(stack, (Player)mc.player) && !Services.CONFIG.showUnscannedAffinities()) {
                    elements.add(Either.left((Object)Component.translatable((String)"tooltip.primalmagick.affinities.unknown")));
                } else {
                    elements.add(Either.left((Object)Component.translatable((String)"tooltip.primalmagick.affinities.label")));
                    if (Services.CONFIG.showAffinityIcons()) {
                        elements.add(Either.right((Object)new AffinityTooltipComponent((SourceList)sources)));
                    } else {
                        sources.getSourcesSorted().forEach(s -> elements.add(Either.left((Object)Component.translatable((String)"tooltip.primalmagick.affinities.text", (Object[])new Object[]{s.getNameText(), sources.getAmount((Source)s)}))));
                    }
                }
            }, () -> elements.add(Either.left((Object)Component.translatable((String)"tooltip.primalmagick.affinities.calculating"))));
        }
    }

    public static void onHighlightEntity(EntityHitResult target, PoseStack poseStack, MultiBufferSource multiBufferSource, float partialTicks) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player.getMainHandItem().getItem() == ItemsPM.ARCANOMETER.get() || mc.player.getOffhandItem().getItem() == ItemsPM.ARCANOMETER.get()) {
            Entity entity = target.getEntity();
            AffinityManager.getInstance().getAffinityValues(entity.getType(), entity.level().registryAccess()).ifPresent(affinities -> {
                boolean isScanned = ResearchManager.isScanned(entity.getType(), (Player)mc.player);
                if (isScanned && !affinities.isEmpty()) {
                    double interpolatedEntityX = entity.xo + (double)partialTicks * (entity.getX() - entity.xo);
                    double interpolatedEntityY = entity.yo + (double)partialTicks * (entity.getY() - entity.yo);
                    double interpolatedEntityZ = entity.zo + (double)partialTicks * (entity.getZ() - entity.zo);
                    GuiUtils.renderSourcesBillboard(poseStack, multiBufferSource, interpolatedEntityX, interpolatedEntityY + (double)entity.getBbHeight(), interpolatedEntityZ, affinities, partialTicks);
                }
            });
        }
    }
}

