/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.events;

import com.verdantartifice.primalmagick.client.books.LexiconLoader;
import com.verdantartifice.primalmagick.client.books.StyleGuideLoader;
import com.verdantartifice.primalmagick.client.fx.particles.DripParticlePM;
import com.verdantartifice.primalmagick.client.fx.particles.NoteEmitterParticle;
import com.verdantartifice.primalmagick.client.fx.particles.ParticleTypesPM;
import com.verdantartifice.primalmagick.client.fx.particles.PotionExplosionParticle;
import com.verdantartifice.primalmagick.client.tooltips.ClientAffinityTooltipComponent;
import com.verdantartifice.primalmagick.common.affinities.AffinityTooltipComponent;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import com.verdantartifice.primalmagick.common.wands.WandCap;
import com.verdantartifice.primalmagick.common.wands.WandCore;
import com.verdantartifice.primalmagick.common.wands.WandGem;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.inventory.tooltip.TooltipComponent;

public class ClientRegistrationEvents {
    public static void onRegisterParticleProviders(SpriteParticleProviderRegistrar sprite, SpecialParticleProviderRegistrar special) {
        special.register(ParticleTypesPM.POTION_EXPLOSION.get(), new PotionExplosionParticle.Factory());
        special.register(ParticleTypesPM.NOTE_EMITTER.get(), new NoteEmitterParticle.Factory());
        sprite.register((ParticleType)ParticleTypesPM.DRIPPING_BLOOD_DROP.get(), DripParticlePM::createBloodDropHangParticle);
        sprite.register((ParticleType)ParticleTypesPM.FALLING_BLOOD_DROP.get(), DripParticlePM::createBloodDropFallParticle);
        sprite.register((ParticleType)ParticleTypesPM.LANDING_BLOOD_DROP.get(), DripParticlePM::createBloodDropLandParticle);
    }

    public static void onModelRegister(Consumer<ModelResourceLocation> modelConsumer) {
        modelConsumer.accept(Services.MODEL_RESOURCE_LOCATIONS.createStandalone(ResourceUtils.loc("mundane_wand_core")));
        for (WandCore core : WandCore.getAllWandCores()) {
            modelConsumer.accept(Services.MODEL_RESOURCE_LOCATIONS.createStandalone(core.getWandModelResourceLocationNamespace()));
            modelConsumer.accept(Services.MODEL_RESOURCE_LOCATIONS.createStandalone(core.getStaffModelResourceLocationNamespace()));
        }
        for (WandCap cap : WandCap.getAllWandCaps()) {
            modelConsumer.accept(Services.MODEL_RESOURCE_LOCATIONS.createStandalone(cap.getWandModelResourceLocationNamespace()));
            modelConsumer.accept(Services.MODEL_RESOURCE_LOCATIONS.createStandalone(cap.getStaffModelResourceLocationNamespace()));
        }
        for (WandGem gem : WandGem.getAllWandGems()) {
            modelConsumer.accept(Services.MODEL_RESOURCE_LOCATIONS.createStandalone(gem.getModelResourceLocationNamespace()));
        }
        for (int index = 0; index <= 4; ++index) {
            modelConsumer.accept(Services.MODEL_RESOURCE_LOCATIONS.createStandalone(ResourceUtils.loc("arcanometer_" + index)));
        }
    }

    public static void onClientReloadListenerRegister(Consumer<PreparableReloadListener> reloadListenerConsumer) {
        reloadListenerConsumer.accept((PreparableReloadListener)ItemsPM.PRIMALITE_TRIDENT.get().getCustomRendererSupplier().get());
        reloadListenerConsumer.accept((PreparableReloadListener)ItemsPM.HEXIUM_TRIDENT.get().getCustomRendererSupplier().get());
        reloadListenerConsumer.accept((PreparableReloadListener)ItemsPM.HALLOWSTEEL_TRIDENT.get().getCustomRendererSupplier().get());
        reloadListenerConsumer.accept((PreparableReloadListener)ItemsPM.FORBIDDEN_TRIDENT.get().getCustomRendererSupplier().get());
        reloadListenerConsumer.accept((PreparableReloadListener)ItemsPM.PRIMALITE_SHIELD.get().getCustomRendererSupplier().get());
        reloadListenerConsumer.accept((PreparableReloadListener)ItemsPM.HEXIUM_SHIELD.get().getCustomRendererSupplier().get());
        reloadListenerConsumer.accept((PreparableReloadListener)ItemsPM.HALLOWSTEEL_SHIELD.get().getCustomRendererSupplier().get());
        reloadListenerConsumer.accept((PreparableReloadListener)ItemsPM.SPELLTOME_APPRENTICE.get().getCustomRendererSupplier().get());
        reloadListenerConsumer.accept((PreparableReloadListener)ItemsPM.SPELLTOME_ADEPT.get().getCustomRendererSupplier().get());
        reloadListenerConsumer.accept((PreparableReloadListener)ItemsPM.SPELLTOME_WIZARD.get().getCustomRendererSupplier().get());
        reloadListenerConsumer.accept((PreparableReloadListener)ItemsPM.SPELLTOME_ARCHMAGE.get().getCustomRendererSupplier().get());
        reloadListenerConsumer.accept((PreparableReloadListener)ItemsPM.MANA_ORB_APPRENTICE.get().getCustomRendererSupplier().get());
        reloadListenerConsumer.accept((PreparableReloadListener)ItemsPM.MANA_ORB_ADEPT.get().getCustomRendererSupplier().get());
        reloadListenerConsumer.accept((PreparableReloadListener)ItemsPM.MANA_ORB_WIZARD.get().getCustomRendererSupplier().get());
        reloadListenerConsumer.accept((PreparableReloadListener)ItemsPM.MANA_ORB_ARCHMAGE.get().getCustomRendererSupplier().get());
        reloadListenerConsumer.accept((PreparableReloadListener)ItemsPM.SPELLCRAFTING_ALTAR.get().getCustomRendererSupplier().get());
        reloadListenerConsumer.accept((PreparableReloadListener)ItemsPM.MANA_RELAY_BASIC.get().getCustomRendererSupplier().get());
        reloadListenerConsumer.accept((PreparableReloadListener)ItemsPM.MANA_RELAY_ENCHANTED.get().getCustomRendererSupplier().get());
        reloadListenerConsumer.accept((PreparableReloadListener)ItemsPM.MANA_RELAY_FORBIDDEN.get().getCustomRendererSupplier().get());
        reloadListenerConsumer.accept((PreparableReloadListener)ItemsPM.MANA_RELAY_HEAVENLY.get().getCustomRendererSupplier().get());
        reloadListenerConsumer.accept((PreparableReloadListener)ItemsPM.MANA_INJECTOR_BASIC.get().getCustomRendererSupplier().get());
        reloadListenerConsumer.accept((PreparableReloadListener)ItemsPM.MANA_INJECTOR_ENCHANTED.get().getCustomRendererSupplier().get());
        reloadListenerConsumer.accept((PreparableReloadListener)ItemsPM.MANA_INJECTOR_FORBIDDEN.get().getCustomRendererSupplier().get());
        reloadListenerConsumer.accept((PreparableReloadListener)ItemsPM.MANA_INJECTOR_HEAVENLY.get().getCustomRendererSupplier().get());
        reloadListenerConsumer.accept((PreparableReloadListener)ItemsPM.PIXIE_HOUSE.get().getCustomRendererSupplier().get());
        reloadListenerConsumer.accept((PreparableReloadListener)LexiconLoader.getOrCreateInstance());
        reloadListenerConsumer.accept((PreparableReloadListener)StyleGuideLoader.getOrCreateInstance());
    }

    public static void onRegisterClientTooltipComponentFactories(TooltipComponentRegistrar clientTooltipComponentRegistrar) {
        clientTooltipComponentRegistrar.register(AffinityTooltipComponent.class, ClientAffinityTooltipComponent::new);
    }

    public static interface SpecialParticleProviderRegistrar {
        public <T extends ParticleOptions> void register(ParticleType<T> var1, ParticleProvider<T> var2);
    }

    public static interface SpriteParticleProviderRegistrar {
        public <T extends ParticleOptions> void register(ParticleType<T> var1, ParticleProvider.Sprite<T> var2);
    }

    public static interface TooltipComponentRegistrar {
        public <T extends TooltipComponent> void register(Class<T> var1, Function<? super T, ? extends ClientTooltipComponent> var2);
    }
}

