/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.events;

import com.verdantartifice.primalmagick.client.gui.AnalysisTableScreen;
import com.verdantartifice.primalmagick.client.gui.ArcaneWorkbenchScreen;
import com.verdantartifice.primalmagick.client.gui.CalcinatorScreen;
import com.verdantartifice.primalmagick.client.gui.ConcocterScreen;
import com.verdantartifice.primalmagick.client.gui.DesalinatorScreen;
import com.verdantartifice.primalmagick.client.gui.DissolutionChamberScreen;
import com.verdantartifice.primalmagick.client.gui.EssenceCaskScreen;
import com.verdantartifice.primalmagick.client.gui.EssenceTransmuterScreen;
import com.verdantartifice.primalmagick.client.gui.HoneyExtractorScreen;
import com.verdantartifice.primalmagick.client.gui.InfernalFurnaceScreen;
import com.verdantartifice.primalmagick.client.gui.ManaBatteryScreen;
import com.verdantartifice.primalmagick.client.gui.ResearchTableScreen;
import com.verdantartifice.primalmagick.client.gui.RunecarvingTableScreen;
import com.verdantartifice.primalmagick.client.gui.RunescribingAltarBasicScreen;
import com.verdantartifice.primalmagick.client.gui.RunescribingAltarEnchantedScreen;
import com.verdantartifice.primalmagick.client.gui.RunescribingAltarForbiddenScreen;
import com.verdantartifice.primalmagick.client.gui.RunescribingAltarHeavenlyScreen;
import com.verdantartifice.primalmagick.client.gui.RunicGrindstoneScreen;
import com.verdantartifice.primalmagick.client.gui.SpellcraftingAltarScreen;
import com.verdantartifice.primalmagick.client.gui.WandAssemblyTableScreen;
import com.verdantartifice.primalmagick.client.gui.WandChargerScreen;
import com.verdantartifice.primalmagick.client.gui.WandGlamourTableScreen;
import com.verdantartifice.primalmagick.client.gui.WandInscriptionTableScreen;
import com.verdantartifice.primalmagick.client.gui.scribe_table.ScribeGainComprehensionScreen;
import com.verdantartifice.primalmagick.client.gui.scribe_table.ScribeStudyVocabularyScreen;
import com.verdantartifice.primalmagick.client.gui.scribe_table.ScribeTranscribeWorksScreen;
import com.verdantartifice.primalmagick.client.renderers.tile.AutoChargerTER;
import com.verdantartifice.primalmagick.client.renderers.tile.ManaFontTER;
import com.verdantartifice.primalmagick.client.renderers.tile.ManaInjectorTER;
import com.verdantartifice.primalmagick.client.renderers.tile.ManaRelayTER;
import com.verdantartifice.primalmagick.client.renderers.tile.OfferingPedestalTER;
import com.verdantartifice.primalmagick.client.renderers.tile.RitualAltarTER;
import com.verdantartifice.primalmagick.client.renderers.tile.RitualBellTER;
import com.verdantartifice.primalmagick.client.renderers.tile.RitualLecternTER;
import com.verdantartifice.primalmagick.client.renderers.tile.RunescribingAltarTER;
import com.verdantartifice.primalmagick.client.renderers.tile.SanguineCrucibleTER;
import com.verdantartifice.primalmagick.client.renderers.tile.SpellcraftingAltarTER;
import com.verdantartifice.primalmagick.client.renderers.tile.WandChargerTER;
import com.verdantartifice.primalmagick.client.renderers.tile.WindGeneratorTER;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.items.entities.FlyingCarpetItem;
import com.verdantartifice.primalmagick.common.items.misc.ArcanometerItem;
import com.verdantartifice.primalmagick.common.menus.MenuTypesPM;
import com.verdantartifice.primalmagick.common.tiles.BlockEntityTypesPM;
import com.verdantartifice.primalmagick.common.util.RayTraceUtils;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ClientModLifecycleEvents {
    private static final AtomicBoolean INITIALIZED = new AtomicBoolean(false);

    public static void clientSetup(Consumer<Runnable> workConsumer) {
        if (INITIALIZED.compareAndSet(false, true)) {
            ClientModLifecycleEvents.registerScreens();
            ClientModLifecycleEvents.registerTERs();
            ClientModLifecycleEvents.registerItemProperties(workConsumer);
        }
    }

    private static void registerScreens() {
        MenuScreens.register(MenuTypesPM.ARCANE_WORKBENCH.get(), ArcaneWorkbenchScreen::new);
        MenuScreens.register(MenuTypesPM.WAND_ASSEMBLY_TABLE.get(), WandAssemblyTableScreen::new);
        MenuScreens.register(MenuTypesPM.ANALYSIS_TABLE.get(), AnalysisTableScreen::new);
        MenuScreens.register(MenuTypesPM.CALCINATOR.get(), CalcinatorScreen::new);
        MenuScreens.register(MenuTypesPM.WAND_INSCRIPTION_TABLE.get(), WandInscriptionTableScreen::new);
        MenuScreens.register(MenuTypesPM.SPELLCRAFTING_ALTAR.get(), SpellcraftingAltarScreen::new);
        MenuScreens.register(MenuTypesPM.WAND_CHARGER.get(), WandChargerScreen::new);
        MenuScreens.register(MenuTypesPM.RESEARCH_TABLE.get(), ResearchTableScreen::new);
        MenuScreens.register(MenuTypesPM.RUNESCRIBING_ALTAR_BASIC.get(), RunescribingAltarBasicScreen::new);
        MenuScreens.register(MenuTypesPM.RUNESCRIBING_ALTAR_ENCHANTED.get(), RunescribingAltarEnchantedScreen::new);
        MenuScreens.register(MenuTypesPM.RUNESCRIBING_ALTAR_FORBIDDEN.get(), RunescribingAltarForbiddenScreen::new);
        MenuScreens.register(MenuTypesPM.RUNESCRIBING_ALTAR_HEAVENLY.get(), RunescribingAltarHeavenlyScreen::new);
        MenuScreens.register(MenuTypesPM.RUNECARVING_TABLE.get(), RunecarvingTableScreen::new);
        MenuScreens.register(MenuTypesPM.HONEY_EXTRACTOR.get(), HoneyExtractorScreen::new);
        MenuScreens.register(MenuTypesPM.CONCOCTER.get(), ConcocterScreen::new);
        MenuScreens.register(MenuTypesPM.ESSENCE_TRANSMUTER.get(), EssenceTransmuterScreen::new);
        MenuScreens.register(MenuTypesPM.DISSOLUTION_CHAMBER.get(), DissolutionChamberScreen::new);
        MenuScreens.register(MenuTypesPM.ESSENCE_CASK.get(), EssenceCaskScreen::new);
        MenuScreens.register(MenuTypesPM.WAND_GLAMOUR_TABLE.get(), WandGlamourTableScreen::new);
        MenuScreens.register(MenuTypesPM.RUNIC_GRINDSTONE.get(), RunicGrindstoneScreen::new);
        MenuScreens.register(MenuTypesPM.INFERNAL_FURNACE.get(), InfernalFurnaceScreen::new);
        MenuScreens.register(MenuTypesPM.MANA_BATTERY.get(), ManaBatteryScreen::new);
        MenuScreens.register(MenuTypesPM.SCRIBE_STUDY_VOCABULARY.get(), ScribeStudyVocabularyScreen::new);
        MenuScreens.register(MenuTypesPM.SCRIBE_GAIN_COMPREHENSION.get(), ScribeGainComprehensionScreen::new);
        MenuScreens.register(MenuTypesPM.SCRIBE_TRANSCRIBE_WORKS.get(), ScribeTranscribeWorksScreen::new);
        MenuScreens.register(MenuTypesPM.DESALINATOR.get(), DesalinatorScreen::new);
    }

    private static void registerTERs() {
        BlockEntityRenderers.register(BlockEntityTypesPM.ANCIENT_MANA_FONT.get(), ManaFontTER::new);
        BlockEntityRenderers.register(BlockEntityTypesPM.ARTIFICIAL_MANA_FONT.get(), ManaFontTER::new);
        BlockEntityRenderers.register(BlockEntityTypesPM.WAND_CHARGER.get(), WandChargerTER::new);
        BlockEntityRenderers.register(BlockEntityTypesPM.RITUAL_ALTAR.get(), RitualAltarTER::new);
        BlockEntityRenderers.register(BlockEntityTypesPM.OFFERING_PEDESTAL.get(), OfferingPedestalTER::new);
        BlockEntityRenderers.register(BlockEntityTypesPM.RITUAL_LECTERN.get(), RitualLecternTER::new);
        BlockEntityRenderers.register(BlockEntityTypesPM.RITUAL_BELL.get(), RitualBellTER::new);
        BlockEntityRenderers.register(BlockEntityTypesPM.RUNESCRIBING_ALTAR.get(), RunescribingAltarTER::new);
        BlockEntityRenderers.register(BlockEntityTypesPM.SANGUINE_CRUCIBLE.get(), SanguineCrucibleTER::new);
        BlockEntityRenderers.register(BlockEntityTypesPM.AUTO_CHARGER.get(), AutoChargerTER::new);
        BlockEntityRenderers.register(BlockEntityTypesPM.SPELLCRAFTING_ALTAR.get(), SpellcraftingAltarTER::new);
        BlockEntityRenderers.register(BlockEntityTypesPM.WIND_GENERATOR.get(), WindGeneratorTER::new);
        BlockEntityRenderers.register(BlockEntityTypesPM.MANA_RELAY.get(), ManaRelayTER::new);
        BlockEntityRenderers.register(BlockEntityTypesPM.MANA_INJECTOR.get(), ManaInjectorTER::new);
    }

    private static void registerItemProperties(Consumer<Runnable> workConsumer) {
        workConsumer.accept(() -> {
            ItemProperties.register((Item)ItemsPM.ARCANOMETER.get(), (ResourceLocation)ArcanometerItem.SCAN_STATE_PROPERTY, (ClampedItemPropertyFunction)new ClampedItemPropertyFunction(){
                private float scanState = 0.0f;

                public float unclampedCall(ItemStack stack, ClientLevel world, LivingEntity entity, int seed) {
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        if (ArcanometerItem.isMouseOverScannable(RayTraceUtils.getMouseOver((Level)world, player), (Level)world, player)) {
                            this.incrementScanState();
                        } else {
                            this.decrementScanState();
                        }
                        return this.scanState;
                    }
                    return 0.0f;
                }

                private void incrementScanState() {
                    this.scanState = Math.min(1.0f, this.scanState + 0.0625f);
                }

                private void decrementScanState() {
                    this.scanState = Math.max(0.0f, this.scanState - 0.0625f);
                }
            });
            ItemProperties.register((Item)ItemsPM.FLYING_CARPET.get(), (ResourceLocation)FlyingCarpetItem.COLOR_PROPERTY, (stack, world, entity, seed) -> {
                DyeColor color = null;
                if (stack != null && stack.getItem() instanceof FlyingCarpetItem) {
                    color = ((FlyingCarpetItem)stack.getItem()).getDyeColor(stack);
                }
                if (color == null) {
                    color = DyeColor.WHITE;
                }
                return (float)color.getId() / 16.0f;
            });
            ClampedItemPropertyFunction castProperty = (stack, world, entity, seed) -> {
                boolean inOff;
                if (entity == null) {
                    return 0.0f;
                }
                boolean inMain = entity.getMainHandItem() == stack;
                boolean bl = inOff = entity.getOffhandItem() == stack;
                if (entity.getMainHandItem().getItem() instanceof FishingRodItem) {
                    inOff = false;
                }
                return (inMain || inOff) && entity instanceof Player && ((Player)entity).fishing != null ? 1.0f : 0.0f;
            };
            ItemProperties.register((Item)((Item)ItemsPM.PRIMALITE_FISHING_ROD.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"cast"), (ClampedItemPropertyFunction)castProperty);
            ItemProperties.register((Item)((Item)ItemsPM.HEXIUM_FISHING_ROD.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"cast"), (ClampedItemPropertyFunction)castProperty);
            ItemProperties.register((Item)((Item)ItemsPM.HALLOWSTEEL_FISHING_ROD.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"cast"), (ClampedItemPropertyFunction)castProperty);
            ItemProperties.register((Item)((Item)ItemsPM.PRIMAL_FISHING_ROD.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"cast"), (ClampedItemPropertyFunction)castProperty);
            ClampedItemPropertyFunction handActiveProperty = (stack, world, entity, seed) -> entity != null && entity.isUsingItem() && entity.getUseItem() == stack ? 1.0f : 0.0f;
            ItemProperties.register((Item)((Item)ItemsPM.PRIMALITE_TRIDENT.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"throwing"), (ClampedItemPropertyFunction)handActiveProperty);
            ItemProperties.register((Item)((Item)ItemsPM.HEXIUM_TRIDENT.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"throwing"), (ClampedItemPropertyFunction)handActiveProperty);
            ItemProperties.register((Item)((Item)ItemsPM.HALLOWSTEEL_TRIDENT.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"throwing"), (ClampedItemPropertyFunction)handActiveProperty);
            ItemProperties.register((Item)((Item)ItemsPM.FORBIDDEN_TRIDENT.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"throwing"), (ClampedItemPropertyFunction)handActiveProperty);
            ItemProperties.register((Item)((Item)ItemsPM.PRIMALITE_SHIELD.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"blocking"), (ClampedItemPropertyFunction)handActiveProperty);
            ItemProperties.register((Item)((Item)ItemsPM.HEXIUM_SHIELD.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"blocking"), (ClampedItemPropertyFunction)handActiveProperty);
            ItemProperties.register((Item)((Item)ItemsPM.HALLOWSTEEL_SHIELD.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"blocking"), (ClampedItemPropertyFunction)handActiveProperty);
            ItemProperties.register((Item)((Item)ItemsPM.SACRED_SHIELD.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"blocking"), (ClampedItemPropertyFunction)handActiveProperty);
            ClampedItemPropertyFunction pullProperty = (stack, world, entity, seed) -> {
                if (entity == null) {
                    return 0.0f;
                }
                return entity.getUseItem() != stack ? 0.0f : (float)(stack.getUseDuration(entity) - entity.getUseItemRemainingTicks()) / 20.0f;
            };
            ItemProperties.register((Item)((Item)ItemsPM.PRIMALITE_BOW.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"pull"), (ClampedItemPropertyFunction)pullProperty);
            ItemProperties.register((Item)((Item)ItemsPM.PRIMALITE_BOW.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"pulling"), (ClampedItemPropertyFunction)handActiveProperty);
            ItemProperties.register((Item)((Item)ItemsPM.HEXIUM_BOW.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"pull"), (ClampedItemPropertyFunction)pullProperty);
            ItemProperties.register((Item)((Item)ItemsPM.HEXIUM_BOW.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"pulling"), (ClampedItemPropertyFunction)handActiveProperty);
            ItemProperties.register((Item)((Item)ItemsPM.HALLOWSTEEL_BOW.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"pull"), (ClampedItemPropertyFunction)pullProperty);
            ItemProperties.register((Item)((Item)ItemsPM.HALLOWSTEEL_BOW.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"pulling"), (ClampedItemPropertyFunction)handActiveProperty);
            ItemProperties.register((Item)((Item)ItemsPM.FORBIDDEN_BOW.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"pull"), (ClampedItemPropertyFunction)pullProperty);
            ItemProperties.register((Item)((Item)ItemsPM.FORBIDDEN_BOW.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"pulling"), (ClampedItemPropertyFunction)handActiveProperty);
        });
    }
}

