/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.compat.jei.runecarving;

import com.verdantartifice.primalmagick.client.compat.jei.JeiHelper;
import com.verdantartifice.primalmagick.client.compat.jei.JeiRecipeTypesPM;
import com.verdantartifice.primalmagick.client.compat.jei.RecipeCategoryPM;
import com.verdantartifice.primalmagick.client.util.RecipeUtils;
import com.verdantartifice.primalmagick.common.crafting.IRunecarvingRecipe;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.research.requirements.AbstractRequirement;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import java.util.Optional;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;

public class RunecarvingRecipeCategory
extends RecipeCategoryPM<RecipeHolder<IRunecarvingRecipe>> {
    public static final ResourceLocation UID = ResourceUtils.loc("runecarving_table");
    private static final ResourceLocation BACKGROUND_TEXTURE = ResourceUtils.loc("textures/gui/jei/runecarving_table.png");
    private static final ResourceLocation RESEARCH_TEXTURE = ResourceUtils.loc("textures/item/grimoire.png");
    private static final int RESEARCH_X_OFFSET = 79;
    private static final int RESEARCH_Y_OFFSET = 19;
    private static final int BG_WIDTH = 125;
    private static final int BG_HEIGHT = 36;
    private final IDrawableStatic background;
    private final IDrawableStatic researchIcon;

    public RunecarvingRecipeCategory(IGuiHelper guiHelper) {
        super(guiHelper, UID, "block.primalmagick.runecarving_table");
        this.researchIcon = guiHelper.drawableBuilder(RESEARCH_TEXTURE, 0, 0, 32, 32).setTextureSize(32, 32).build();
        this.background = guiHelper.createDrawable(BACKGROUND_TEXTURE, 0, 0, 125, 36);
        this.setIcon(new ItemStack((ItemLike)ItemsPM.RUNECARVING_TABLE.get()));
    }

    public int getWidth() {
        return 125;
    }

    public int getHeight() {
        return 36;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<IRunecarvingRecipe> recipeHolder, IFocusGroup focuses) {
        IRunecarvingRecipe recipe = (IRunecarvingRecipe)recipeHolder.value();
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).addIngredients((Ingredient)recipe.getIngredients().get(0));
        builder.addSlot(RecipeIngredientRole.INPUT, 50, 1).addIngredients((Ingredient)recipe.getIngredients().get(1));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 108, 1).addItemStack(RecipeUtils.getResultItem(recipe));
    }

    public void draw(RecipeHolder<IRunecarvingRecipe> recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.background.draw(guiGraphics);
        if (((IRunecarvingRecipe)recipe.value()).getRequirement().isPresent()) {
            guiGraphics.pose().pushPose();
            guiGraphics.pose().scale(0.5f, 0.5f, 0.5f);
            this.researchIcon.draw(guiGraphics, 158, 38);
            guiGraphics.pose().popPose();
        }
    }

    public void getTooltip(ITooltipBuilder builder, RecipeHolder<IRunecarvingRecipe> recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        Minecraft mc = Minecraft.getInstance();
        Optional requirementOpt = ((IRunecarvingRecipe)recipe.value()).getRequirement();
        if (requirementOpt.isPresent() && mouseX >= 79.0 && mouseX < (double)(79 + this.researchIcon.getWidth()) && mouseY >= 19.0 && mouseY < (double)(19 + this.researchIcon.getHeight())) {
            builder.addAll(JeiHelper.getRequirementTooltipStrings(mc.level.registryAccess(), (AbstractRequirement)requirementOpt.get()));
        } else {
            super.getTooltip(builder, recipe, recipeSlotsView, mouseX, mouseY);
        }
    }

    public RecipeType<RecipeHolder<IRunecarvingRecipe>> getRecipeType() {
        return JeiRecipeTypesPM.RUNECARVING;
    }
}

