/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.compat.jei.ritual;

import com.verdantartifice.primalmagick.client.compat.jei.JeiHelper;
import com.verdantartifice.primalmagick.client.compat.jei.JeiRecipeTypesPM;
import com.verdantartifice.primalmagick.client.compat.jei.RecipeCategoryPM;
import com.verdantartifice.primalmagick.client.util.RecipeUtils;
import com.verdantartifice.primalmagick.common.crafting.IRitualRecipe;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.research.requirements.AbstractRequirement;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import java.awt.Color;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;

public class RitualRecipeCategory
extends RecipeCategoryPM<RecipeHolder<IRitualRecipe>> {
    public static final ResourceLocation UID = ResourceUtils.loc("ritual_altar");
    private static final ResourceLocation BACKGROUND_TEXTURE = ResourceUtils.loc("textures/gui/jei/ritual_altar.png");
    private static final ResourceLocation RESEARCH_TEXTURE = ResourceUtils.loc("textures/item/grimoire.png");
    private static final int MANA_COST_X_OFFSET = 118;
    private static final int MANA_COST_Y_OFFSET = 14;
    private static final int RESEARCH_X_OFFSET = 118;
    private static final int RESEARCH_Y_OFFSET = 49;
    private static final int BG_WIDTH = 170;
    private static final int BG_HEIGHT = 80;
    private final IDrawableStatic background;
    private final IDrawableStatic manaCostIcon;
    private final IDrawableStatic researchIcon;

    public RitualRecipeCategory(IGuiHelper guiHelper) {
        super(guiHelper, UID, "block.primalmagick.ritual_altar");
        this.manaCostIcon = guiHelper.createDrawable(BACKGROUND_TEXTURE, 170, 0, 16, 16);
        this.researchIcon = guiHelper.drawableBuilder(RESEARCH_TEXTURE, 0, 0, 32, 32).setTextureSize(32, 32).build();
        this.background = guiHelper.createDrawable(BACKGROUND_TEXTURE, 0, 0, 170, 80);
        this.setIcon(new ItemStack((ItemLike)ItemsPM.RITUAL_ALTAR.get()));
    }

    public int getWidth() {
        return 170;
    }

    public int getHeight() {
        return 80;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<IRitualRecipe> recipeHolder, IFocusGroup focuses) {
        int index;
        IRitualRecipe recipe = (IRitualRecipe)recipeHolder.value();
        NonNullList offerings = recipe.getIngredients();
        List<Ingredient> props = recipe.getProps().stream().map(b -> b.asIngredient()).toList();
        int ingredientCount = recipe.getIngredients().size();
        int propCount = recipe.getProps().size();
        for (index = 0; index < ingredientCount; ++index) {
            builder.addSlot(RecipeIngredientRole.INPUT, 1 + index % 6 * 18, 14 + index / 6 * 18).addIngredients((Ingredient)offerings.get(index));
        }
        for (index = 0; index < propCount; ++index) {
            builder.addSlot(RecipeIngredientRole.INPUT, 1 + index % 6 * 18, 63 + index / 6 * 18).addIngredients(props.get(index));
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 149, 32).addItemStack(RecipeUtils.getResultItem(recipe));
    }

    public void draw(RecipeHolder<IRitualRecipe> recipeHolder, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.background.draw(guiGraphics);
        Minecraft mc = Minecraft.getInstance();
        guiGraphics.drawString(mc.font, (Component)Component.translatable((String)"jei.primalmagick.ritual.offerings.header"), 0, 2, Color.BLACK.getRGB(), false);
        guiGraphics.drawString(mc.font, (Component)Component.translatable((String)"jei.primalmagick.ritual.props.header"), 0, 51, Color.BLACK.getRGB(), false);
        IRitualRecipe recipe = (IRitualRecipe)recipeHolder.value();
        if (!recipe.getManaCosts().isEmpty()) {
            this.manaCostIcon.draw(guiGraphics, 118, 14);
        }
        if (recipe.getRequirement().isPresent()) {
            guiGraphics.pose().pushPose();
            guiGraphics.pose().scale(0.5f, 0.5f, 0.5f);
            this.researchIcon.draw(guiGraphics, 236, 98);
            guiGraphics.pose().popPose();
        }
    }

    public void getTooltip(ITooltipBuilder builder, RecipeHolder<IRitualRecipe> recipeHolder, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        Minecraft mc = Minecraft.getInstance();
        IRitualRecipe recipe = (IRitualRecipe)recipeHolder.value();
        SourceList manaCosts = recipe.getManaCosts();
        Optional requirementOpt = recipe.getRequirement();
        if (!manaCosts.isEmpty() && mouseX >= 118.0 && mouseX < (double)(118 + this.manaCostIcon.getWidth()) && mouseY >= 14.0 && mouseY < (double)(14 + this.manaCostIcon.getHeight())) {
            builder.addAll(JeiHelper.getManaCostTooltipStrings(manaCosts));
        } else if (requirementOpt.isPresent() && mouseX >= 118.0 && mouseX < (double)(118 + this.researchIcon.getWidth()) && mouseY >= 49.0 && mouseY < (double)(49 + this.researchIcon.getHeight())) {
            builder.addAll(JeiHelper.getRequirementTooltipStrings(mc.level.registryAccess(), (AbstractRequirement)requirementOpt.get()));
        } else {
            super.getTooltip(builder, recipeHolder, recipeSlotsView, mouseX, mouseY);
        }
    }

    public RecipeType<RecipeHolder<IRitualRecipe>> getRecipeType() {
        return JeiRecipeTypesPM.RITUAL;
    }
}

