/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.compat.jei.arcane_crafting;

import com.verdantartifice.primalmagick.client.compat.jei.JeiHelper;
import com.verdantartifice.primalmagick.client.compat.jei.JeiRecipeTypesPM;
import com.verdantartifice.primalmagick.client.compat.jei.RecipeCategoryPM;
import com.verdantartifice.primalmagick.client.util.RecipeUtils;
import com.verdantartifice.primalmagick.common.crafting.IArcaneRecipe;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.research.requirements.AbstractRequirement;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;

public class ArcaneCraftingRecipeCategory
extends RecipeCategoryPM<RecipeHolder<IArcaneRecipe>> {
    public static final ResourceLocation UID = ResourceUtils.loc("arcane_workbench");
    private static final ResourceLocation BACKGROUND_TEXTURE = ResourceUtils.loc("textures/gui/jei/arcane_workbench.png");
    private static final ResourceLocation RESEARCH_TEXTURE = ResourceUtils.loc("textures/item/grimoire.png");
    private static final int MANA_COST_X_OFFSET = 64;
    private static final int MANA_COST_Y_OFFSET = 1;
    private static final int RESEARCH_X_OFFSET = 64;
    private static final int RESEARCH_Y_OFFSET = 36;
    private static final int BG_WIDTH = 116;
    private static final int BG_HEIGHT = 54;
    private final ICraftingGridHelper craftingGridHelper;
    private final IDrawableStatic background;
    private final IDrawableStatic manaCostIcon;
    private final IDrawableStatic researchIcon;

    public ArcaneCraftingRecipeCategory(IGuiHelper guiHelper) {
        super(guiHelper, UID, "block.primalmagick.arcane_workbench");
        this.craftingGridHelper = guiHelper.createCraftingGridHelper();
        this.manaCostIcon = guiHelper.createDrawable(BACKGROUND_TEXTURE, 116, 0, 16, 16);
        this.researchIcon = guiHelper.drawableBuilder(RESEARCH_TEXTURE, 0, 0, 32, 32).setTextureSize(32, 32).build();
        this.background = guiHelper.createDrawable(BACKGROUND_TEXTURE, 0, 0, 116, 54);
        this.setIcon(new ItemStack((ItemLike)ItemsPM.ARCANE_WORKBENCH.get()));
    }

    public int getWidth() {
        return 116;
    }

    public int getHeight() {
        return 54;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<IArcaneRecipe> recipe, IFocusGroup focuses) {
        int n;
        int n2;
        this.craftingGridHelper.createAndSetOutputs(builder, (IIngredientType)VanillaTypes.ITEM_STACK, List.of(RecipeUtils.getResultItem(recipe.value())));
        Recipe recipe2 = recipe.value();
        if (recipe2 instanceof ShapedRecipe) {
            ShapedRecipe shapedRecipe = (ShapedRecipe)recipe2;
            n2 = shapedRecipe.getWidth();
        } else {
            n2 = 0;
        }
        int width = n2;
        Recipe recipe3 = recipe.value();
        if (recipe3 instanceof ShapedRecipe) {
            ShapedRecipe shapedRecipe = (ShapedRecipe)recipe3;
            n = shapedRecipe.getHeight();
        } else {
            n = 0;
        }
        int height = n;
        List<List> inputs = ((IArcaneRecipe)recipe.value()).getIngredients().stream().map(ingredient -> List.of(ingredient.getItems())).toList();
        this.craftingGridHelper.createAndSetInputs(builder, (IIngredientType)VanillaTypes.ITEM_STACK, inputs, width, height);
    }

    public void draw(RecipeHolder<IArcaneRecipe> recipeHolder, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        IArcaneRecipe recipe = (IArcaneRecipe)recipeHolder.value();
        this.background.draw(guiGraphics);
        if (!recipe.getManaCosts().isEmpty()) {
            this.manaCostIcon.draw(guiGraphics, 64, 1);
        }
        if (recipe.getRequirement().isPresent()) {
            guiGraphics.pose().pushPose();
            guiGraphics.pose().scale(0.5f, 0.5f, 0.5f);
            this.researchIcon.draw(guiGraphics, 128, 72);
            guiGraphics.pose().popPose();
        }
    }

    public void getTooltip(ITooltipBuilder builder, RecipeHolder<IArcaneRecipe> recipeHolder, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        Minecraft mc = Minecraft.getInstance();
        IArcaneRecipe recipe = (IArcaneRecipe)recipeHolder.value();
        SourceList manaCosts = recipe.getManaCosts();
        Optional requirementOpt = recipe.getRequirement();
        if (!manaCosts.isEmpty() && mouseX >= 64.0 && mouseX < (double)(64 + this.manaCostIcon.getWidth()) && mouseY >= 1.0 && mouseY < (double)(1 + this.manaCostIcon.getHeight())) {
            builder.addAll(JeiHelper.getManaCostTooltipStrings(manaCosts));
        } else if (requirementOpt.isPresent() && mouseX >= 64.0 && mouseX < (double)(64 + this.researchIcon.getWidth()) && mouseY >= 36.0 && mouseY < (double)(36 + this.researchIcon.getHeight())) {
            builder.addAll(JeiHelper.getRequirementTooltipStrings(mc.level.registryAccess(), (AbstractRequirement)requirementOpt.get()));
        } else {
            super.getTooltip(builder, recipeHolder, recipeSlotsView, mouseX, mouseY);
        }
    }

    public RecipeType<RecipeHolder<IArcaneRecipe>> getRecipeType() {
        return JeiRecipeTypesPM.ARCANE_CRAFTING;
    }
}

