/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.compat.jei;

import com.verdantartifice.primalmagick.client.compat.jei.CategoryRecipes;
import com.verdantartifice.primalmagick.client.compat.jei.JeiRecipeTypesPM;
import com.verdantartifice.primalmagick.client.compat.jei.arcane_crafting.ArcaneCraftingRecipeCategory;
import com.verdantartifice.primalmagick.client.compat.jei.concocting.ConcoctingRecipeCategory;
import com.verdantartifice.primalmagick.client.compat.jei.concocting.ConcoctionSubtypeInterpreter;
import com.verdantartifice.primalmagick.client.compat.jei.dissolution.DissolutionRecipeCategory;
import com.verdantartifice.primalmagick.client.compat.jei.ritual.RitualRecipeCategory;
import com.verdantartifice.primalmagick.client.compat.jei.runecarving.RunecarvingRecipeCategory;
import com.verdantartifice.primalmagick.client.gui.ArcaneWorkbenchScreen;
import com.verdantartifice.primalmagick.client.gui.ConcocterScreen;
import com.verdantartifice.primalmagick.client.gui.DissolutionChamberScreen;
import com.verdantartifice.primalmagick.client.gui.InfernalFurnaceScreen;
import com.verdantartifice.primalmagick.common.blocks.BlocksPM;
import com.verdantartifice.primalmagick.common.crafting.IArcaneRecipe;
import com.verdantartifice.primalmagick.common.crafting.IConcoctingRecipe;
import com.verdantartifice.primalmagick.common.crafting.IDissolutionRecipe;
import com.verdantartifice.primalmagick.common.crafting.IRitualRecipe;
import com.verdantartifice.primalmagick.common.crafting.IRunecarvingRecipe;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.menus.ArcaneWorkbenchMenu;
import com.verdantartifice.primalmagick.common.menus.ConcocterMenu;
import com.verdantartifice.primalmagick.common.menus.DissolutionChamberMenu;
import com.verdantartifice.primalmagick.common.menus.InfernalFurnaceMenu;
import com.verdantartifice.primalmagick.common.menus.MenuTypesPM;
import com.verdantartifice.primalmagick.common.research.ResearchDiscipline;
import com.verdantartifice.primalmagick.common.research.ResearchDisciplines;
import com.verdantartifice.primalmagick.common.research.ResearchEntries;
import com.verdantartifice.primalmagick.common.research.ResearchEntry;
import com.verdantartifice.primalmagick.common.research.keys.ResearchEntryKey;
import com.verdantartifice.primalmagick.common.research.keys.ResearchStageKey;
import com.verdantartifice.primalmagick.common.research.requirements.AbstractRequirement;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class JeiHelper
implements IModPlugin {
    private static final ResourceLocation UID = ResourceUtils.loc("jei");
    private static final DecimalFormat MANA_FORMATTER = new DecimalFormat("#######.##");
    @Nullable
    private IRecipeCategory<RecipeHolder<IArcaneRecipe>> arcaneCategory;
    @Nullable
    private IRecipeCategory<RecipeHolder<IConcoctingRecipe>> concoctingCategory;
    @Nullable
    private IRecipeCategory<RecipeHolder<IRunecarvingRecipe>> runecarvingCategory;
    @Nullable
    private IRecipeCategory<RecipeHolder<IDissolutionRecipe>> dissolutionCategory;
    @Nullable
    private IRecipeCategory<RecipeHolder<IRitualRecipe>> ritualCategory;

    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)ItemsPM.CONCOCTION.get(), (ISubtypeInterpreter)ConcoctionSubtypeInterpreter.INSTANCE);
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)ItemsPM.ALCHEMICAL_BOMB.get(), (ISubtypeInterpreter)ConcoctionSubtypeInterpreter.INSTANCE);
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        this.arcaneCategory = new ArcaneCraftingRecipeCategory(guiHelper);
        this.concoctingCategory = new ConcoctingRecipeCategory(guiHelper);
        this.runecarvingCategory = new RunecarvingRecipeCategory(guiHelper);
        this.dissolutionCategory = new DissolutionRecipeCategory(guiHelper);
        this.ritualCategory = new RitualRecipeCategory(guiHelper);
        registration.addRecipeCategories(new IRecipeCategory[]{this.arcaneCategory, this.concoctingCategory, this.runecarvingCategory, this.dissolutionCategory, this.ritualCategory});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        CategoryRecipes categoryRecipes = new CategoryRecipes();
        if (this.arcaneCategory != null) {
            registration.addRecipes(JeiRecipeTypesPM.ARCANE_CRAFTING, categoryRecipes.getArcaneRecipes(this.arcaneCategory));
        }
        if (this.concoctingCategory != null) {
            registration.addRecipes(JeiRecipeTypesPM.CONCOCTING, categoryRecipes.getConcoctingRecipes(this.concoctingCategory));
        }
        if (this.runecarvingCategory != null) {
            registration.addRecipes(JeiRecipeTypesPM.RUNECARVING, categoryRecipes.getRunecarvingRecipes(this.runecarvingCategory));
        }
        if (this.dissolutionCategory != null) {
            registration.addRecipes(JeiRecipeTypesPM.DISSOLUTION, categoryRecipes.getDissolutionRecipes(this.dissolutionCategory));
        }
        if (this.ritualCategory != null) {
            registration.addRecipes(JeiRecipeTypesPM.RITUAL, categoryRecipes.getRitualRecipes(this.ritualCategory));
        }
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlocksPM.ARCANE_WORKBENCH.get()), new RecipeType[]{RecipeTypes.CRAFTING, JeiRecipeTypesPM.ARCANE_CRAFTING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlocksPM.INFERNAL_FURNACE.get()), new RecipeType[]{RecipeTypes.SMELTING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlocksPM.CONCOCTER.get()), new RecipeType[]{JeiRecipeTypesPM.CONCOCTING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlocksPM.RUNECARVING_TABLE.get()), new RecipeType[]{JeiRecipeTypesPM.RUNECARVING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlocksPM.DISSOLUTION_CHAMBER.get()), new RecipeType[]{JeiRecipeTypesPM.DISSOLUTION});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlocksPM.RITUAL_ALTAR.get()), new RecipeType[]{JeiRecipeTypesPM.RITUAL});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(ArcaneWorkbenchMenu.class, MenuTypesPM.ARCANE_WORKBENCH.get(), JeiRecipeTypesPM.ARCANE_CRAFTING, 1, 9, 11, 36);
        registration.addRecipeTransferHandler(ConcocterMenu.class, MenuTypesPM.CONCOCTER.get(), JeiRecipeTypesPM.CONCOCTING, 1, 9, 11, 36);
        registration.addRecipeTransferHandler(DissolutionChamberMenu.class, MenuTypesPM.DISSOLUTION_CHAMBER.get(), JeiRecipeTypesPM.DISSOLUTION, 1, 1, 3, 36);
        registration.addRecipeTransferHandler(InfernalFurnaceMenu.class, MenuTypesPM.INFERNAL_FURNACE.get(), RecipeTypes.SMELTING, 1, 1, 4, 36);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(ArcaneWorkbenchScreen.class, 104, 52, 22, 15, new RecipeType[]{JeiRecipeTypesPM.ARCANE_CRAFTING});
        registration.addRecipeClickArea(ConcocterScreen.class, 104, 35, 22, 15, new RecipeType[]{JeiRecipeTypesPM.CONCOCTING});
        registration.addRecipeClickArea(DissolutionChamberScreen.class, 79, 35, 22, 15, new RecipeType[]{JeiRecipeTypesPM.DISSOLUTION});
        registration.addRecipeClickArea(InfernalFurnaceScreen.class, 79, 35, 22, 15, new RecipeType[]{RecipeTypes.SMELTING});
    }

    public static List<Component> getManaCostTooltipStrings(SourceList manaCosts) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        tooltip.add((Component)Component.translatable((String)"label.primalmagick.crafting.mana_cost_header"));
        for (Source source : manaCosts.getSourcesSorted()) {
            tooltip.add((Component)Component.translatable((String)"label.primalmagick.crafting.mana", (Object[])new Object[]{MANA_FORMATTER.format((double)manaCosts.getAmount(source) / 100.0), source.getNameText()}));
        }
        return tooltip;
    }

    public static List<Component> getRequirementTooltipStrings(RegistryAccess registryAccess, AbstractRequirement<?> requirement) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        tooltip.add((Component)Component.translatable((String)"label.primalmagick.crafting.research_header"));
        requirement.streamKeys().forEach(key -> {
            MutableComponent fallback = Component.literal((String)key.toString());
            if (key instanceof ResearchEntryKey) {
                ResearchEntryKey entryKey = (ResearchEntryKey)key;
                tooltip.add(JeiHelper.getResearchEntryTooltipString(registryAccess, ResearchEntries.getEntry(registryAccess, entryKey), (Component)fallback));
            } else if (key instanceof ResearchStageKey) {
                ResearchStageKey stageKey = (ResearchStageKey)key;
                tooltip.add(JeiHelper.getResearchEntryTooltipString(registryAccess, ResearchEntries.getEntry(registryAccess, stageKey.getRootKey()), (Component)fallback));
            } else {
                tooltip.add((Component)fallback);
            }
        });
        return tooltip;
    }

    private static Component getResearchEntryTooltipString(RegistryAccess registryAccess, @Nullable ResearchEntry entry, Component fallback) {
        if (entry != null) {
            MutableComponent comp = Component.translatable((String)entry.getNameTranslationKey());
            entry.disciplineKeyOpt().ifPresent(discKey -> {
                ResearchDiscipline disc = ResearchDisciplines.getDiscipline(registryAccess, discKey);
                if (disc != null) {
                    comp.append((Component)Component.literal((String)" ("));
                    comp.append((Component)Component.translatable((String)disc.getNameTranslationKey()));
                    comp.append((Component)Component.literal((String)")"));
                }
            });
            return comp;
        }
        return fallback;
    }
}

