/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.compat.jei;

import com.verdantartifice.primalmagick.client.util.RecipeUtils;
import java.util.List;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CategoryRecipeValidatorPM<T extends Recipe<?>> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int INVALID_COUNT = -1;
    private final IRecipeCategory<RecipeHolder<T>> recipeCategory;
    private final int maxInputs;
    private final boolean checkSpecial;

    public CategoryRecipeValidatorPM(IRecipeCategory<RecipeHolder<T>> recipeCategory, int maxInputs) {
        this(recipeCategory, maxInputs, false);
    }

    public CategoryRecipeValidatorPM(IRecipeCategory<RecipeHolder<T>> recipeCategory, int maxInputs, boolean checkSpecial) {
        this.recipeCategory = recipeCategory;
        this.maxInputs = maxInputs;
        this.checkSpecial = checkSpecial;
    }

    public boolean isRecipeValid(RecipeHolder<T> recipe) {
        return this.hasValidInputsAndOutputs(recipe);
    }

    public boolean isRecipeHandled(RecipeHolder<T> recipe) {
        return this.recipeCategory.isHandled(recipe);
    }

    private boolean hasValidInputsAndOutputs(RecipeHolder<T> recipe) {
        if (recipe.value().isSpecial() && !this.checkSpecial) {
            return true;
        }
        ItemStack recipeOutput = RecipeUtils.getResultItem(recipe.value());
        if (recipeOutput == null || recipeOutput.isEmpty()) {
            LOGGER.error("Recipe has no output. {}", (Object)recipe.id().toString());
            return false;
        }
        NonNullList ingredients = recipe.value().getIngredients();
        if (ingredients == null) {
            LOGGER.error("Recipe has no input Ingredients. {}", (Object)recipe.id().toString());
            return false;
        }
        int inputCount = CategoryRecipeValidatorPM.getInputCount((List<Ingredient>)ingredients);
        if (inputCount == -1) {
            return false;
        }
        if (inputCount > this.maxInputs) {
            LOGGER.error("Recipe has too many inputs. {}", (Object)recipe.id().toString());
            return false;
        }
        if (inputCount == 0 && this.maxInputs > 0) {
            LOGGER.error("Recipe has no inputs. {}", (Object)recipe.id().toString());
            return false;
        }
        return true;
    }

    private static int getInputCount(List<Ingredient> ingredientList) {
        int inputCount = 0;
        for (Ingredient ingredient : ingredientList) {
            ItemStack[] input = ingredient.getItems();
            if (input == null) {
                return -1;
            }
            ++inputCount;
        }
        return inputCount;
    }
}

