/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.books;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.verdantartifice.primalmagick.common.books.BookLanguage;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringDecomposer;
import net.minecraft.util.StringUtil;

public class StyleGuide {
    public static final Codec<StyleGuide> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Entry.CODEC.listOf().fieldOf("entries").forGetter(StyleGuide::getEntries)).apply((Applicative)instance, StyleGuide::new));
    private final List<Entry> entries;

    protected StyleGuide(List<Entry> entries) {
        this.entries = ImmutableList.copyOf(entries);
    }

    public static Builder builder(ResourceKey<BookLanguage> language) {
        return new Builder(language.location());
    }

    protected List<Entry> getEntries() {
        return this.entries;
    }

    public int size() {
        return this.getEntries().size();
    }

    public Style getStyle(String word) {
        return this.getStyle(word, Style.EMPTY);
    }

    public Style getStyle(String word, Style encodingStyle) {
        return this.entries.stream().filter(entry -> entry.matches(word)).findFirst().map(entry -> encodingStyle.applyTo(entry.getStyle())).orElse(encodingStyle);
    }

    public Component getStylizedWord(String word) {
        return this.getStylizedWord(word, Style.EMPTY);
    }

    public Component getStylizedWord(String word, Style encodingStyle) {
        return this.entries.stream().filter(entry -> entry.matches(word)).findFirst().map(entry -> entry.getStylizedWord(encodingStyle)).orElse((Component)Component.literal((String)word).withStyle(encodingStyle));
    }

    public static class Builder {
        protected final ResourceLocation langId;
        protected final List<Entry> entries = new ArrayList<Entry>();

        protected Builder(ResourceLocation langId) {
            this.langId = langId;
        }

        protected void addEntry(Entry newEntry) {
            this.entries.add(newEntry);
        }

        public Entry.Builder entry(String translationKey) {
            return new Entry.Builder(translationKey, this);
        }

        public StyleGuide build() {
            return new StyleGuide(this.entries);
        }

        public void save(BiConsumer<ResourceLocation, StyleGuide> consumer) {
            consumer.accept(this.langId, this.build());
        }
    }

    public static class Entry {
        public static final Codec<Entry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("translationKey").forGetter(Entry::getTranslationKey), (App)Style.Serializer.CODEC.optionalFieldOf("style", (Object)Style.EMPTY).forGetter(Entry::getStyle), (App)Codec.STRING.optionalFieldOf("hoverTranslationKey", (Object)"").forGetter(Entry::getHoverTranslationKey)).apply((Applicative)instance, Entry::new));
        private final Supplier<Style> cachedStyle = Suppliers.memoize(this::getStyleInner);
        private final String translationKey;
        private final Style style;
        private final String hoverTranslationKey;

        public Entry(String translationKey, Style style, String hoverTranslationKey) {
            this.translationKey = translationKey;
            this.style = style;
            this.hoverTranslationKey = hoverTranslationKey;
        }

        public String getTranslationKey() {
            return this.translationKey;
        }

        public Style getStyle() {
            return this.cachedStyle.get();
        }

        private Style getStyleInner() {
            return StringUtil.isNullOrEmpty((String)this.hoverTranslationKey) ? this.style : this.style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)this.hoverTranslationKey)));
        }

        protected Style getStyleRaw() {
            return this.style;
        }

        public String getHoverTranslationKey() {
            return this.hoverTranslationKey;
        }

        public boolean matches(String word) {
            return word.equals(StringDecomposer.getPlainText((FormattedText)Component.translatable((String)this.translationKey)));
        }

        public Component getStylizedWord() {
            return Component.translatable((String)this.translationKey).withStyle(this.getStyle());
        }

        public Component getStylizedWord(Style encodingStyle) {
            return Component.translatable((String)this.translationKey).withStyle(encodingStyle.applyTo(this.getStyle()));
        }

        public static class Builder {
            private final com.verdantartifice.primalmagick.client.books.StyleGuide$Builder parent;
            private final String translationKey;
            private Style style = Style.EMPTY;
            private String hoverTranslationKey = "";

            protected Builder(String translationKey, com.verdantartifice.primalmagick.client.books.StyleGuide$Builder parent) {
                this.parent = parent;
                this.translationKey = translationKey;
            }

            public Builder setStyle(Style newStyle) {
                this.style = newStyle;
                return this;
            }

            public Builder mergeStyle(Style newStyle) {
                this.style = newStyle.applyTo(this.style);
                return this;
            }

            public Builder hoverText(String translationKey) {
                this.hoverTranslationKey = translationKey;
                return this;
            }

            public com.verdantartifice.primalmagick.client.books.StyleGuide$Builder end() {
                this.parent.addEntry(new Entry(this.translationKey, this.style, this.hoverTranslationKey));
                return this.parent;
            }
        }
    }
}

