/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.books;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Either;
import com.verdantartifice.primalmagick.client.books.ClientBookHelper;
import com.verdantartifice.primalmagick.common.books.BookDefinition;
import com.verdantartifice.primalmagick.common.books.BookHelper;
import com.verdantartifice.primalmagick.common.books.BookLanguage;
import com.verdantartifice.primalmagick.common.books.BookView;
import com.verdantartifice.primalmagick.common.books.Lexicon;
import com.verdantartifice.primalmagick.common.books.LexiconManager;
import com.verdantartifice.primalmagick.common.registries.RegistryKeysPM;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.enchantment.Enchantment;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LexiconLoader
extends SimpleJsonResourceReloadListener {
    protected static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Logger LOGGER = LogManager.getLogger();
    private static LexiconLoader INSTANCE;

    protected LexiconLoader() {
        super(GSON, "lexicons");
    }

    public static LexiconLoader getInstance() {
        if (INSTANCE == null) {
            throw new IllegalStateException("Cannot retrieve LexiconLoader until resources are loaded at least once");
        }
        return INSTANCE;
    }

    public static LexiconLoader getOrCreateInstance() {
        if (INSTANCE == null) {
            INSTANCE = new LexiconLoader();
        }
        return INSTANCE;
    }

    protected void apply(Map<ResourceLocation, JsonElement> pObject, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        pObject.entrySet().forEach(entry -> {
            ResourceLocation location = (ResourceLocation)entry.getKey();
            if (!location.getPath().startsWith("_")) {
                try {
                    LexiconManager.setLexicon(location, Lexicon.parse(GsonHelper.convertToJsonObject((JsonElement)((JsonElement)entry.getValue()), (String)"top member")));
                }
                catch (Exception e) {
                    LOGGER.error("Parsing error loading lexicon {}", (Object)location, (Object)e);
                }
            }
        });
        BookHelper.invalidate();
        ClientBookHelper.invalidate();
        LOGGER.info("Loaded {} lexicons", (Object)LexiconManager.getAllLexicons().size());
    }

    public void updateWithTagData(RegistryAccess registryAccess) {
        LOGGER.info("Updating lexicons with tagged data");
        registryAccess.registryOrThrow(RegistryKeysPM.BOOK_LANGUAGES).holders().forEach(langHolder -> {
            Lexicon lexicon = new Lexicon();
            registryAccess.registryOrThrow(RegistryKeysPM.BOOKS).holders().map(bookHolder -> new BookView((Either<Holder<BookDefinition>, Holder<Enchantment>>)Either.left((Object)bookHolder), (Holder<BookLanguage>)langHolder, 0)).forEach(view -> lexicon.addWords(ClientBookHelper.getUnencodedWords(view)));
            LexiconManager.setLexicon(langHolder.key().location(), lexicon);
        });
    }
}

