/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.books;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.verdantartifice.primalmagick.client.books.BookSprites;
import com.verdantartifice.primalmagick.client.books.StyleGuide;
import com.verdantartifice.primalmagick.client.books.StyleGuideManager;
import com.verdantartifice.primalmagick.common.books.BookDefinition;
import com.verdantartifice.primalmagick.common.books.BookHelper;
import com.verdantartifice.primalmagick.common.books.BookLanguage;
import com.verdantartifice.primalmagick.common.books.BookType;
import com.verdantartifice.primalmagick.common.books.BookView;
import com.verdantartifice.primalmagick.common.books.Lexicon;
import com.verdantartifice.primalmagick.common.books.LexiconManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Holder;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.util.StringDecomposer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientBookHelper {
    protected static final Logger LOGGER = LogManager.getLogger();
    public static final int TEXT_WIDTH = 114;
    public static final int TEXT_HEIGHT = 128;
    public static final int LINE_HEIGHT = 9;
    public static final int MAX_LINES_PER_PAGE = 14;
    private static final Style FOREWORD_TEXT_STYLE = Style.EMPTY.withItalic(Boolean.valueOf(true));
    private static final Style AFTERWORD_TEXT_STYLE = Style.EMPTY.withItalic(Boolean.valueOf(true));
    private static final Map<BookType, BookSprites> SPRITES = ImmutableMap.builder().put((Object)BookType.BOOK, (Object)BookSprites.VANILLA).put((Object)BookType.TABLET, (Object)BookSprites.TABLET).build();
    private static BiFunction<BookView, Font, List<FormattedCharSequence>> memoizedTextLines = Util.memoize(ClientBookHelper::getTextLinesInner);
    private static Function<BookView, List<String>> memoizedUnencodedWords = Util.memoize(ClientBookHelper::getUnencodedWordsInner);
    private static Function<BookView, Double> memoizedBookComprehension = Util.memoize(ClientBookHelper::getBookComprehensionInner);

    public static void invalidate() {
        memoizedTextLines = Util.memoize(ClientBookHelper::getTextLinesInner);
        memoizedUnencodedWords = Util.memoize(ClientBookHelper::getUnencodedWordsInner);
        memoizedBookComprehension = Util.memoize(ClientBookHelper::getBookComprehensionInner);
    }

    public static BookSprites getSprites(BookType type) {
        return SPRITES.getOrDefault((Object)type, BookSprites.VANILLA);
    }

    private static String getForewordTranslationKey(BookView view) {
        return (String)view.bookDef().map(bookHolder -> {
            ResourceLocation bookLoc = ((BookDefinition)bookHolder.value()).bookId();
            return String.join((CharSequence)".", "written_book", bookLoc.getNamespace(), bookLoc.getPath(), "foreword");
        }, enchHolder -> "tooltip.primalmagick.question_marks");
    }

    private static String getAfterwordTranslationKey(BookView view) {
        return (String)view.bookDef().map(bookHolder -> {
            ResourceLocation bookLoc = ((BookDefinition)bookHolder.value()).bookId();
            return String.join((CharSequence)".", "written_book", bookLoc.getNamespace(), bookLoc.getPath(), "afterword");
        }, enchHolder -> "tooltip.primalmagick.question_marks");
    }

    private static String getAuthorTranslationKey(BookView view) {
        return (String)view.bookDef().map(bookHolder -> {
            ResourceLocation bookLoc = ((BookDefinition)bookHolder.value()).bookId();
            return String.join((CharSequence)".", "written_book", bookLoc.getNamespace(), bookLoc.getPath(), "author");
        }, enchHolder -> "tooltip.primalmagick.question_marks");
    }

    private static String getTextTranslationKey(BookView view) {
        return (String)view.bookDef().map(bookHolder -> {
            ResourceLocation bookLoc = ((BookDefinition)bookHolder.value()).bookId();
            return String.join((CharSequence)".", "written_book", bookLoc.getNamespace(), bookLoc.getPath(), "text");
        }, enchHolder -> {
            ResourceKey enchKey = (ResourceKey)enchHolder.unwrapKey().get();
            String key = String.join((CharSequence)".", "enchantment", enchKey.location().getNamespace(), enchKey.location().getPath(), "desc");
            if (I18n.exists((String)key)) {
                return key;
            }
            key = String.join((CharSequence)".", "enchantment", enchKey.location().getNamespace(), enchKey.location().getPath(), "rune_enchantment", "text");
            if (I18n.exists((String)key)) {
                return key;
            }
            return String.join((CharSequence)".", "enchantment", enchKey.location().getNamespace(), enchKey.location().getPath());
        });
    }

    public static List<FormattedCharSequence> getTextLines(BookView view, Font font) {
        return memoizedTextLines.apply(view, font);
    }

    private static List<FormattedCharSequence> getTextLinesInner(BookView view, Font font) {
        LOGGER.debug("Calculating text lines for book {}, lang {}, comprehension {}", (Object)view.unwrapBookKey().toString(), (Object)((ResourceKey)view.language().unwrapKey().get()).toString(), (Object)view.comprehension());
        ArrayList<FormattedCharSequence> retVal = new ArrayList<FormattedCharSequence>();
        String textTranslationKey = ClientBookHelper.getTextTranslationKey(view);
        Holder<BookLanguage> lang = view.language();
        Lexicon langLex = LexiconManager.getLexicon(((ResourceKey)lang.unwrapKey().get()).location()).orElseThrow();
        Lexicon loremLex = LexiconManager.getLexicon(LexiconManager.LOREM_IPSUM).orElseThrow();
        Optional<StyleGuide> langStyleGuideOpt = StyleGuideManager.getStyleGuide(((ResourceKey)lang.unwrapKey().get()).location());
        view.bookDef().ifLeft(bookHolder -> {
            String key = ClientBookHelper.getForewordTranslationKey(view);
            if (I18n.exists((String)key)) {
                retVal.addAll(font.split((FormattedText)ComponentUtils.wrapInSquareBrackets((Component)Component.translatable((String)key)).withStyle(FOREWORD_TEXT_STYLE), 114));
                retVal.add(FormattedCharSequence.EMPTY);
            }
        });
        ArrayList words = new ArrayList();
        Stream.of(BookHelper.WORD_BOUNDARY.split(StringDecomposer.getPlainText((FormattedText)Component.translatable((String)textTranslationKey)))).forEach(word -> {
            if (BookHelper.SEPARATOR_ONLY.matcher((CharSequence)word).matches()) {
                words.add(Component.literal((String)word).withStyle(BookHelper.BASE_TEXT_STYLE));
            } else if (((BookLanguage)lang.value()).isTranslatable() && langLex.isWordTranslated((String)word, view.comprehension(), ((BookLanguage)lang.value()).complexity())) {
                langStyleGuideOpt.ifPresentOrElse(styleGuide -> words.add(Component.literal((String)word).withStyle(styleGuide.getStyle((String)word, BookHelper.BASE_TEXT_STYLE))), () -> words.add(Component.literal((String)word).withStyle(BookHelper.BASE_TEXT_STYLE)));
            } else {
                langStyleGuideOpt.ifPresentOrElse(styleGuide -> words.add(Component.literal((String)loremLex.getReplacementWord((String)word)).withStyle(styleGuide.getStyle((String)word, ((BookLanguage)lang.value()).style()))), () -> words.add(Component.literal((String)loremLex.getReplacementWord((String)word)).withStyle(((BookLanguage)lang.value()).style())));
            }
        });
        retVal.addAll(Language.getInstance().getVisualOrder(font.getSplitter().splitLines(FormattedText.composite(words), 114, Style.EMPTY)));
        view.bookDef().ifLeft(bookHolder -> {
            String key = ClientBookHelper.getAfterwordTranslationKey(view);
            if (I18n.exists((String)key)) {
                retVal.add(FormattedCharSequence.EMPTY);
                retVal.addAll(font.split((FormattedText)ComponentUtils.wrapInSquareBrackets((Component)Component.translatable((String)key)).withStyle(AFTERWORD_TEXT_STYLE), 114));
            }
        });
        return retVal;
    }

    public static List<FormattedCharSequence> getTextPage(BookView view, int page, Font font) {
        List<FormattedCharSequence> lines = ClientBookHelper.getTextLines(view, font);
        int lowLine = Mth.clamp((int)(page * 14), (int)0, (int)lines.size());
        int highLine = Mth.clamp((int)((page + 1) * 14), (int)0, (int)lines.size());
        return ImmutableList.copyOf(lines.subList(lowLine, highLine));
    }

    public static int getNumPages(BookView view, Font font) {
        return Mth.ceil((float)((float)ClientBookHelper.getTextLines(view, font).size() / 14.0f));
    }

    public static List<String> getUnencodedWords(BookView view) {
        return memoizedUnencodedWords.apply(view);
    }

    private static List<String> getUnencodedWordsInner(BookView view) {
        ArrayList<String> words = new ArrayList<String>();
        ClientBookHelper.gatherUnencodedWords(ClientBookHelper.getTextTranslationKey(view), words::add);
        ClientBookHelper.gatherUnencodedWords(BookHelper.getTitleTranslationKey(view), words::add);
        ClientBookHelper.gatherUnencodedWords(ClientBookHelper.getAuthorTranslationKey(view), words::add);
        return words;
    }

    private static void gatherUnencodedWords(String translationKey, Consumer<String> adder) {
        BookHelper.WORD_BOUNDARY.splitAsStream(StringDecomposer.getPlainText((FormattedText)Component.translatable((String)translationKey))).filter(word -> !BookHelper.SEPARATOR_ONLY.matcher((CharSequence)word).matches()).forEach(adder);
    }

    public static double getBookComprehension(BookView view) {
        return memoizedBookComprehension.apply(view);
    }

    private static double getBookComprehensionInner(BookView view) {
        Holder<BookLanguage> bookLang = view.language();
        if (!((BookLanguage)bookLang.value()).isTranslatable()) {
            return 0.0;
        }
        if (((BookLanguage)bookLang.value()).complexity() == 0) {
            return 1.0;
        }
        List<String> bookWords = ClientBookHelper.getUnencodedWords(view);
        Lexicon langLex = LexiconManager.getLexicon(((ResourceKey)bookLang.unwrapKey().get()).location()).orElseThrow();
        int totalCount = bookWords.size();
        int translatedCount = (int)bookWords.stream().filter(word -> langLex.isWordTranslated((String)word, view.comprehension(), ((BookLanguage)bookLang.value()).complexity())).count();
        return Mth.clamp((double)((double)translatedCount / (double)totalCount), (double)0.0, (double)1.0);
    }
}

