/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.datagen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.crafting.DataComponentIngredient;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import org.jetbrains.annotations.Nullable;

public abstract class LegacyRecipeProvider
extends RecipeProvider {
    private final String modid;
    protected final Set<String> usedPaths = new HashSet<String>();
    @Nullable
    protected RecipeOutput recipeOutput;

    public LegacyRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries, String modid) {
        super(output, registries);
        this.modid = modid;
    }

    protected abstract void genRecipes(RecipeOutput var1, HolderLookup.Provider var2);

    public void addShaped(ResourceLocation key, String group, Object output, int width, int height, Object ... input) {
        if (width * height != input.length) {
            throw new UnsupportedOperationException("Attempted to create invalid shaped recipe. Expected " + width * height + " inputs, but got " + input.length);
        }
        ShapedRecipe recipe = new ShapedRecipe(group, CraftingBookCategory.MISC, LegacyRecipeProvider.toPattern(width, height, LegacyRecipeProvider.createInput(true, input)), LegacyRecipeProvider.makeStack(output));
        this.recipeOutput.accept(key, (Recipe)recipe, null);
    }

    public void addShapeless(ResourceLocation key, String group, Object output, Object ... inputs) {
        ShapelessRecipe recipe = new ShapelessRecipe(group, CraftingBookCategory.MISC, LegacyRecipeProvider.makeStack(output), LegacyRecipeProvider.createInput(false, inputs));
        this.recipeOutput.accept(key, (Recipe)recipe, null);
    }

    public void addShaped(ResourceLocation key, Object output, int width, int height, Object ... input) {
        this.addShaped(key, this.modid, output, width, height, input);
    }

    public void addShapeless(ResourceLocation key, Object output, Object ... inputs) {
        this.addShapeless(key, this.modid, output, inputs);
    }

    public void addShaped(Object output, int width, int height, Object ... input) {
        ItemStack out = LegacyRecipeProvider.makeStack(output);
        String path = this.resolvePath(out);
        this.addShaped(ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)path), this.modid, out, width, height, input);
    }

    public void addShapeless(Object output, Object ... inputs) {
        ItemStack out = LegacyRecipeProvider.makeStack(output);
        String path = this.resolvePath(out);
        this.addShapeless(ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)path), this.modid, (Object)out, inputs);
    }

    public static Ingredient potionIngredient(Holder<Potion> type) {
        HolderSet.Direct items = HolderSet.direct((Holder[])new Holder[]{BuiltInRegistries.ITEM.wrapAsHolder((Object)Items.POTION)});
        DataComponentPredicate predicate = DataComponentPredicate.builder().expect(DataComponents.POTION_CONTENTS, (Object)new PotionContents(type)).build();
        return new Ingredient((ICustomIngredient)new DataComponentIngredient((HolderSet)items, predicate, false));
    }

    protected final void buildRecipes(RecipeOutput recipeOutput, HolderLookup.Provider registries) {
        this.recipeOutput = recipeOutput;
        this.genRecipes(recipeOutput, registries);
        this.recipeOutput = null;
    }

    protected final void buildRecipes(RecipeOutput recipeOutput) {
    }

    private String resolvePath(ItemStack output) {
        Object path = BuiltInRegistries.ITEM.getKey((Object)output.getItem()).getPath();
        while (this.usedPaths.contains(path)) {
            path = (String)path + "_";
        }
        this.usedPaths.add((String)path);
        return path;
    }

    private static ItemStack makeStack(Object thing) {
        if (thing instanceof ItemStack) {
            ItemStack stack = (ItemStack)thing;
            return stack;
        }
        if (thing instanceof ItemLike) {
            ItemLike il = (ItemLike)thing;
            return new ItemStack(il);
        }
        if (thing instanceof Holder) {
            Holder h = (Holder)thing;
            return new ItemStack((ItemLike)h.value());
        }
        throw new IllegalArgumentException("Attempted to create an ItemStack from something that cannot be converted: " + String.valueOf(thing));
    }

    private static NonNullList<Ingredient> createInput(boolean allowEmpty, Object ... inputArr) {
        NonNullList inputL = NonNullList.create();
        for (int i = 0; i < inputArr.length; ++i) {
            Ingredient ing;
            ItemStack stack;
            Object input = inputArr[i];
            if (input instanceof TagKey) {
                TagKey tag = (TagKey)input;
                inputL.add(i, (Object)Ingredient.of((TagKey)tag));
                continue;
            }
            if (input instanceof String) {
                String str = (String)input;
                inputL.add(i, (Object)Ingredient.of((TagKey)ItemTags.create((ResourceLocation)ResourceLocation.parse((String)str))));
                continue;
            }
            if (input instanceof ItemStack && !(stack = (ItemStack)input).isEmpty()) {
                inputL.add(i, (Object)Ingredient.of((ItemStack[])new ItemStack[]{stack}));
                continue;
            }
            if (input instanceof ItemLike || input instanceof Holder) {
                inputL.add(i, (Object)Ingredient.of((ItemStack[])new ItemStack[]{LegacyRecipeProvider.makeStack(input)}));
                continue;
            }
            if (input instanceof Ingredient && !(ing = (Ingredient)input).isEmpty()) {
                inputL.add(i, (Object)ing);
                continue;
            }
            if (allowEmpty && (input == null || input == ItemStack.EMPTY || input == Ingredient.EMPTY)) {
                inputL.add(i, (Object)Ingredient.EMPTY);
                continue;
            }
            throw new UnsupportedOperationException("Attempted to add invalid recipe. Input " + String.valueOf(input) + " not allowed.");
        }
        return inputL;
    }

    private static ShapedRecipePattern toPattern(int width, int height, NonNullList<Ingredient> input) {
        HashMap<Character, Ingredient> key = new HashMap<Character, Ingredient>();
        HashMap<Ingredient, Character> chars = new HashMap<Ingredient, Character>();
        ArrayList<String> rows = new ArrayList<String>(height);
        for (int h = 0; h < height; ++h) {
            Object row = "";
            for (int w = 0; w < width; ++w) {
                Ingredient ing = (Ingredient)input.get(h * width + w);
                if (chars.containsKey(ing)) {
                    row = (String)row + String.valueOf(chars.get(ing));
                    continue;
                }
                Character c = LegacyRecipeProvider.getFirstChar(chars.values(), ing);
                key.put(c, ing);
                chars.put(ing, c);
                row = (String)row + c;
            }
            rows.add((String)row);
        }
        key.remove(Character.valueOf(' '));
        return ShapedRecipePattern.of(key, rows);
    }

    private static Character getFirstChar(Collection<Character> inUse, Ingredient ing) {
        String path;
        if (ing == Ingredient.EMPTY) {
            return Character.valueOf(' ');
        }
        if (ing.isCustom()) {
            ICustomIngredient custom = ing.getCustomIngredient();
            Item item = custom.getItems().findFirst().map(ItemStack::getItem).orElse(Items.AIR);
            path = BuiltInRegistries.ITEM.getKey((Object)item).getPath();
        } else {
            Ingredient.Value v = ing.getValues()[0];
            if (v instanceof Ingredient.TagValue) {
                Ingredient.TagValue t = (Ingredient.TagValue)v;
                path = t.tag().location().getPath();
            } else if (v instanceof Ingredient.ItemValue) {
                Ingredient.ItemValue i = (Ingredient.ItemValue)v;
                path = BuiltInRegistries.ITEM.getKey((Object)i.item().getItem()).getPath();
            } else {
                throw new UnsupportedOperationException("Unknown Ingredient$Value type: " + v.getClass().getCanonicalName());
            }
        }
        path = path.toUpperCase(Locale.ROOT);
        for (char c : path.toCharArray()) {
            if (inUse.contains(Character.valueOf(c))) continue;
            return Character.valueOf(c);
        }
        throw new UnsupportedOperationException("Failed to find any unused characters for ingredient: " + String.valueOf(ing));
    }
}

