/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.mixin;

import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.ai.BeeAggressiveGoal;
import cy.jdkdigital.productivebees.capabilities.attributes.BeeAttributesHandler;
import cy.jdkdigital.productivebees.common.block.entity.FeederBlockEntity;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBee;
import cy.jdkdigital.productivebees.util.GeneAttribute;
import cy.jdkdigital.productivebees.util.GeneValue;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Bee.class})
public abstract class BeeMixin
extends Animal {
    protected BeeMixin(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(at={@At(value="RETURN")}, method={"isFlowerValid"}, cancellable=true)
    public void isFlowerValid(BlockPos pos, CallbackInfoReturnable<Boolean> ci) {
        BlockEntity blockEntity;
        if (!((Boolean)ci.getReturnValue()).booleanValue() && (blockEntity = this.level().getBlockEntity(pos)) instanceof FeederBlockEntity) {
            FeederBlockEntity feederBlockEntity = (FeederBlockEntity)blockEntity;
            Bee bee = (Bee)this;
            ci.setReturnValue((Object)ProductiveBee.isValidFeeder(bee, (BlockEntity)feederBlockEntity, state -> state.is(BlockTags.FLOWERS), stack -> stack.is(ItemTags.FLOWERS)));
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"registerGoals"})
    protected void registerGoals(CallbackInfo ci) {
        this.goalSelector.addGoal(0, (Goal)new BeeAggressiveGoal((Bee)this));
    }

    @Inject(at={@At(value="RETURN")}, method={"wantsToEnterHive"}, cancellable=true)
    public void wantsToEnterHive(CallbackInfoReturnable<Boolean> ci) {
        Bee bee = (Bee)this;
        if (bee.stayOutOfHiveCountdown <= 0 && !bee.beePollinateGoal.isPollinating() && !bee.hasStung() && this.getTarget() == null) {
            boolean shouldReturnToHive;
            BeeAttributesHandler attributes = (BeeAttributesHandler)bee.getData(ProductiveBees.ATTRIBUTE_HANDLER);
            boolean bl = shouldReturnToHive = bee.isTiredOfLookingForNectar() || bee.hasNectar();
            if (!shouldReturnToHive && !this.level().dimensionType().hasFixedTime()) {
                shouldReturnToHive = this.level().isNight() && attributes.getAttributeValue(GeneAttribute.BEHAVIOR).equals((Object)GeneValue.BEHAVIOR_DIURNAL) || this.level().isRaining() && attributes.getAttributeValue(GeneAttribute.WEATHER_TOLERANCE).equals((Object)GeneValue.WEATHER_TOLERANCE_NONE) || this.level().isThundering() && !attributes.getAttributeValue(GeneAttribute.WEATHER_TOLERANCE).equals((Object)GeneValue.WEATHER_TOLERANCE_ANY);
            }
            ci.setReturnValue((Object)(shouldReturnToHive && !bee.isHiveNearFire() ? 1 : 0));
        } else {
            ci.setReturnValue((Object)false);
        }
    }
}

