/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.gen.feature;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.MapCodec;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.common.crafting.ingredient.BeeIngredient;
import cy.jdkdigital.productivebees.common.recipe.BeeSpawningRecipe;
import cy.jdkdigital.productivebees.init.ModBlockEntityTypes;
import cy.jdkdigital.productivebees.init.ModFeatures;
import cy.jdkdigital.productivebees.util.BeeHelper;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class WoodNestDecorator
extends TreeDecorator {
    public static final WoodNestDecorator INSTANCE = new WoodNestDecorator();
    public static final MapCodec<WoodNestDecorator> CODEC = BlockState.CODEC.fieldOf("nest").xmap(WoodNestDecorator::new, p_69971_ -> p_69971_.nest);
    private static final Direction[] SPAWN_DIRECTIONS = (Direction[])Direction.Plane.HORIZONTAL.stream().filter(direction -> direction != Direction.SOUTH.getOpposite()).toArray(Direction[]::new);
    private BlockState nest;
    private List<RecipeHolder<BeeSpawningRecipe>> recipes;

    public WoodNestDecorator() {
    }

    public WoodNestDecorator(BlockState nest) {
        this.setNest(nest);
    }

    protected TreeDecoratorType<?> type() {
        return (TreeDecoratorType)ModFeatures.WOOD_NEST.get();
    }

    public void setNest(BlockState nest) {
        this.nest = nest;
    }

    public BlockState getNest() {
        return this.nest;
    }

    public void setBeeRecipes(List<RecipeHolder<BeeSpawningRecipe>> recipe) {
        this.recipes = recipe;
    }

    public void place(TreeDecorator.Context context) {
        List<Direction> nestDirections;
        BlockPos nestPos;
        LevelSimulatedReader pLevel = context.level();
        RandomSource random = context.random();
        ObjectArrayList pLogPositions = context.logs();
        ObjectArrayList pLeafPositions = context.leaves();
        int i = !pLeafPositions.isEmpty() ? Math.max(((BlockPos)pLeafPositions.get(0)).getY() - 1, ((BlockPos)pLogPositions.get(0)).getY() + 1) : Math.min(((BlockPos)pLogPositions.get(0)).getY() + 1 + random.nextInt(3), ((BlockPos)pLogPositions.get(pLogPositions.size() - 1)).getY());
        List<BlockPos> list = pLogPositions.stream().filter(pos -> pos.getY() == i).flatMap(pos -> Stream.of(SPAWN_DIRECTIONS).map(direction -> context.isAir(pos.relative(direction)) ? pos : null)).filter(Objects::nonNull).toList();
        if (!list.isEmpty() && this.nest != null && (nestPos = list.get(list.size() <= 1 ? 0 : random.nextInt(list.size()))) != null && !(nestDirections = Stream.of(SPAWN_DIRECTIONS).filter(direction -> context.isAir(nestPos.relative(direction))).toList()).isEmpty()) {
            context.setBlock(nestPos, (BlockState)this.nest.getBlock().defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)(nestDirections.size() == 1 ? nestDirections.get(0) : nestDirections.get(random.nextInt(nestDirections.size())))));
            pLevel.getBlockEntity(nestPos, (BlockEntityType)ModBlockEntityTypes.SOLITARY_NEST.get()).ifPresent(nestBlockEntity -> {
                ProductiveBees.LOGGER.debug("Spawned wood nest at " + String.valueOf(nestPos) + " " + String.valueOf(this.nest));
                if (!this.recipes.isEmpty() && !nestBlockEntity.isFull()) {
                    RecipeHolder<BeeSpawningRecipe> spawningRecipe = this.recipes.get(random.nextInt(this.recipes.size()));
                    if (!((BeeSpawningRecipe)spawningRecipe.value()).output.isEmpty()) {
                        BeeIngredient beeIngredient = ((BeeSpawningRecipe)spawningRecipe.value()).output.get(random.nextInt(((BeeSpawningRecipe)spawningRecipe.value()).output.size())).get();
                        try {
                            CompoundTag bee = BeeHelper.getBeeAsCompoundTag(beeIngredient);
                            nestBlockEntity.addOccupantFromTag(bee, random.nextInt(599), 600);
                        }
                        catch (CommandSyntaxException e) {
                            ProductiveBees.LOGGER.warn("Failed to put bees into solitary nest :(" + e.getMessage());
                        }
                    }
                }
            });
        }
    }
}

