/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.compat.geckolib.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.client.render.entity.layers.BeeBodyLayer;
import cy.jdkdigital.productivebees.common.entity.bee.GeckoBee;
import cy.jdkdigital.productivebees.compat.geckolib.client.render.model.GeckoBeeModel;
import java.util.Calendar;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class GeckoBeeRenderer
extends GeoEntityRenderer<GeckoBee> {
    protected boolean isChristmas;
    protected boolean isAprilFool;

    public GeckoBeeRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new GeckoBeeModel());
        Calendar calendar = Calendar.getInstance();
        if (((Boolean)ProductiveBeesConfig.CLIENT.alwaysChristmas.get()).booleanValue() || calendar.get(2) + 1 == 12 && calendar.get(5) >= 21 && calendar.get(5) <= 26) {
            boolean bl = this.isChristmas = (Boolean)ProductiveBeesConfig.CLIENT.neverChristmas.get() == false;
        }
        if (calendar.get(2) + 1 == 4 && calendar.get(5) == 1) {
            this.isAprilFool = (Boolean)ProductiveBeesConfig.GENERAL.enableJokes.get();
        }
        this.addRenderLayer(new JellyLayer((GeoRenderer<GeckoBee>)this));
        this.addRenderLayer(new ColoredLayer((GeoRenderer<GeckoBee>)this));
        this.addRenderLayer(new GlowingLayer((GeoRenderer<GeckoBee>)this));
        if (this.isChristmas) {
            this.addRenderLayer(new ChristmasLayer((GeoRenderer<GeckoBee>)this));
        }
    }

    public void preRender(PoseStack poseStack, GeckoBee animatable, BakedGeoModel model, @Nullable MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        super.preRender(poseStack, (Entity)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
        if (!isReRender && (this.isAprilFool && !animatable.getRenderTransform().equals("flipped") || !this.isAprilFool && animatable.getRenderTransform().equals("flipped"))) {
            poseStack.translate(0.0, (double)(animatable.getBbHeight() + 0.1f), 0.0);
            poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        }
    }

    public void scaleModelForRender(float widthScale, float heightScale, PoseStack poseStack, GeckoBee animatable, BakedGeoModel model, boolean isReRender, float partialTick, int packedLight, int packedOverlay) {
        float beeSize = animatable.getSizeModifier();
        if (animatable.isBaby()) {
            beeSize /= 2.0f;
        }
        super.scaleModelForRender(widthScale * beeSize, heightScale * beeSize, poseStack, (GeoAnimatable)animatable, model, isReRender, partialTick, packedLight, packedOverlay);
    }

    public void postRender(PoseStack poseStack, GeckoBee animatable, BakedGeoModel model, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        this.model.getBone("stinger").ifPresent(geoBone -> geoBone.setHidden(animatable.hasStung() || animatable.isStingless()));
        if (!this.isChristmas) {
            this.model.getBone("santahat").ifPresent(geoBone -> geoBone.setHidden(true));
        }
    }

    static class JellyLayer
    extends GeoRenderLayer<GeckoBee> {
        public JellyLayer(GeoRenderer<GeckoBee> entityRendererIn) {
            super(entityRendererIn);
        }

        public void render(PoseStack poseStack, GeckoBee animatable, BakedGeoModel bakedModel, @Nullable RenderType renderType, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
            if (!animatable.isInvisible() && animatable.isTranslucent()) {
                renderType = RenderType.entityTranslucent((ResourceLocation)this.getTextureResource((GeoAnimatable)animatable));
                this.getRenderer().reRender(bakedModel, poseStack, bufferSource, (GeoAnimatable)animatable, renderType, bufferSource.getBuffer(renderType), partialTick, 0xF00000, packedOverlay, -1);
            }
        }
    }

    static class ColoredLayer
    extends GeoRenderLayer<GeckoBee> {
        public ColoredLayer(GeoRenderer<GeckoBee> entityRendererIn) {
            super(entityRendererIn);
        }

        public void render(PoseStack poseStack, GeckoBee animatable, BakedGeoModel bakedModel, @Nullable RenderType renderType, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
            if (!animatable.isInvisible() && animatable.isColored() && BeeBodyLayer.baseTextures.containsKey(animatable.getRenderer())) {
                renderType = RenderType.entityCutoutNoCull((ResourceLocation)BeeBodyLayer.baseTextures.get(animatable.getRenderer()).get("primary"));
                int primaryColor = animatable.getColor(0, partialTick);
                this.getRenderer().reRender(bakedModel, poseStack, bufferSource, (GeoAnimatable)animatable, renderType, bufferSource.getBuffer(renderType), partialTick, 0xF00000, packedOverlay, primaryColor);
                renderType = RenderType.entityCutoutNoCull((ResourceLocation)BeeBodyLayer.baseTextures.get(animatable.getRenderer()).get("abdomen"));
                int secondaryColor = animatable.getColor(1, partialTick);
                this.getRenderer().reRender(bakedModel, poseStack, bufferSource, (GeoAnimatable)animatable, renderType, bufferSource.getBuffer(renderType), partialTick, 0xF00000, packedOverlay, secondaryColor);
            }
        }
    }

    static class GlowingLayer
    extends GeoRenderLayer<GeckoBee> {
        public GlowingLayer(GeoRenderer<GeckoBee> entityRendererIn) {
            super(entityRendererIn);
        }

        public void render(PoseStack poseStack, GeckoBee animatable, BakedGeoModel bakedModel, @Nullable RenderType renderType, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
            if (!animatable.isInvisible() && !animatable.hasBeeTexture() && animatable.useGlowLayer() && !animatable.getRenderStatic() && BeeBodyLayer.baseTextures.containsKey(animatable.getRenderer()) && BeeBodyLayer.baseTextures.get(animatable.getRenderer()).containsKey("glowlayer")) {
                renderType = RenderType.eyes((ResourceLocation)BeeBodyLayer.baseTextures.get(animatable.getRenderer()).get("glowlayer"));
                int primaryColor = animatable.getTertiaryColor(partialTick);
                this.getRenderer().reRender(bakedModel, poseStack, bufferSource, (GeoAnimatable)animatable, renderType, bufferSource.getBuffer(renderType), partialTick, 0xF00000, packedOverlay, primaryColor);
            }
        }
    }

    static class ChristmasLayer
    extends GeoRenderLayer<GeckoBee> {
        public ChristmasLayer(GeoRenderer<GeckoBee> entityRendererIn) {
            super(entityRendererIn);
        }

        public void render(PoseStack poseStack, GeckoBee animatable, BakedGeoModel bakedModel, @Nullable RenderType renderType, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
            if (!animatable.isInvisible() && BeeBodyLayer.baseTextures.containsKey(animatable.getRenderer()) && BeeBodyLayer.baseTextures.get(animatable.getRenderer()).containsKey("santahat")) {
                renderType = RenderType.entityCutoutNoCull((ResourceLocation)BeeBodyLayer.baseTextures.get(animatable.getRenderer()).get("santahat"));
                this.getRenderer().reRender(bakedModel, poseStack, bufferSource, (GeoAnimatable)animatable, renderType, bufferSource.getBuffer(renderType), partialTick, 0xF00000, packedOverlay, -1);
            }
        }
    }
}

