/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.common.crafting.ingredient.BeeIngredient;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import cy.jdkdigital.productivebees.util.BeeCreator;
import cy.jdkdigital.productivebees.util.BeeHelper;
import cy.jdkdigital.productivelib.common.recipe.TagOutputRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class AdvancedBeehiveRecipe
extends TagOutputRecipe
implements Recipe<RecipeInput> {
    public final Supplier<BeeIngredient> ingredient;

    public AdvancedBeehiveRecipe(Supplier<BeeIngredient> ingredient, List<TagOutputRecipe.ChancedOutput> itemOutput) {
        super(itemOutput);
        this.ingredient = ingredient;
    }

    public boolean matches(RecipeInput inv, Level worldIn) {
        if (inv instanceof BeeHelper.IdentifierInventory && this.ingredient.get() != null) {
            String beeName = ((BeeHelper.IdentifierInventory)inv).getIdentifier();
            return beeName.equals(this.ingredient.get().getBeeType().toString());
        }
        return false;
    }

    public Map<ItemStack, TagOutputRecipe.ChancedOutput> getRecipeOutputs() {
        Map output = super.getRecipeOutputs();
        for (Map.Entry entry : output.entrySet()) {
            if (!this.ingredient.get().isConfigurable() || !((ItemStack)entry.getKey()).getItem().equals(ModItems.CONFIGURABLE_HONEYCOMB.get())) continue;
            BeeCreator.setType(this.ingredient.get().getBeeType(), (ItemStack)entry.getKey());
        }
        return output;
    }

    public boolean isSpecial() {
        return true;
    }

    @Nonnull
    public ItemStack assemble(RecipeInput inv, HolderLookup.Provider pRegistries) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    @Nonnull
    public ItemStack getResultItem(HolderLookup.Provider pRegistries) {
        return ItemStack.EMPTY;
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeTypes.ADVANCED_BEEHIVE.get();
    }

    @Nonnull
    public RecipeType<?> getType() {
        return (RecipeType)ModRecipeTypes.ADVANCED_BEEHIVE_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<AdvancedBeehiveRecipe> {
        public static final MapCodec<AdvancedBeehiveRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)BeeIngredient.CODEC.fieldOf("ingredient").forGetter(recipe -> recipe.ingredient), (App)Codec.list((Codec)TagOutputRecipe.ChancedOutput.CODEC).fieldOf("results").forGetter(recipe -> recipe.itemOutput)).apply((Applicative)builder, AdvancedBeehiveRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, AdvancedBeehiveRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<AdvancedBeehiveRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, AdvancedBeehiveRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static AdvancedBeehiveRecipe fromNetwork(@Nonnull RegistryFriendlyByteBuf buffer) {
            try {
                BeeIngredient ingredient = BeeIngredient.fromNetwork((FriendlyByteBuf)buffer);
                ArrayList<TagOutputRecipe.ChancedOutput> itemOutput = new ArrayList<TagOutputRecipe.ChancedOutput>();
                IntStream.range(0, buffer.readInt()).forEach(i -> itemOutput.add(TagOutputRecipe.ChancedOutput.read((RegistryFriendlyByteBuf)buffer)));
                return new AdvancedBeehiveRecipe(() -> ingredient, itemOutput);
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error reading beehive produce recipe from packet. ", (Throwable)e);
                throw e;
            }
        }

        public static void toNetwork(@Nonnull RegistryFriendlyByteBuf buffer, AdvancedBeehiveRecipe recipe) {
            try {
                if (recipe.ingredient.get() == null) {
                    throw new RuntimeException("Bee produce recipe ingredient missing");
                }
                recipe.ingredient.get().toNetwork((FriendlyByteBuf)buffer);
                buffer.writeInt(recipe.itemOutput.size());
                recipe.itemOutput.forEach(chancedRecipe -> TagOutputRecipe.ChancedOutput.write((RegistryFriendlyByteBuf)buffer, (TagOutputRecipe.ChancedOutput)chancedRecipe));
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error writing beehive produce recipe to packet.", (Throwable)e);
                throw e;
            }
        }
    }
}

