/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.item;

import cy.jdkdigital.productivebees.init.ModEntities;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ItemSteerable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class TreatOnAStick
extends Item {
    private final int consumeItemDamage;

    public TreatOnAStick(Item.Properties properties, int consumeItemDamage) {
        super(properties);
        this.consumeItemDamage = consumeItemDamage;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Entity entity = player.getVehicle();
                if (player.isPassenger() && entity instanceof ItemSteerable) {
                    ItemSteerable itemsteerable = (ItemSteerable)entity;
                    if (entity.getType().equals(ModEntities.BUMBLE.get()) && itemsteerable.boost()) {
                        itemstack.hurtAndBreak(this.consumeItemDamage, (LivingEntity)serverPlayer, LivingEntity.getSlotForHand((InteractionHand)hand));
                        return InteractionResultHolder.success((Object)itemstack);
                    }
                }
                player.awardStat(Stats.ITEM_USED.get((Object)this));
                return InteractionResultHolder.pass((Object)itemstack);
            }
        }
        return InteractionResultHolder.pass((Object)itemstack);
    }
}

