/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.block.entity;

import com.google.common.collect.Lists;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.capabilities.attributes.BeeAttributesHandler;
import cy.jdkdigital.productivebees.common.block.AdvancedBeehive;
import cy.jdkdigital.productivebees.common.block.AdvancedBeehiveAbstract;
import cy.jdkdigital.productivebees.common.block.Feeder;
import cy.jdkdigital.productivebees.common.block.entity.AdvancedBeehiveBlockEntity;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBee;
import cy.jdkdigital.productivebees.common.entity.bee.hive.FarmerBee;
import cy.jdkdigital.productivebees.common.entity.bee.hive.HoarderBee;
import cy.jdkdigital.productivebees.compat.harvest.HarvestCompatHandler;
import cy.jdkdigital.productivebees.init.ModTags;
import cy.jdkdigital.productivebees.state.properties.VerticalHive;
import cy.jdkdigital.productivebees.util.GeneAttribute;
import cy.jdkdigital.productivebees.util.GeneValue;
import cy.jdkdigital.productivelib.common.block.entity.InventoryHandlerHelper;
import cy.jdkdigital.productivelib.event.BeeReleaseEvent;
import cy.jdkdigital.productivelib.registry.LibItems;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public abstract class AdvancedBeehiveBlockEntityAbstract
extends BeehiveBlockEntity {
    private static final List<String> IGNORED_BEE_TAGS = Arrays.asList("AbsorptionAmount", "Attributes", "CitadelData", "KubeJSPersistentData", "Air", "ArmorDropChances", "Brain", "CanPickUpLoot", "DeathTime", "FallDistance", "InLove", "FallFlying", "Fire", "HandDropChances", "HurtByTimestamp", "HurtTime", "LeftHanded", "Motion", "NoGravity", "OnGround", "PortalCooldown", "Pos", "Rotation", "SleepingX", "SleepingY", "SleepingZ", "CannotEnterHiveTicks", "TicksSincePollination", "CropsGrownSincePollination", "hive_pos", "Passengers", "leash", "UUID");
    private static final List<String> OPTIONAL_IGNORED_BEE_TAGS = Arrays.asList("ForgeCaps", "ForgeData");
    public int MAX_BEES = 3;
    protected int tickCounter = 0;

    public AdvancedBeehiveBlockEntityAbstract(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, AdvancedBeehiveBlockEntityAbstract blockEntity) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            AdvancedBeehiveBlockEntityAbstract.tickBees(serverLevel, pos, state, blockEntity);
            blockEntity.tickCounter = 0;
        }
        if (level.getRandom().nextDouble() < 0.005 && !blockEntity.isEmpty()) {
            double x = (double)pos.getX() + 0.5;
            double y = pos.getY();
            double z = (double)pos.getZ() + 0.5;
            level.playSound(null, x, y, z, SoundEvents.BEEHIVE_WORK, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    private static void tickBees(ServerLevel pLevel, BlockPos pPos, BlockState pState, AdvancedBeehiveBlockEntityAbstract blockEntity) {
        ArrayList beesToKeep = new ArrayList();
        List pData = blockEntity.stored;
        boolean hasReleased = false;
        ListIterator<ProductiveBeeData> iterator = pData.listIterator();
        while (iterator.hasNext()) {
            AdvancedBeehiveBlockEntity advancedBeehiveBlockEntity;
            BeehiveBlockEntity.BeeData beedata = (BeehiveBlockEntity.BeeData)iterator.next();
            if (!beedata.tick()) continue;
            BeehiveBlockEntity.BeeReleaseStatus beeReleaseStatus = BeehiveBlockEntity.BeeReleaseStatus.BEE_RELEASED;
            boolean hasConverted = beedata.occupant.entityData().getUnsafe().getBoolean("HasConverted");
            if (!hasConverted && beedata.hasNectar()) {
                beeReleaseStatus = BeehiveBlockEntity.BeeReleaseStatus.HONEY_DELIVERED;
            }
            if (blockEntity instanceof AdvancedBeehiveBlockEntity && (advancedBeehiveBlockEntity = (AdvancedBeehiveBlockEntity)blockEntity).isSim()) {
                int minOccupationTicks;
                BeehiveBlockEntity.Occupant inhabitant = beedata.toOccupant();
                CustomData entityData = inhabitant.entityData();
                int ticksInHive = inhabitant.ticksInHive();
                if (ticksInHive > (minOccupationTicks = inhabitant.minTicksInHive()) + 450) {
                    Entity simulatedBee = AdvancedBeehiveBlockEntityAbstract.simulateBee(pLevel, pPos, pState, blockEntity, inhabitant);
                    if (simulatedBee != null) {
                        hasReleased = true;
                        ticksInHive = 0;
                        minOccupationTicks = blockEntity.getTimeInHive(beeReleaseStatus.equals((Object)BeehiveBlockEntity.BeeReleaseStatus.HONEY_DELIVERED), inhabitant);
                        CompoundTag compoundNBT = new CompoundTag();
                        simulatedBee.save(compoundNBT);
                        entityData = CustomData.of((CompoundTag)compoundNBT);
                    }
                } else if (AdvancedBeehiveBlockEntityAbstract.willLeaveHive((Level)pLevel, inhabitant, beeReleaseStatus)) {
                    ticksInHive += blockEntity.tickCounter;
                }
                BeehiveBlockEntity.Occupant newInhabitant = new BeehiveBlockEntity.Occupant(entityData, ticksInHive, minOccupationTicks);
                iterator.set(new ProductiveBeeData(newInhabitant));
                continue;
            }
            if (!AdvancedBeehiveBlockEntityAbstract.releaseOccupant((Level)pLevel, pPos, pState, beedata.toOccupant(), blockEntity, null, beeReleaseStatus)) continue;
            hasReleased = true;
            iterator.remove();
        }
        if (hasReleased) {
            AdvancedBeehiveBlockEntityAbstract.setChanged((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        }
    }

    protected int getTimeInHive(boolean hasNectar, @Nullable BeehiveBlockEntity.Occupant occupant) {
        CompoundTag data;
        if (occupant != null && ((data = occupant.entityData().getUnsafe()).getString("id").equals("productivebees:hoarder_bee") || data.getString("id").equals("productivebees:collector_bee"))) {
            return 100;
        }
        return hasNectar ? (Integer)ProductiveBeesConfig.GENERAL.timeInHive.get() : (Integer)ProductiveBeesConfig.GENERAL.timeInHive.get() / 2;
    }

    public void emptyAllLivingFromHive(@Nullable Player pPlayer, BlockState pState, BeehiveBlockEntity.BeeReleaseStatus pReleaseStatus) {
        List<Entity> list = this.releaseAllOccupants(pState, pReleaseStatus);
        if (pPlayer != null && this.getLevel() != null) {
            for (Entity entity : list) {
                if (!(entity instanceof Bee)) continue;
                Bee bee = (Bee)entity;
                if (!(pPlayer.position().distanceToSqr(entity.position()) <= 16.0)) continue;
                if (!this.isSedated()) {
                    Bee pBee;
                    GeneValue temper;
                    if (bee instanceof Bee && ((temper = ((BeeAttributesHandler)(pBee = bee).getData(ProductiveBees.ATTRIBUTE_HANDLER)).getAttributeValue(GeneAttribute.TEMPER)).equals((Object)GeneValue.TEMPER_PASSIVE) || temper.equals((Object)GeneValue.TEMPER_NORMAL) && (double)this.getLevel().random.nextFloat() < 0.5)) {
                        bee.setStayOutOfHiveCountdown(400);
                        continue;
                    }
                    bee.setTarget((LivingEntity)pPlayer);
                    continue;
                }
                bee.setStayOutOfHiveCountdown(400);
            }
        }
    }

    public boolean isFull() {
        return this.getOccupantCount() == this.MAX_BEES;
    }

    public boolean acceptsBee(Bee bee) {
        return true;
    }

    public void addOccupantFromTag(CompoundTag compoundtag, int ticksInHive, int timeInHive) {
        BeehiveBlockEntity.IGNORED_BEE_TAGS.forEach(arg_0 -> ((CompoundTag)compoundtag).remove(arg_0));
        this.storeBee(new BeehiveBlockEntity.Occupant(CustomData.of((CompoundTag)compoundtag), ticksInHive, timeInHive));
        this.setNonSuperChanged();
    }

    public void addOccupant(Entity pOccupant) {
        if (!this.isFull()) {
            pOccupant.stopRiding();
            pOccupant.ejectPassengers();
            pOccupant.getData(ProductiveBees.ATTRIBUTE_HANDLER);
            this.storeBee(BeehiveBlockEntity.Occupant.of((Entity)pOccupant));
            if (this.level != null) {
                Bee bee;
                if (pOccupant instanceof Bee && (bee = (Bee)pOccupant).hasSavedFlowerPos() && (!this.hasSavedFlowerPos() || this.level.random.nextBoolean())) {
                    this.savedFlowerPos = bee.getSavedFlowerPos();
                }
                BlockPos blockpos = this.getBlockPos();
                this.level.playSound(null, (double)blockpos.getX(), (double)blockpos.getY(), (double)blockpos.getZ(), SoundEvents.BEEHIVE_ENTER, SoundSource.BLOCKS, 1.0f, 1.0f);
                this.level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, blockpos, GameEvent.Context.of((Entity)pOccupant, (BlockState)this.getBlockState()));
            }
            pOccupant.discard();
            super.setChanged();
        }
    }

    public static Entity simulateBee(ServerLevel pLevel, BlockPos pPos, BlockState state, AdvancedBeehiveBlockEntityAbstract blockEntity, BeehiveBlockEntity.Occupant inhabitant) {
        Entity entity = inhabitant.createEntity((Level)pLevel, pPos);
        if (entity instanceof Bee) {
            Bee beeEntity = (Bee)entity;
            if (blockEntity instanceof AdvancedBeehiveBlockEntity) {
                AdvancedBeehiveBlockEntity advancedBeehiveBlockEntity = (AdvancedBeehiveBlockEntity)blockEntity;
                CompoundTag data = inhabitant.entityData().getUnsafe();
                beeEntity.setHivePos(pPos);
                BeehiveBlockEntity.BeeReleaseStatus beeState = BeehiveBlockEntity.BeeReleaseStatus.BEE_RELEASED;
                if (data.getString("id").equals("productivebees:farmer_bee")) {
                    List<BlockPos> harvestablesNearby = FarmerBee.findHarvestablesNearby((Level)pLevel, pPos, 5 + advancedBeehiveBlockEntity.getUpgradeCount((Item)LibItems.UPGRADE_RANGE.get()));
                    harvestablesNearby.forEach(pos -> {
                        if (pos != null && pLevel.isLoaded(pos) && HarvestCompatHandler.isCropValid((Level)pLevel, pos)) {
                            HarvestCompatHandler.harvestBlock((Level)pLevel, pos);
                        }
                    });
                } else if (data.getString("id").equals("productivebees:hoarder_bee") || data.getString("id").equals("productivebees:collector_bee")) {
                    int distance = 5 + advancedBeehiveBlockEntity.getUpgradeCount((Item)LibItems.UPGRADE_RANGE.get());
                    List items = pLevel.getEntitiesOfClass(ItemEntity.class, new AABB(pPos).inflate((double)distance, (double)distance, (double)distance));
                    for (ItemEntity item : items) {
                        IItemHandlerModifiable iItemHandlerModifiable = advancedBeehiveBlockEntity.inventoryHandler;
                        if (!(iItemHandlerModifiable instanceof InventoryHandlerHelper.BlockEntityItemStackHandler)) continue;
                        InventoryHandlerHelper.BlockEntityItemStackHandler inv = (InventoryHandlerHelper.BlockEntityItemStackHandler)iItemHandlerModifiable;
                        ItemStack leftOver = inv.addOutput(item.getItem().copy());
                        if (leftOver.isEmpty()) {
                            item.kill();
                            continue;
                        }
                        item.setItem(leftOver);
                    }
                } else {
                    Direction direction = state.hasProperty((Property)BlockStateProperties.FACING) ? (Direction)state.getValue((Property)BlockStateProperties.FACING) : (Direction)state.getValue((Property)BeehiveBlock.FACING);
                    BlockPos flowerPos = pPos.below(((VerticalHive)((Object)state.getValue(AdvancedBeehive.EXPANDED))).equals((Object)VerticalHive.DOWN) ? 2 : 1).relative(direction);
                    beeEntity.setSavedFlowerPos(flowerPos);
                    if (pLevel.isLoaded(flowerPos)) {
                        ProductiveBee pBee;
                        if (beeEntity instanceof ProductiveBee && (pBee = (ProductiveBee)beeEntity).isFlowerValid(flowerPos)) {
                            beeState = BeehiveBlockEntity.BeeReleaseStatus.HONEY_DELIVERED;
                            pBee.internalSetHasNectar(true);
                            pBee.postPollinate();
                        } else if (!(beeEntity instanceof ProductiveBee)) {
                            BlockState flowerBlock = pLevel.getBlockState(flowerPos);
                            if (beeEntity.isFlowerValid(flowerPos) || flowerBlock.getBlock() instanceof Feeder && ProductiveBee.isValidFeeder(beeEntity, pLevel.getBlockEntity(flowerPos), blockState -> blockState.is(ModTags.DEFAULT_FLOWERING_BLOCK), null)) {
                                beeState = BeehiveBlockEntity.BeeReleaseStatus.HONEY_DELIVERED;
                            }
                        }
                    }
                }
                blockEntity.beeReleasePostAction((Level)pLevel, beeEntity, state, beeState);
            }
        }
        return entity;
    }

    public List<Entity> releaseAllOccupants(BlockState pState, BeehiveBlockEntity.BeeReleaseStatus pReleaseStatus) {
        ArrayList list = Lists.newArrayList();
        this.stored.removeIf(beeData -> AdvancedBeehiveBlockEntityAbstract.releaseOccupant(this.level, this.worldPosition, pState, beeData.toOccupant(), this, list, pReleaseStatus));
        if (!list.isEmpty()) {
            super.setChanged();
        }
        return list;
    }

    public static boolean releaseOccupant(Level pLevel, BlockPos pPos, BlockState pState, BeehiveBlockEntity.Occupant pOccupant, AdvancedBeehiveBlockEntityAbstract blockEntity, @Nullable List<Entity> pStoredInHives, BeehiveBlockEntity.BeeReleaseStatus pReleaseStatus) {
        if (pState.getBlock().equals(Blocks.AIR) || pLevel == null) {
            return false;
        }
        Direction direction = pState.hasProperty((Property)BlockStateProperties.FACING) ? (Direction)pState.getValue((Property)BlockStateProperties.FACING) : (Direction)pState.getValue((Property)BeehiveBlock.FACING);
        BlockPos frontPos = pPos.relative(direction);
        if (AdvancedBeehiveBlockEntityAbstract.willLeaveHive(pLevel, pOccupant, pReleaseStatus)) {
            Entity entity;
            boolean isPositionBlocked;
            boolean bl = isPositionBlocked = !pLevel.getBlockState(frontPos).getCollisionShape((BlockGetter)pLevel, frontPos).isEmpty();
            if (!(isPositionBlocked && pReleaseStatus != BeehiveBlockEntity.BeeReleaseStatus.EMERGENCY || (entity = pOccupant.createEntity(pLevel, pPos)) == null)) {
                Bee bee;
                if (entity instanceof Bee) {
                    bee = (Bee)entity;
                    if (blockEntity.savedFlowerPos != null && !bee.hasSavedFlowerPos() && (bee.getEncodeId().contains("dye_bee") || pLevel.random.nextFloat() <= 0.9f)) {
                        bee.setSavedFlowerPos(blockEntity.savedFlowerPos);
                    }
                    if (pReleaseStatus == BeehiveBlockEntity.BeeReleaseStatus.HONEY_DELIVERED) {
                        int i;
                        bee.dropOffNectar();
                        if (pState.is(BlockTags.BEEHIVES, p_202037_ -> p_202037_.hasProperty((Property)BeehiveBlock.HONEY_LEVEL)) && (i = AdvancedBeehiveBlockEntityAbstract.getHoneyLevel((BlockState)pState)) < 5) {
                            int j;
                            int n = j = pLevel.random.nextInt(100) == 0 ? 2 : 1;
                            if (i + j > 5) {
                                --j;
                            }
                            pLevel.setBlockAndUpdate(pPos, (BlockState)pState.setValue((Property)BeehiveBlock.HONEY_LEVEL, (Comparable)Integer.valueOf(i + j)));
                        }
                    }
                    float f = entity.getBbWidth();
                    double d3 = isPositionBlocked ? 0.0 : 0.55 + (double)(f / 2.0f);
                    double d0 = (double)pPos.getX() + 0.5 + d3 * (double)direction.getStepX();
                    double d1 = (double)pPos.getY() + 0.5 - (double)(entity.getBbHeight() / 2.0f);
                    double d2 = (double)pPos.getZ() + 0.5 + d3 * (double)direction.getStepZ();
                    entity.moveTo(d0, d1, d2, entity.getYRot(), entity.getXRot());
                }
                pLevel.playSound(null, pPos, SoundEvents.BEEHIVE_EXIT, SoundSource.BLOCKS, 1.0f, 1.0f);
                pLevel.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pPos, GameEvent.Context.of((Entity)entity, (BlockState)pLevel.getBlockState(pPos)));
                boolean spawned = pLevel.addFreshEntity(entity);
                if (spawned && entity instanceof Bee) {
                    bee = (Bee)entity;
                    blockEntity.beeReleasePostAction(pLevel, bee, pState, pReleaseStatus);
                    if (pStoredInHives != null) {
                        pStoredInHives.add((Entity)bee);
                    }
                }
                return spawned;
            }
            return false;
        }
        return false;
    }

    private static boolean willLeaveHive(Level level, BeehiveBlockEntity.Occupant occupant, BeehiveBlockEntity.BeeReleaseStatus beeState) {
        boolean willLeaveHive;
        CompoundTag tag = occupant.entityData().getUnsafe();
        boolean bl = willLeaveHive = beeState == BeehiveBlockEntity.BeeReleaseStatus.EMERGENCY || level.dimensionType().hasFixedTime() || !level.isNight() && !level.isRaining();
        if (!level.dimensionType().hasFixedTime() && tag.contains("neoforge:attachments") && tag.getCompound("neoforge:attachments").contains("productivebees:attributes_handler")) {
            CompoundTag attributes = tag.getCompound("neoforge:attachments").getCompound("productivebees:attributes_handler");
            GeneValue behavior = GeneValue.byName(attributes.getString("bee_behavior"));
            GeneValue tolerance = GeneValue.byName(attributes.getString("bee_weather_tolerance"));
            willLeaveHive = willLeaveHive || (!level.isNight() && behavior != GeneValue.BEHAVIOR_NOCTURNAL || level.isNight() && behavior != GeneValue.BEHAVIOR_DIURNAL) && (!level.isRaining() || tolerance == GeneValue.WEATHER_TOLERANCE_RAIN || tolerance == GeneValue.WEATHER_TOLERANCE_ANY);
        }
        return willLeaveHive;
    }

    protected void beeReleasePostAction(Level level, Bee beeEntity, BlockState state, BeehiveBlockEntity.BeeReleaseStatus beeState) {
        int maxHoneyLevel;
        int honeyLevel;
        IItemHandler handler;
        ProductiveBee pBee;
        beeEntity.setHealth(beeEntity.getMaxHealth());
        if (((BeeReleaseEvent)NeoForge.EVENT_BUS.post((Event)new BeeReleaseEvent(level, beeEntity, (BlockEntity)this, state, beeState))).isCanceled()) {
            return;
        }
        beeEntity.resetTicksWithoutNectarSinceExitingHive();
        beeEntity.dropOffNectar();
        if (beeEntity instanceof ProductiveBee && (pBee = (ProductiveBee)beeEntity).hasConverted()) {
            pBee.setHasConverted(false);
            pBee.setSavedFlowerPos(null);
            return;
        }
        if (beeEntity instanceof HoarderBee && ((HoarderBee)beeEntity).holdsItem() && (handler = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, this.getBlockPos(), null)) instanceof InventoryHandlerHelper.BlockEntityItemStackHandler) {
            InventoryHandlerHelper.BlockEntityItemStackHandler inv = (InventoryHandlerHelper.BlockEntityItemStackHandler)handler;
            ((HoarderBee)beeEntity).emptyIntoInventory(inv);
        }
        if (beeState == BeehiveBlockEntity.BeeReleaseStatus.HONEY_DELIVERED && state.hasProperty((Property)BeehiveBlock.HONEY_LEVEL) && (honeyLevel = AdvancedBeehiveBlockEntityAbstract.getHoneyLevel((BlockState)state)) < (maxHoneyLevel = AdvancedBeehiveBlockEntityAbstract.getMaxHoneyLevel(state))) {
            int levelIncrease;
            int n = levelIncrease = level.random.nextInt(100) == 0 ? 2 : 1;
            if (honeyLevel + levelIncrease > maxHoneyLevel) {
                --levelIncrease;
            }
            level.setBlockAndUpdate(this.worldPosition, (BlockState)state.setValue((Property)BeehiveBlock.HONEY_LEVEL, (Comparable)Integer.valueOf(honeyLevel + levelIncrease)));
        }
    }

    private static void applyHiveTime(int ticksInHive, Bee beeEntity) {
        int i = beeEntity.getAge();
        if (i < 0) {
            beeEntity.setAge(Math.min(0, i + ticksInHive));
        } else if (i > 0) {
            beeEntity.setAge(Math.max(0, i - ticksInHive));
        }
        beeEntity.resetLove();
    }

    public static int getMaxHoneyLevel(BlockState state) {
        Block block = state.getBlock();
        return block instanceof AdvancedBeehiveAbstract ? ((AdvancedBeehiveAbstract)block).getMaxHoneyLevel() : 5;
    }

    public static void removeIgnoredTags(CompoundTag tag) {
        for (String s : IGNORED_BEE_TAGS) {
            if (!tag.contains(s)) continue;
            tag.remove(s);
        }
    }

    public static boolean spawnBeeInWorldAtPosition(ServerLevel world, Entity entity, BlockPos pos, Direction direction, @Nullable Integer age) {
        BlockPos offset = pos.relative(direction);
        boolean isPositionBlocked = !world.getBlockState(offset).getCollisionShape((BlockGetter)world, offset).isEmpty();
        float f = entity.getBbWidth();
        double d3 = isPositionBlocked ? 0.0 : 0.55 + (double)(f / 2.0f);
        double d0 = (double)pos.getX() + 0.5 + d3 * (double)direction.getStepX();
        double d1 = (double)pos.getY() + 0.5 - (double)(entity.getBbHeight() / 2.0f);
        double d2 = (double)pos.getZ() + 0.5 + d3 * (double)direction.getStepZ();
        entity.moveTo(d0, d1, d2, entity.getYRot(), entity.getXRot());
        if (age != null && entity instanceof Bee) {
            ((Bee)entity).setAge(age.intValue());
        }
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.BEEHIVE_EXIT, SoundSource.BLOCKS, 1.0f, 1.0f);
        return world.addFreshEntity(entity);
    }

    public void setNonSuperChanged() {
        if (this.level != null) {
            AdvancedBeehiveBlockEntityAbstract.setChanged((Level)this.level, (BlockPos)this.worldPosition, (BlockState)this.getBlockState());
        }
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        this.loadPacketNBT(tag, provider);
        super.loadAdditional(tag, provider);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        this.savePacketNBT(tag, provider);
    }

    public void savePacketNBT(CompoundTag tag, HolderLookup.Provider provider) {
        tag.putInt("tickCounter", this.tickCounter);
    }

    public void loadPacketNBT(CompoundTag tag, HolderLookup.Provider provider) {
        this.tickCounter = tag.contains("tickCounter") ? tag.getInt("tickCounter") : 0;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithId(provider);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider provider) {
        super.onDataPacket(net, pkt, provider);
        this.loadPacketNBT(pkt.getTag(), provider);
        if (this.level instanceof ClientLevel) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 0);
        }
    }

    public static class ProductiveBeeData
    extends BeehiveBlockEntity.BeeData {
        private BeehiveBlockEntity.BeeData beeData;

        private ProductiveBeeData(BeehiveBlockEntity.Occupant pOccupant) {
            super(pOccupant);
        }

        public static ProductiveBeeData fromBeeData(BeehiveBlockEntity.BeeData beeData) {
            ProductiveBeeData data = new ProductiveBeeData(beeData.toOccupant());
            data.beeData = beeData;
            return data;
        }

        public BeehiveBlockEntity.BeeData getBeeData() {
            return this.beeData;
        }
    }
}

