/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.block;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DragonEggBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class InactiveDragonEgg
extends DragonEggBlock {
    public InactiveDragonEgg(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHitResult) {
        if (!pLevel.isClientSide && pStack.getItem() == Items.DRAGON_BREATH) {
            BlockPos posUp = pPos.above(2);
            for (int i = 0; i < 42; ++i) {
                double rnd = pLevel.random.nextDouble();
                float xSpeed = (pLevel.random.nextFloat() - 0.5f) * 0.2f;
                float ySpeed = (pLevel.random.nextFloat() - 0.5f) * 0.2f;
                float zSpeed = (pLevel.random.nextFloat() - 0.5f) * 0.2f;
                double x = Mth.lerp((double)rnd, (double)posUp.getX(), (double)pPos.getX()) + (pLevel.random.nextDouble() - 0.5) + 0.5;
                double y = Mth.lerp((double)rnd, (double)posUp.getY(), (double)pPos.getY()) + pLevel.random.nextDouble() - 0.5;
                double z = Mth.lerp((double)rnd, (double)posUp.getZ(), (double)pPos.getZ()) + (pLevel.random.nextDouble() - 0.5) + 0.5;
                pLevel.addParticle((ParticleOptions)ParticleTypes.PORTAL, x, y, z, (double)xSpeed, (double)ySpeed, (double)zSpeed);
            }
            CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger((ServerPlayer)pPlayer, pPos, pStack);
            pLevel.setBlockAndUpdate(pPos, Blocks.DRAGON_EGG.defaultBlockState());
            if (!pPlayer.isCreative()) {
                pStack.shrink(1);
            }
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(pStack, pState, pLevel, pPos, pPlayer, pHand, pHitResult);
    }
}

