/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.block;

import com.mojang.serialization.MapCodec;
import cy.jdkdigital.productivebees.common.block.AdvancedBeehiveAbstract;
import cy.jdkdigital.productivebees.common.block.DragonEggHive;
import cy.jdkdigital.productivebees.common.block.ExpansionBox;
import cy.jdkdigital.productivebees.common.block.entity.AdvancedBeehiveBlockEntity;
import cy.jdkdigital.productivebees.init.ModBlockEntityTypes;
import cy.jdkdigital.productivebees.state.properties.VerticalHive;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.apache.commons.lang3.tuple.Pair;

public class AdvancedBeehive
extends AdvancedBeehiveAbstract {
    public static final MapCodec<AdvancedBeehive> CODEC = AdvancedBeehive.simpleCodec(AdvancedBeehive::new);
    public static final EnumProperty<VerticalHive> EXPANDED = EnumProperty.create((String)"expanded", VerticalHive.class);

    public AdvancedBeehive(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BeehiveBlock.FACING, (Comparable)Direction.NORTH)).setValue(EXPANDED, (Comparable)((Object)VerticalHive.NONE))).setValue((Property)BeehiveBlock.HONEY_LEVEL, (Comparable)Integer.valueOf(0)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new AdvancedBeehiveBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.isClientSide ? null : AdvancedBeehive.createTickerHelper(blockEntityType, ModBlockEntityTypes.ADVANCED_HIVE.get(), AdvancedBeehiveBlockEntity::tick);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)BeehiveBlock.FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{EXPANDED, BeehiveBlock.HONEY_LEVEL, BeehiveBlock.FACING});
    }

    public void updateState(Level level, BlockPos pos, BlockState state, boolean isRemoved) {
        if (this instanceof DragonEggHive) {
            return;
        }
        Pair<Pair<BlockPos, Direction>, BlockState> pair = AdvancedBeehive.getAdjacentBox(level, pos, false);
        if (pair != null) {
            Pair posAndDirection = (Pair)pair.getLeft();
            BlockPos boxPos = (BlockPos)posAndDirection.getLeft();
            VerticalHive directionProperty = AdvancedBeehive.calculateExpandedDirection(level, pos, isRemoved);
            if (!isRemoved) {
                this.updateStateWithDirection(level, pos, state, directionProperty);
            }
            ((ExpansionBox)((BlockState)pair.getRight()).getBlock()).updateStateWithDirection(level, boxPos, (BlockState)pair.getRight(), directionProperty, (Direction)state.getValue((Property)BeehiveBlock.FACING));
        } else if (!isRemoved) {
            this.updateStateWithDirection(level, pos, state, VerticalHive.NONE);
        }
    }

    public void updateStateWithDirection(Level level, BlockPos pos, BlockState state, VerticalHive directionProperty) {
        level.setBlockAndUpdate(pos, (BlockState)state.setValue(EXPANDED, (Comparable)((Object)directionProperty)));
        BlockEntity te = level.getBlockEntity(pos);
        if (te instanceof AdvancedBeehiveBlockEntity) {
            AdvancedBeehiveBlockEntity advancedBeehiveBlockEntity = (AdvancedBeehiveBlockEntity)te;
            int n = advancedBeehiveBlockEntity.MAX_BEES = level.getBlockState(pos).getValue(EXPANDED) != VerticalHive.NONE ? 5 : 3;
            if (directionProperty.equals((Object)VerticalHive.NONE)) {
                IItemHandlerModifiable handler = advancedBeehiveBlockEntity.getUpgradeHandler();
                for (int slot = 0; slot < handler.getSlots(); ++slot) {
                    Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)handler.getStackInSlot(slot));
                }
            }
        }
    }

    public static Pair<Pair<BlockPos, Direction>, BlockState> getAdjacentBox(Level level, BlockPos pos, boolean onlyFreeBoxes) {
        for (Direction direction : BlockStateProperties.FACING.getPossibleValues()) {
            BlockPos newPos = pos.relative(direction);
            BlockState blockStateAtPos = level.getBlockState(newPos);
            if (!(blockStateAtPos.getBlock() instanceof ExpansionBox)) continue;
            return Pair.of((Object)Pair.of((Object)newPos, (Object)direction), (Object)blockStateAtPos);
        }
        return null;
    }

    public static VerticalHive calculateExpandedDirection(Level level, BlockPos hivePos, boolean isRemoved) {
        Pair<Pair<BlockPos, Direction>, BlockState> pair = AdvancedBeehive.getAdjacentBox(level, hivePos, true);
        VerticalHive directionProperty = VerticalHive.NONE;
        if (!isRemoved && pair != null) {
            boolean isValidExpandedPos;
            BlockState hiveBlockState = level.getBlockState(hivePos);
            Direction hiveDirection = (Direction)hiveBlockState.getValue((Property)BeehiveBlock.FACING);
            Direction boxDirection = (Direction)((Pair)pair.getLeft()).getRight();
            Pair posAndDirection = (Pair)pair.getLeft();
            BlockPos boxPos = (BlockPos)posAndDirection.getLeft();
            boolean bl = isValidExpandedPos = !boxPos.equals((Object)hivePos.relative(hiveDirection));
            if (!isValidExpandedPos && hiveDirection == Direction.NORTH) {
                isValidExpandedPos = boxDirection == Direction.WEST || boxDirection == Direction.EAST || boxDirection == Direction.SOUTH;
            } else if (!isValidExpandedPos && hiveDirection == Direction.SOUTH) {
                isValidExpandedPos = boxDirection == Direction.WEST || boxDirection == Direction.EAST || boxDirection == Direction.NORTH;
            } else if (!isValidExpandedPos && hiveDirection == Direction.WEST) {
                isValidExpandedPos = boxDirection == Direction.SOUTH || boxDirection == Direction.NORTH || boxDirection == Direction.EAST;
            } else if (!isValidExpandedPos && hiveDirection == Direction.EAST) {
                boolean bl2 = isValidExpandedPos = boxDirection == Direction.SOUTH || boxDirection == Direction.NORTH || boxDirection == Direction.WEST;
            }
            if (isValidExpandedPos) {
                if (hivePos.getY() - boxPos.getY() > 0) {
                    directionProperty = VerticalHive.DOWN;
                } else if (hivePos.getY() - boxPos.getY() < 0) {
                    directionProperty = VerticalHive.UP;
                } else if (hivePos.getX() < boxPos.getX()) {
                    directionProperty = hiveDirection == Direction.WEST ? VerticalHive.BACK : (hiveDirection == Direction.NORTH ? VerticalHive.LEFT : VerticalHive.RIGHT);
                } else if (hivePos.getX() > boxPos.getX()) {
                    directionProperty = hiveDirection == Direction.EAST ? VerticalHive.BACK : (hiveDirection == Direction.SOUTH ? VerticalHive.LEFT : VerticalHive.RIGHT);
                } else if (hivePos.getZ() < boxPos.getZ()) {
                    directionProperty = hiveDirection == Direction.NORTH ? VerticalHive.BACK : (hiveDirection == Direction.EAST ? VerticalHive.LEFT : VerticalHive.RIGHT);
                } else if (hivePos.getZ() > boxPos.getZ()) {
                    directionProperty = hiveDirection == Direction.SOUTH ? VerticalHive.BACK : (hiveDirection == Direction.WEST ? VerticalHive.LEFT : VerticalHive.RIGHT);
                }
            }
        }
        return directionProperty;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        if (!level.isClientSide()) {
            this.updateState(level, pos, state, false);
        }
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        boolean removed = super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
        if (!level.isClientSide()) {
            this.updateState(level, pos, state, true);
        }
        return removed;
    }

    public void onRemove(BlockState oldState, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tileEntity;
        if (oldState.getBlock() != newState.getBlock() && (tileEntity = worldIn.getBlockEntity(pos)) instanceof AdvancedBeehiveBlockEntity) {
            AdvancedBeehiveBlockEntity advancedBeehiveBlockEntity = (AdvancedBeehiveBlockEntity)tileEntity;
            for (int slot = 0; slot < advancedBeehiveBlockEntity.inventoryHandler.getSlots(); ++slot) {
                Containers.dropItemStack((Level)worldIn, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)advancedBeehiveBlockEntity.inventoryHandler.getStackInSlot(slot));
            }
            IItemHandlerModifiable upgradeHandler = advancedBeehiveBlockEntity.getUpgradeHandler();
            for (int slot = 0; slot < upgradeHandler.getSlots(); ++slot) {
                Containers.dropItemStack((Level)worldIn, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)upgradeHandler.getStackInSlot(slot));
            }
        }
        super.onRemove(oldState, worldIn, pos, newState, isMoving);
    }

    protected InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHitResult) {
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (blockEntity instanceof AdvancedBeehiveBlockEntity) {
            AdvancedBeehiveBlockEntity advancedBeehiveBlockEntity = (AdvancedBeehiveBlockEntity)blockEntity;
            if (!pLevel.isClientSide()) {
                pLevel.sendBlockUpdated(pPos, pState, pState, 3);
                this.openGui((ServerPlayer)pPlayer, advancedBeehiveBlockEntity);
            }
            return InteractionResult.SUCCESS_NO_ITEM_USED;
        }
        return super.useWithoutItem(pState, pLevel, pPos, pPlayer, pHitResult);
    }

    public ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHitResult) {
        ItemStack heldItem = pPlayer.getItemInHand(pHand);
        int honeyLevel = (Integer)pState.getValue((Property)BeehiveBlock.HONEY_LEVEL);
        boolean itemUsed = false;
        if (honeyLevel >= this.getMaxHoneyLevel()) {
            if (heldItem.getItem() == Items.SHEARS) {
                pLevel.playSound(pPlayer, pPlayer.getX(), pPlayer.getY(), pPlayer.getZ(), SoundEvents.BEEHIVE_SHEAR, SoundSource.NEUTRAL, 1.0f, 1.0f);
                BeehiveBlock.dropHoneycomb((Level)pLevel, (BlockPos)pPos);
                EquipmentSlot equipmentslot = pHand.equals((Object)InteractionHand.OFF_HAND) ? EquipmentSlot.OFFHAND : EquipmentSlot.MAINHAND;
                heldItem.hurtAndBreak(1, (LivingEntity)pPlayer, equipmentslot);
                itemUsed = true;
            } else if (heldItem.getItem() == Items.GLASS_BOTTLE) {
                heldItem.shrink(1);
                pLevel.playSound(pPlayer, pPlayer.getX(), pPlayer.getY(), pPlayer.getZ(), SoundEvents.BOTTLE_FILL, SoundSource.NEUTRAL, 1.0f, 1.0f);
                if (heldItem.isEmpty()) {
                    pPlayer.setItemInHand(pHand, new ItemStack((ItemLike)Items.HONEY_BOTTLE));
                } else if (!pPlayer.getInventory().add(new ItemStack((ItemLike)Items.HONEY_BOTTLE))) {
                    pPlayer.drop(new ItemStack((ItemLike)Items.HONEY_BOTTLE), false);
                }
                itemUsed = true;
            }
        }
        if (itemUsed) {
            pLevel.setBlockAndUpdate(pPos, (BlockState)pState.setValue((Property)BeehiveBlock.HONEY_LEVEL, (Comparable)Integer.valueOf(this.getMaxHoneyLevel() - 5)));
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void openGui(ServerPlayer player, AdvancedBeehiveBlockEntity tileEntity) {
        this.updateState(tileEntity.getLevel(), tileEntity.getBlockPos(), tileEntity.getBlockState(), false);
        player.openMenu((MenuProvider)tileEntity, tileEntity.getBlockPos());
    }
}

