/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.client.particle;

import cy.jdkdigital.productivebees.client.particle.FallingNectarParticle;
import cy.jdkdigital.productivebees.client.particle.NectarParticleType;
import javax.annotation.Nonnull;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class RisingNectarParticle
extends FallingNectarParticle {
    private final Fluid type;

    public RisingNectarParticle(ClientLevel world, double x, double y, double z, Fluid fluid) {
        super(world, x, y, z, fluid);
        this.lifetime = (int)(16.0 / (world.random.nextDouble() * 0.8 + 0.2));
        this.gravity = -0.007f;
        this.type = fluid;
    }

    public static class RisingNectarFactory
    implements ParticleProvider<NectarParticleType> {
        protected final SpriteSet sprite;

        public RisingNectarFactory(SpriteSet sprite) {
            this.sprite = sprite;
        }

        public Particle createParticle(@Nonnull NectarParticleType typeIn, @Nonnull ClientLevel world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            RisingNectarParticle dripparticle = new RisingNectarParticle(world, x, y, z, Fluids.EMPTY);
            float[] colors = typeIn.getColor();
            if (colors != null) {
                dripparticle.setColor(colors[0], colors[1], colors[2]);
            } else {
                dripparticle.setColor(0.92f, 0.782f, 0.72f);
            }
            dripparticle.pickSprite(this.sprite);
            return dripparticle;
        }
    }
}

