/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.capability.TBPlayerCapabilityHandler;
import ovh.corail.tombstone.network.CMessagePlayerCapRemovePerk;
import ovh.corail.tombstone.network.CMessagePlayerCapSetPerk;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.perk.Perk;
import ovh.corail.tombstone.perk.PerkRegistry;
import ovh.corail.tombstone.registry.ModPerks;
import ovh.corail.tombstone.registry.ModTriggers;

public record SMessageUpgradePerk(SyncType syncType, @Nullable Perk perk) implements CustomPacketPayload
{
    static final StreamCodec<RegistryFriendlyByteBuf, SMessageUpgradePerk> STREAM_CODEC = StreamCodec.ofMember(SMessageUpgradePerk::encode, SMessageUpgradePerk::decode);
    static final CustomPacketPayload.Type<SMessageUpgradePerk> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"upgrade_perk"));

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    static SMessageUpgradePerk decode(RegistryFriendlyByteBuf buf) {
        return new SMessageUpgradePerk(buf.readBoolean() ? SyncType.DOWNGRADE_PERK : SyncType.UPGRADE_PERK, Optional.ofNullable(PerkRegistry.getValue(buf.readUtf())).orElse(ModPerks.jailer));
    }

    static void encode(SMessageUpgradePerk msg, RegistryFriendlyByteBuf buf) {
        buf.writeBoolean(msg.syncType == SyncType.DOWNGRADE_PERK);
        buf.writeUtf(PerkRegistry.getStringKey(msg.perk));
    }

    static void handle(SMessageUpgradePerk msg, IPayloadContext ctx) {
        ServerPlayer player = (ServerPlayer)ctx.player();
        if (msg.perk != null && !msg.perk.isDisabled((Player)player)) {
            if (msg.syncType == SyncType.UPGRADE_PERK) {
                if (TBPlayerCapabilityHandler.canUpgradePerk((Player)player, msg.perk)) {
                    int newPerklevel = TBPlayerCapabilityHandler.getPerkLevel((Player)player, msg.perk) + 1;
                    TBPlayerCapabilityHandler.setPerk((Player)player, msg.perk, newPerklevel);
                    ModTriggers.selected_perks.trigger(player);
                    PacketHandler.sendToPlayer(new CMessagePlayerCapSetPerk(msg.perk, newPerklevel), player);
                }
            } else if (msg.syncType == SyncType.DOWNGRADE_PERK && TBPlayerCapabilityHandler.canDowngradePerk((Player)player, msg.perk)) {
                int newPerklevel = TBPlayerCapabilityHandler.getPerkLevel((Player)player, msg.perk) - 1;
                if (newPerklevel == 0) {
                    TBPlayerCapabilityHandler.removePerk((Player)player, msg.perk);
                    PacketHandler.sendToPlayer(new CMessagePlayerCapRemovePerk(msg.perk), player);
                } else {
                    TBPlayerCapabilityHandler.setPerk((Player)player, msg.perk, newPerklevel);
                    PacketHandler.sendToPlayer(new CMessagePlayerCapSetPerk(msg.perk, newPerklevel), player);
                }
            }
        }
    }

    public static enum SyncType {
        UPGRADE_PERK,
        DOWNGRADE_PERK;

    }
}

