/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.handling.MainThreadPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import ovh.corail.tombstone.network.CMessageConfig;
import ovh.corail.tombstone.network.CMessageCooldown;
import ovh.corail.tombstone.network.CMessageEffectFinished;
import ovh.corail.tombstone.network.CMessageEffectStarted;
import ovh.corail.tombstone.network.CMessageEnhancedFamiliar;
import ovh.corail.tombstone.network.CMessageGlobalTime;
import ovh.corail.tombstone.network.CMessageKnowledgeScreen;
import ovh.corail.tombstone.network.CMessageLevelUp;
import ovh.corail.tombstone.network.CMessageLogin;
import ovh.corail.tombstone.network.CMessagePlayerCapRemovePerk;
import ovh.corail.tombstone.network.CMessagePlayerCapSetPerk;
import ovh.corail.tombstone.network.CMessagePlayerCapSetWatcherKnowledge;
import ovh.corail.tombstone.network.CMessagePlayerCapSyncAlignment;
import ovh.corail.tombstone.network.CMessagePlayerCapSyncKnowledge;
import ovh.corail.tombstone.network.CMessagePlayerCapSyncPerks;
import ovh.corail.tombstone.network.CMessagePlayerProtection;
import ovh.corail.tombstone.network.CMessagePrayer;
import ovh.corail.tombstone.network.CMessageProtection;
import ovh.corail.tombstone.network.CMessageRitualFluteValidationResult;
import ovh.corail.tombstone.network.CMessageServant;
import ovh.corail.tombstone.network.CMessageSmokeColumn;
import ovh.corail.tombstone.network.CMessageSpellCasting;
import ovh.corail.tombstone.network.SMessageCombination;
import ovh.corail.tombstone.network.SMessagePlayerPreference;
import ovh.corail.tombstone.network.SMessageResetPerk;
import ovh.corail.tombstone.network.SMessageRitualFlutePlayedNote;
import ovh.corail.tombstone.network.SMessageRitualFluteValidation;
import ovh.corail.tombstone.network.SMessageUpgradePerk;

@EventBusSubscriber(modid="tombstone", bus=EventBusSubscriber.Bus.MOD)
public class PacketHandler {
    private static final String PROTOCOL_ID = "tombstone-9.4.7";

    @SubscribeEvent
    public static void onRegisterPayloadHandler(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar(PROTOCOL_ID);
        registrar.playToClient(CMessageSmokeColumn.TYPE, CMessageSmokeColumn.STREAM_CODEC, (IPayloadHandler)new MainThreadPayloadHandler(CMessageSmokeColumn::handle));
        registrar.playToClient(CMessageCooldown.TYPE, CMessageCooldown.STREAM_CODEC, (IPayloadHandler)new MainThreadPayloadHandler(CMessageCooldown::handle));
        registrar.playToClient(CMessageConfig.TYPE, CMessageConfig.STREAM_CODEC, (IPayloadHandler)new MainThreadPayloadHandler(CMessageConfig::handle));
        registrar.playToClient(CMessageLevelUp.TYPE, CMessageLevelUp.STREAM_CODEC, (IPayloadHandler)new MainThreadPayloadHandler(CMessageLevelUp::handle));
        registrar.playToClient(CMessageProtection.TYPE, CMessageProtection.STREAM_CODEC, (IPayloadHandler)new MainThreadPayloadHandler(CMessageProtection::handle));
        registrar.playToClient(CMessagePlayerProtection.TYPE, CMessagePlayerProtection.STREAM_CODEC, (IPayloadHandler)new MainThreadPayloadHandler(CMessagePlayerProtection::handle));
        registrar.playToClient(CMessageSpellCasting.TYPE, CMessageSpellCasting.STREAM_CODEC, (IPayloadHandler)new MainThreadPayloadHandler(CMessageSpellCasting::handle));
        registrar.playToClient(CMessageServant.TYPE, CMessageServant.STREAM_CODEC, (IPayloadHandler)new MainThreadPayloadHandler(CMessageServant::handle));
        registrar.playToClient(CMessagePrayer.TYPE, CMessagePrayer.STREAM_CODEC, (IPayloadHandler)new MainThreadPayloadHandler(CMessagePrayer::handle));
        registrar.playToClient(CMessageKnowledgeScreen.TYPE, CMessageKnowledgeScreen.STREAM_CODEC, (IPayloadHandler)new MainThreadPayloadHandler(CMessageKnowledgeScreen::handle));
        registrar.playToClient(CMessageEnhancedFamiliar.TYPE, CMessageEnhancedFamiliar.STREAM_CODEC, (IPayloadHandler)new MainThreadPayloadHandler(CMessageEnhancedFamiliar::handle));
        registrar.playToClient(CMessageLogin.TYPE, CMessageLogin.STREAM_CODEC, (IPayloadHandler)new MainThreadPayloadHandler(CMessageLogin::handle));
        registrar.playToClient(CMessageGlobalTime.TYPE, CMessageGlobalTime.STREAM_CODEC, (IPayloadHandler)new MainThreadPayloadHandler(CMessageGlobalTime::handle));
        registrar.playToClient(CMessagePlayerCapSyncKnowledge.TYPE, CMessagePlayerCapSyncKnowledge.STREAM_CODEC, (IPayloadHandler)new MainThreadPayloadHandler(CMessagePlayerCapSyncKnowledge::handle));
        registrar.playToClient(CMessagePlayerCapSyncAlignment.TYPE, CMessagePlayerCapSyncAlignment.STREAM_CODEC, (IPayloadHandler)new MainThreadPayloadHandler(CMessagePlayerCapSyncAlignment::handle));
        registrar.playToClient(CMessagePlayerCapSyncPerks.TYPE, CMessagePlayerCapSyncPerks.STREAM_CODEC, (IPayloadHandler)new MainThreadPayloadHandler(CMessagePlayerCapSyncPerks::handle));
        registrar.playToClient(CMessagePlayerCapSetPerk.TYPE, CMessagePlayerCapSetPerk.STREAM_CODEC, (IPayloadHandler)new MainThreadPayloadHandler(CMessagePlayerCapSetPerk::handle));
        registrar.playToClient(CMessagePlayerCapRemovePerk.TYPE, CMessagePlayerCapRemovePerk.STREAM_CODEC, (IPayloadHandler)new MainThreadPayloadHandler(CMessagePlayerCapRemovePerk::handle));
        registrar.playToClient(CMessagePlayerCapSetWatcherKnowledge.TYPE, CMessagePlayerCapSetWatcherKnowledge.STREAM_CODEC, (IPayloadHandler)new MainThreadPayloadHandler(CMessagePlayerCapSetWatcherKnowledge::handle));
        registrar.playToClient(CMessageEffectStarted.TYPE, CMessageEffectStarted.STREAM_CODEC, (IPayloadHandler)new MainThreadPayloadHandler(CMessageEffectStarted::handle));
        registrar.playToClient(CMessageEffectFinished.TYPE, CMessageEffectFinished.STREAM_CODEC, (IPayloadHandler)new MainThreadPayloadHandler(CMessageEffectFinished::handle));
        registrar.playToClient(CMessageRitualFluteValidationResult.TYPE, CMessageRitualFluteValidationResult.STREAM_CODEC, (IPayloadHandler)new MainThreadPayloadHandler(CMessageRitualFluteValidationResult::handle));
        registrar.playToServer(SMessagePlayerPreference.TYPE, SMessagePlayerPreference.STREAM_CODEC, (IPayloadHandler)new MainThreadPayloadHandler(SMessagePlayerPreference::handle));
        registrar.playToServer(SMessageUpgradePerk.TYPE, SMessageUpgradePerk.STREAM_CODEC, (IPayloadHandler)new MainThreadPayloadHandler(SMessageUpgradePerk::handle));
        registrar.playToServer(SMessageResetPerk.TYPE, SMessageResetPerk.STREAM_CODEC, (IPayloadHandler)new MainThreadPayloadHandler(SMessageResetPerk::handle));
        registrar.playToServer(SMessageCombination.TYPE, SMessageCombination.STREAM_CODEC, (IPayloadHandler)new MainThreadPayloadHandler(SMessageCombination::handle));
        registrar.playToServer(SMessageRitualFlutePlayedNote.TYPE, SMessageRitualFlutePlayedNote.STREAM_CODEC, (IPayloadHandler)new MainThreadPayloadHandler(SMessageRitualFlutePlayedNote::handle));
        registrar.playToServer(SMessageRitualFluteValidation.TYPE, SMessageRitualFluteValidation.STREAM_CODEC, (IPayloadHandler)new MainThreadPayloadHandler(SMessageRitualFluteValidation::handle));
    }

    public static <T extends CustomPacketPayload> void sendToServer(T message) {
        PacketDistributor.sendToServer(message, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static <T extends CustomPacketPayload> void sendToPlayer(T message, ServerPlayer player) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, message, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static <T extends CustomPacketPayload> void sendToAllTrackingPlayers(T message, LivingEntity entity) {
        PacketDistributor.sendToPlayersTrackingEntity((Entity)entity, message, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static <T extends CustomPacketPayload> void sendToAllTrackingPlayersAndSelf(T message, LivingEntity entity) {
        PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)entity, message, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static <T extends CustomPacketPayload> void sendToAllAround(T message, ServerLevel level, ServerPlayer excluded, BlockPos pos, double radius) {
        PacketDistributor.sendToPlayersNear((ServerLevel)level, (ServerPlayer)excluded, (double)((double)pos.getX() + 0.5), (double)((double)pos.getY() + 0.5), (double)((double)pos.getZ() + 0.5), (double)radius, message, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static <T extends CustomPacketPayload> void sendToAllPlayers(T message) {
        PacketDistributor.sendToAllPlayers(message, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

