/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import ovh.corail.tombstone.combine.CombineCraft;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.ProxyHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.item.ICombineCraft;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.item.ItemScrollBuff;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.SMessageCombination;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModTriggers;

public final class ItemStrangeScroll
extends ItemGeneric
implements ICombineCraft {
    private TooltipComponent tooltip;

    public ItemStrangeScroll() {
        super("strange_scroll");
        this.withCombineInfo();
    }

    public boolean overrideOtherStackedOnMe(ItemStack strangeScroll, ItemStack added, Slot slot, ClickAction action, Player player, SlotAccess slotAccess) {
        CombineCraft combine;
        if (action == ClickAction.SECONDARY && EntityHelper.isValidPlayer(player) && slot.allowModification(player) && strangeScroll.is((Item)this) && (combine = this.getCombination(added)) != null) {
            if (combine.isEnabled()) {
                boolean isServerSide;
                boolean bl = isServerSide = !player.level().isClientSide();
                if (isServerSide || player.isCreative()) {
                    ItemStack result = combine.result().copy();
                    added.shrink(1);
                    strangeScroll.shrink(1);
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)result);
                    if (isServerSide) {
                        ModTriggers.combine_in_inventory.trigger((ServerPlayer)player);
                    } else {
                        PacketHandler.sendToServer(new SMessageCombination(SMessageCombination.CombineType.COMBINE_IN_INVENTORY));
                    }
                }
            } else if (player.level().isClientSide) {
                ProxyHelper.addToast(combine.added(), combine.result(), (Component)LangKey.MESSAGE_DISABLED.getText(StyleType.COLOR_RED, new Object[0]));
            }
            return true;
        }
        return false;
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        if (this.tooltip == null) {
            this.tooltip = this.createTooltip();
        }
        return Optional.of(this.tooltip);
    }

    @Override
    public void addCombinations(List<CombineCraft> combinations) {
        combinations.add(new CombineCraft(new ItemStack((ItemLike)Items.RABBIT_FOOT), new ItemStack((ItemLike)ItemScrollBuff.SpellBuff.PRESERVATION.getItem()), ItemScrollBuff.SpellBuff.PRESERVATION::isEnabled));
        combinations.add(new CombineCraft(new ItemStack((ItemLike)Items.GHAST_TEAR), new ItemStack((ItemLike)ItemScrollBuff.SpellBuff.UNSTABLE_INTANGIBILITY.getItem()), ItemScrollBuff.SpellBuff.UNSTABLE_INTANGIBILITY::isEnabled));
        combinations.add(new CombineCraft((TagKey<Item>)Tags.Items.FEATHERS, new ItemStack((ItemLike)ItemScrollBuff.SpellBuff.FEATHER_FALL.getItem()), ItemScrollBuff.SpellBuff.FEATHER_FALL::isEnabled));
        combinations.add(new CombineCraft((TagKey<Item>)Tags.Items.GEMS_LAPIS, new ItemStack((ItemLike)ItemScrollBuff.SpellBuff.PURIFICATION.getItem()), ItemScrollBuff.SpellBuff.PURIFICATION::isEnabled));
        combinations.add(new CombineCraft(new ItemStack((ItemLike)Items.FERMENTED_SPIDER_EYE), new ItemStack((ItemLike)ItemScrollBuff.SpellBuff.TRUE_SIGHT.getItem()), ItemScrollBuff.SpellBuff.TRUE_SIGHT::isEnabled));
        combinations.add(new CombineCraft(new ItemStack((ItemLike)Items.SUNFLOWER), new ItemStack((ItemLike)ItemScrollBuff.SpellBuff.REACH.getItem()), ItemScrollBuff.SpellBuff.REACH::isEnabled));
        combinations.add(new CombineCraft(new ItemStack((ItemLike)Items.LIGHTNING_ROD), new ItemStack((ItemLike)ItemScrollBuff.SpellBuff.LIGHTNING_RESISTANCE.getItem()), ItemScrollBuff.SpellBuff.LIGHTNING_RESISTANCE::isEnabled));
        combinations.add(new CombineCraft(new ItemStack((ItemLike)Items.SNOWBALL), new ItemStack((ItemLike)ItemScrollBuff.SpellBuff.FROST_RESISTANCE.getItem()), ItemScrollBuff.SpellBuff.FROST_RESISTANCE::isEnabled));
        combinations.add(new CombineCraft(new ItemStack((ItemLike)Items.NAUTILUS_SHELL), new ItemStack((ItemLike)ItemScrollBuff.SpellBuff.AQUATIC_LIFE.getItem()), ItemScrollBuff.SpellBuff.AQUATIC_LIFE::isEnabled));
        combinations.add(new CombineCraft(new ItemStack((ItemLike)Items.HONEYCOMB), new ItemStack((ItemLike)ItemScrollBuff.SpellBuff.MERCY.getItem()), ItemScrollBuff.SpellBuff.MERCY::isEnabled));
        combinations.add(new CombineCraft((TagKey<Item>)Tags.Items.DUSTS_GLOWSTONE, new ItemStack((ItemLike)ModItems.scroll_of_knowledge), ModItems.scroll_of_knowledge::isEnabled));
    }
}

