/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import ovh.corail.tombstone.helper.ProxyHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.item.ItemGeneric;

public class ItemRitualFlute
extends ItemGeneric {
    public ItemRitualFlute() {
        super("ritual_flute", ItemRitualFlute.getBuilder().stacksTo(1).fireResistant());
    }

    @Override
    protected void addTooltipInfo(ItemStack stack, Item.TooltipContext context, List<Component> tooltip) {
        this.withDefaultInfo();
        super.addTooltipInfo(stack, context, tooltip);
    }

    public Component getName(ItemStack stack) {
        return super.getName(stack).plainCopy().setStyle(StyleType.MESSAGE_SPECIAL);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack;
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        if (level.isClientSide && (stack = player.getItemInHand(hand)).is((Item)this)) {
            ProxyHelper.openRitualFluteScreen();
        }
        return InteractionResultHolder.sidedSuccess((Object)player.getItemInHand(hand), (boolean)level.isClientSide());
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }
}

