/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import ovh.corail.tombstone.api.item.ISoulConsumer;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.item.ItemBook;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemBookOfRepairing
extends ItemBook {
    public ItemBookOfRepairing() {
        super("book_of_repairing", () -> SharedConfigTombstone.allowed_magic_items.allowBookOfRepairing.get());
    }

    @Override
    public ISoulConsumer.ConsumeResult setEnchant(Level level, BlockPos gravePos, ServerPlayer player, ItemStack stack, int soulStrength) {
        ItemStack mainhand;
        if (stack.getItem() != this || (mainhand = player.getMainHandItem()).isEmpty() || !mainhand.isDamaged()) {
            return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_REPAIRING_FAILED.getText(new Object[0]));
        }
        int cost = mainhand.has(DataComponents.CUSTOM_NAME) ? 1 : 0;
        int enchantmentCount = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)mainhand).size();
        if (enchantmentCount > 5) {
            for (int i = 0; i < enchantmentCount; ++i) {
                cost += AnvilMenu.calculateIncreasedRepairCost((int)cost);
            }
        }
        if (cost == 0) {
            mainhand.set(DataComponents.REPAIR_COST, (Object)0);
        } else if (cost < (Integer)mainhand.getOrDefault(DataComponents.REPAIR_COST, (Object)0)) {
            mainhand.set(DataComponents.REPAIR_COST, (Object)cost);
        }
        mainhand.set(DataComponents.DAMAGE, (Object)0);
        stack.shrink(1);
        ModTriggers.use_repairing.trigger(player);
        return ISoulConsumer.ConsumeResult.success((Component)LangKey.MESSAGE_REPAIRING_SUCCESS.getText(new Object[0]), 1);
    }
}

