/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import ovh.corail.tombstone.block.SoulType;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.gui.ScreenKnowledge;
import ovh.corail.tombstone.gui.ScreenReadableScroll;
import ovh.corail.tombstone.gui.ScreenRitualFlute;
import ovh.corail.tombstone.helper.CustomToast;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.PlayerPreference;
import ovh.corail.tombstone.item.CastingType;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.SMessagePlayerPreference;
import ovh.corail.tombstone.particle.ParticleCasting;
import ovh.corail.tombstone.particle.ParticleGraveSmoke;
import ovh.corail.tombstone.particle.ParticleGraveSoul;
import ovh.corail.tombstone.particle.ParticleMagicCircle;
import ovh.corail.tombstone.particle.ParticleRounding;
import ovh.corail.tombstone.particle.ParticleSmokeColumn;

@EventBusSubscriber(modid="tombstone", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public class ProxyHelper {
    private static boolean isConfigDirty = false;
    private static PlayerPreference lastPlayerPreference;

    public static void markConfigDirty() {
        isConfigDirty = true;
    }

    public static PlayerPreference initPlayerPreference() {
        lastPlayerPreference = PlayerPreference.fromClientConfig();
        return lastPlayerPreference;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onClientTick(ClientTickEvent.Post event) {
        if (isConfigDirty) {
            isConfigDirty = false;
            if (Minecraft.getInstance().player == null || lastPlayerPreference == null) {
                lastPlayerPreference = PlayerPreference.fromClientConfig();
            } else if (lastPlayerPreference.hasChangedFromConfig()) {
                ProxyHelper.getClientPlayer().ifPresent(x$0 -> LangKey.MESSAGE_SYNC_TO_SERVER.sendMessage((Player)x$0, new Object[0]));
                lastPlayerPreference = PlayerPreference.fromClientConfig();
                PacketHandler.sendToServer(new SMessagePlayerPreference(lastPlayerPreference, false));
            }
        }
    }

    public static Optional<Level> getClientWorld() {
        try {
            return Optional.ofNullable(Minecraft.getInstance().level);
        }
        catch (Throwable throwable) {
            return Optional.empty();
        }
    }

    public static Optional<Player> getClientPlayer() {
        try {
            return Optional.ofNullable(Minecraft.getInstance().player);
        }
        catch (Throwable throwable) {
            return Optional.empty();
        }
    }

    public static void addToast(ItemStack initial, ItemStack added, Component description) {
        CustomToast.INSTANCE.addCombination(initial, added, description);
    }

    public static void openKnowledgeScreen() {
        ProxyHelper.getClientPlayer().ifPresent(player -> Minecraft.getInstance().setScreen((Screen)new ScreenKnowledge((Player)player)));
    }

    public static void openReadableScrollScreen(String id, int part) {
        Minecraft.getInstance().setScreen((Screen)new ScreenReadableScroll(id, part));
    }

    public static void openRitualFluteScreen() {
        Minecraft.getInstance().setScreen((Screen)new ScreenRitualFlute());
    }

    public static void produceGraveSmoke(Level level, int count, double x, double y, double z, int color) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.isPaused()) {
            return;
        }
        if (mc.gameRenderer.getMainCamera().getPosition().distanceToSqr(x, y, z) <= 1024.0 && Helper.RANDOM.nextBoolean()) {
            IntStream.range(0, count).forEach(i -> mc.particleEngine.add((Particle)new ParticleGraveSmoke((ClientLevel)level, x + level.random.nextGaussian(), y, z + level.random.nextGaussian(), (double)(level.random.nextFloat() - 0.5f) * 0.01, 0.0, (double)(level.random.nextFloat() - 0.5f) * 0.01).withColor(color)));
        }
    }

    public static void produceShield(LivingEntity entity) {
        Minecraft mc = Minecraft.getInstance();
        if (!(mc.isPaused() || mc.level == null || entity.isPassenger() || entity.isSleeping())) {
            mc.particleEngine.add((Particle)new ParticleRounding(mc.level, entity, ParticleRounding.Type.SHIELD));
        }
    }

    public static void producePray(LivingEntity entity, int type, Predicate<LivingEntity> predic) {
        Minecraft mc = Minecraft.getInstance();
        if (!mc.isPaused() && mc.level != null) {
            mc.particleEngine.add((Particle)new ParticleRounding(mc.level, entity, ParticleRounding.Type.byId(type), predic));
            mc.particleEngine.add((Particle)new ParticleCasting(mc.level, entity, predic));
        }
    }

    public static void produceBoneShield(LivingEntity entity) {
        Minecraft mc = Minecraft.getInstance();
        if (!(mc.isPaused() || mc.level == null || entity.isPassenger() || entity.isSleeping())) {
            mc.particleEngine.add((Particle)new ParticleRounding(mc.level, entity, ParticleRounding.Type.BONE));
        }
    }

    public static void produceGraveSoul(Level level, BlockPos pos, SoulType soulType, int part) {
        Minecraft mc = Minecraft.getInstance();
        if (!mc.isPaused() && mc.gameRenderer.getMainCamera().getPosition().distanceToSqr((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()) <= 1024.0) {
            mc.particleEngine.add((Particle)new ParticleGraveSoul((ClientLevel)level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.85, (double)pos.getZ() + 0.5, soulType.ordinal(), part));
        }
    }

    public static void produceParticleCasting(CastingType castingType, LivingEntity entity, Predicate<LivingEntity> predic) {
        Minecraft mc = Minecraft.getInstance();
        if (!mc.isPaused() && entity != null && mc.level != null) {
            if (((Boolean)ConfigTombstone.client.showMagicCircle.get()).booleanValue()) {
                mc.particleEngine.add((Particle)new ParticleMagicCircle(mc.level, castingType, entity, predic));
            }
            mc.particleEngine.add((Particle)new ParticleCasting(mc.level, entity, predic));
        }
    }

    public static void produceParticleCasting(double radius, int color, LivingEntity entity, Predicate<LivingEntity> predic) {
        Minecraft mc = Minecraft.getInstance();
        if (!mc.isPaused() && entity != null && mc.level != null) {
            mc.particleEngine.add((Particle)new ParticleCasting(mc.level, entity, predic).withColor(color));
        }
    }

    public static void produceSmokeColumn(Level level, Vec3 posVec) {
        Minecraft.getInstance().particleEngine.add((Particle)new ParticleSmokeColumn((ClientLevel)level, posVec.x, posVec.y, posVec.z));
    }
}

