/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.common.ModConfigSpec;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.GlobalClock;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.ProxyHelper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.network.CMessageCooldown;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.registry.ModItems;

public final class CooldownHandler {
    public static final CooldownHandler INSTANCE = new CooldownHandler();
    private final Map<UUID, Map<CooldownType, Long>> serverCooldowns = new ConcurrentHashMap<UUID, Map<CooldownType, Long>>();
    private final Map<CooldownType, Long> clientCooldowns = Collections.synchronizedMap(new EnumMap(CooldownType.class));
    public static final String STORED_COOLDOWNS = "tb_stored_cooldown";
    public static final String COOLDOWNS_NBT_LIST = "tb_cooldowns";
    private static final String ID_NBT_BYTE = "id";
    private static final String CD_NBT_LONG = "cd";

    public int getCooldown(Player player, CooldownType cooldownType) {
        Map<CooldownType, Long> cooldowns;
        Map<CooldownType, Long> map = cooldowns = player.level().isClientSide() ? this.clientCooldowns : this.serverCooldowns.get(player.getUUID());
        if (cooldowns == null) {
            return 0;
        }
        long cooldownTime = cooldowns.getOrDefault((Object)cooldownType, -1L);
        if (cooldownTime <= 0L) {
            return 0;
        }
        return (int)Math.max(0L, cooldownTime - GlobalClock.INSTANCE.getTime(player.level()));
    }

    public boolean hasCooldown(Player player, CooldownType cooldownType) {
        return this.getCooldown(player, cooldownType) > 0;
    }

    public void setMaxCooldown(ServerPlayer serverPlayer, CooldownType cooldownType) {
        if (EntityHelper.isValidServerPlayer(serverPlayer)) {
            this.updateOnCooldownChanged(serverPlayer, cooldownType, GlobalClock.INSTANCE.getTime(serverPlayer.level()) + (long)cooldownType.getMaxCooldown());
        }
    }

    public void setCooldown(ServerPlayer serverPlayer, CooldownType cooldownType, int time) {
        if (EntityHelper.isValidServerPlayer(serverPlayer)) {
            this.updateOnCooldownChanged(serverPlayer, cooldownType, time == 0 ? 0L : GlobalClock.INSTANCE.getTime(serverPlayer.level()) + (long)Math.min(time, cooldownType.getMaxCooldown()));
        }
    }

    private void updateOnCooldownChanged(ServerPlayer serverPlayer, CooldownType cooldownType, long cooldownTime) {
        Map<CooldownType, Long> cooldowns = this.serverCooldowns.get(serverPlayer.getUUID());
        cooldowns.put(cooldownType, cooldownTime);
        this.saveServerPlayerCooldowns(serverPlayer, cooldowns);
        if (cooldownType.isSync()) {
            PacketHandler.sendToPlayer(new CMessageCooldown(cooldownType, cooldownTime), serverPlayer);
        }
    }

    public void updateClientCooldown(CooldownType cooldownType, long cooldownTime) {
        ProxyHelper.getClientPlayer().ifPresent(player -> {
            if (cooldownTime <= GlobalClock.INSTANCE.getTime(player.level())) {
                this.clientCooldowns.remove((Object)cooldownType);
            } else {
                this.clientCooldowns.put(cooldownType, cooldownTime);
            }
            if (cooldownType == CooldownType.NEXT_PRAY) {
                EntityHelper.removeGlobalItemCooldown(player, ModItems.ankh_of_prayer);
            }
        });
    }

    public void updateAllClientCooldowns(ListTag listTag) {
        ProxyHelper.getClientPlayer().ifPresent(player -> {
            this.clientCooldowns.clear();
            this.loadPlayerCooldownsFromListTag((Player)player, listTag, this.clientCooldowns);
            EntityHelper.removeGlobalItemCooldown(player, ModItems.ankh_of_prayer);
        });
    }

    public void init(ServerPlayer serverPlayer) {
        Map cooldowns = this.serverCooldowns.computeIfAbsent(serverPlayer.getUUID(), uuid -> {
            Map<CooldownType, Long> cooldownMap = Collections.synchronizedMap(new EnumMap(CooldownType.class));
            long globalTime = GlobalClock.INSTANCE.getTime(serverPlayer.level());
            CompoundTag persistentTag = EntityHelper.getPersistentTag((Player)serverPlayer);
            if (persistentTag.contains(STORED_COOLDOWNS)) {
                int[] cds = persistentTag.getIntArray(STORED_COOLDOWNS);
                for (CooldownType cooldownType : CooldownType.values()) {
                    int i = cooldownType.ordinal();
                    if (i >= cds.length || cds[i] <= 0) continue;
                    cooldownMap.put(cooldownType, globalTime + (long)cds[i]);
                }
                persistentTag.remove(STORED_COOLDOWNS);
                return cooldownMap;
            }
            return this.loadPlayerCooldownsFromListTag((Player)serverPlayer, NBTStackHelper.getListOrCreate(persistentTag, COOLDOWNS_NBT_LIST), cooldownMap);
        });
        this.saveServerPlayerCooldowns(serverPlayer, cooldowns);
    }

    public ListTag getClientCooldowns(ServerPlayer serverPlayer) {
        Map<CooldownType, Long> cooldowns = this.serverCooldowns.get(serverPlayer.getUUID());
        ListTag listTag = new ListTag();
        for (CooldownType cooldownType : cooldowns.keySet()) {
            long cooldownTime;
            if (!cooldownType.isSync() || (cooldownTime = cooldowns.getOrDefault((Object)cooldownType, -1L).longValue()) <= 0L) continue;
            this.writeCooldownInListTag(listTag, cooldownType, cooldownTime);
        }
        return listTag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<CooldownType, Long> loadPlayerCooldownsFromListTag(Player player, ListTag listTag, Map<CooldownType, Long> cooldowns) {
        long globalTime = GlobalClock.INSTANCE.getTime(player.level());
        Map<CooldownType, Long> map = cooldowns;
        synchronized (map) {
            for (Tag inbt : listTag) {
                CompoundTag nbt = (CompoundTag)inbt;
                byte id = nbt.getByte(ID_NBT_BYTE);
                if (id < 0 || id >= CooldownType.values().length) continue;
                CooldownType cooldownType = CooldownType.values()[id];
                long cooldownTime = nbt.getLong(CD_NBT_LONG);
                if (cooldownTime - globalTime <= 0L) {
                    cooldowns.remove((Object)cooldownType);
                    continue;
                }
                cooldowns.put(cooldownType, Math.min(cooldownTime, globalTime + (long)cooldownType.getMaxCooldown()));
            }
        }
        return cooldowns;
    }

    private void saveServerPlayerCooldowns(ServerPlayer serverPlayer, Map<CooldownType, Long> cooldowns) {
        ListTag listTag = new ListTag();
        for (CooldownType cooldownType : CooldownType.values()) {
            long cooldownTime = cooldowns.getOrDefault((Object)cooldownType, -1L);
            if (cooldownTime <= 0L) continue;
            this.writeCooldownInListTag(listTag, cooldownType, cooldownTime);
        }
        EntityHelper.getPersistentTag((Player)serverPlayer).put(COOLDOWNS_NBT_LIST, (Tag)listTag);
    }

    private void writeCooldownInListTag(ListTag listTag, CooldownType type, long cooldownTime) {
        CompoundTag nbt = new CompoundTag();
        nbt.putByte(ID_NBT_BYTE, (byte)type.ordinal());
        nbt.putLong(CD_NBT_LONG, cooldownTime);
        listTag.add((Object)nbt);
    }

    public void storeCooldowns(ServerPlayer serverPlayer) {
        EntityHelper.getPersistentTag((Player)serverPlayer).putIntArray(STORED_COOLDOWNS, Arrays.stream(CooldownType.values()).mapToInt(t -> this.getCooldown((Player)serverPlayer, (CooldownType)((Object)t))).toArray());
    }

    public void clear() {
        this.serverCooldowns.clear();
    }

    public static enum CooldownType {
        NEXT_PRAY(SharedConfigTombstone.decorative_grave.prayerCooldown, true),
        RESET_PERKS(SharedConfigTombstone.magic_item.cooldownResetPerk),
        TELEPORT_DEATH(ConfigTombstone.general.cooldownTeleportDeath),
        REQUEST_TELEPORT(ConfigTombstone.general.cooldownRequestTeleport);

        private final ModConfigSpec.ConfigValue<Integer> maxCooldownConfig;
        private final boolean isSync;

        private CooldownType(ModConfigSpec.ConfigValue<Integer> maxCooldown) {
            this(maxCooldown, false);
        }

        private CooldownType(ModConfigSpec.ConfigValue<Integer> maxCooldownConfig, boolean isSync) {
            this.maxCooldownConfig = maxCooldownConfig;
            this.isSync = isSync;
        }

        public int getMaxCooldown() {
            return TimeHelper.tickFromMinute((Integer)this.maxCooldownConfig.get());
        }

        public boolean isSync() {
            return this.isSync;
        }
    }
}

