/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.FontHelper;

@OnlyIn(value=Dist.CLIENT)
public abstract class TBScreen
extends Screen {
    private static final ResourceLocation BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"textures/gui/crow.png");
    public static final ResourceLocation FRAME = ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"textures/gui/frame.png");
    final int xSize = 345;
    final int ySize = 230;
    int halfWidth;
    int halfHeight;
    int guiLeft;
    int guiTop;
    int guiRight;
    int guiBottom;
    final int oldScale;
    boolean isResized = false;

    TBScreen(Component titleIn) {
        super(titleIn);
        this.oldScale = (Integer)Minecraft.getInstance().options.guiScale().get();
    }

    public void init() {
        if (((Boolean)ConfigTombstone.client.scaleGuiscreens.get()).booleanValue()) {
            Minecraft mc = Minecraft.getInstance();
            int screenWidth = mc.getWindow().getWidth();
            int screenHeight = mc.getWindow().getHeight();
            int maxScale = Math.max(1, Math.min(screenWidth / this.xSize, screenHeight / this.ySize));
            if ((Integer)mc.options.guiScale().get() != maxScale) {
                mc.options.guiScale().set((Object)maxScale);
                this.isResized = true;
            }
        }
        this.halfWidth = this.width / 2;
        this.halfHeight = this.height / 2;
        this.guiLeft = (this.width - this.xSize) / 2;
        this.guiTop = (this.height - this.ySize) / 2;
        this.guiRight = this.guiLeft + this.xSize;
        this.guiBottom = this.guiTop + this.ySize;
    }

    public void onClose() {
        super.onClose();
        if (((Boolean)ConfigTombstone.client.scaleGuiscreens.get()).booleanValue()) {
            Minecraft mc = Minecraft.getInstance();
            if ((Integer)mc.options.guiScale().get() != this.oldScale) {
                mc.options.guiScale().set((Object)this.oldScale);
                mc.resizeDisplay();
            }
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        guiGraphics.fill(0, 0, this.width, this.height, -16777216);
        guiGraphics.fill(this.guiLeft - 3, this.guiTop - 3, this.guiLeft + this.xSize + 3, this.guiTop + this.ySize + 3, -1);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.blit(this.getBackground(), this.guiLeft, this.guiTop, 0.0f, 0.0f, this.xSize, this.ySize, this.xSize, this.ySize);
        RenderSystem.disableBlend();
    }

    protected ResourceLocation getBackground() {
        return BACKGROUND;
    }

    protected void drawTitle(GuiGraphics guiGraphics, Component title) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.hLine(this.guiLeft + 5, this.guiRight - 5, this.guiTop + 4, -1);
        guiGraphics.hLine(this.guiLeft + 5, this.guiRight - 5, this.guiTop + 6, -1);
        PoseStack poseStack = guiGraphics.pose();
        if (FontHelper.isValidLanguageForFantasy()) {
            FontHelper.drawCentered(guiGraphics, this.font, FontHelper.withLargeFantasyFont(title), this.halfWidth, this.guiTop + 15, -1);
        } else {
            float scale = 1.8f;
            float inverseScale = 0.5555556f;
            poseStack.pushPose();
            poseStack.scale(scale, scale, 1.0f);
            FontHelper.drawCentered(guiGraphics, this.font, FontHelper.withLargeFantasyFont(title), (float)this.halfWidth * inverseScale, (float)(this.guiTop + 11) * inverseScale, -1);
            poseStack.popPose();
        }
        guiGraphics.hLine(this.guiLeft + 5, this.guiRight - 5, this.guiTop + 28, -1);
        guiGraphics.hLine(this.guiLeft + 5, this.guiRight - 5, this.guiTop + 30, -1);
    }

    public void tick() {
        if (this.isResized) {
            this.isResized = false;
            Minecraft.getInstance().resizeDisplay();
        }
    }
}

