/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import ovh.corail.tombstone.gui.CustomButton;
import ovh.corail.tombstone.helper.FontHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.SMessageRitualFlutePlayedNote;
import ovh.corail.tombstone.network.SMessageRitualFluteValidation;

@OnlyIn(value=Dist.CLIENT)
public class ScreenRitualFlute
extends Screen {
    private static final ResourceLocation BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"textures/gui/bg_music.png");
    private static final Map<Integer, NoteInfo> KEY_TO_NOTE_INFO = new HashMap<Integer, NoteInfo>(){
        {
            this.put(83, new NoteInfo("c", "S", 6, 0, 40));
            this.put(68, new NoteInfo("d", "D", 8, 25, 40));
            this.put(70, new NoteInfo("e", "F", 10, 50, 40));
            this.put(71, new NoteInfo("f", "G", 11, 75, 40));
            this.put(72, new NoteInfo("g", "H", 13, 100, 40));
            this.put(74, new NoteInfo("a", "J", 15, 125, 40));
            this.put(75, new NoteInfo("b", "K", 17, 150, 40));
            this.put(76, new NoteInfo("c'", "L", 18, 175, 40));
            this.put(69, new NoteInfo("c#", "E", 7, 13, 19));
            this.put(82, new NoteInfo("d#", "R", 9, 38, 19));
            this.put(89, new NoteInfo("f#", "Y", 12, 88, 19));
            this.put(85, new NoteInfo("g#", "U", 14, 113, 19));
            this.put(73, new NoteInfo("a#", "I", 16, 138, 19));
        }
    };
    private final List<NoteInfo> currentNotes = new ArrayList<NoteInfo>();
    private final int xSize = 300;
    private final int ySize = 200;
    private int halfWidth;
    private int halfHeight;
    private int guiLeft;
    private int guiTop;
    private boolean inputBlocked = false;
    private Component message = Component.empty();
    private int lastPressedKeyId = -1;
    private int lastPressedKeyTime = 0;
    private boolean isClosing = false;
    private int messageDisplayTicks = 0;
    private boolean freeMode = false;
    private final Set<Integer> noRepeatKeys = new HashSet<Integer>();

    public ScreenRitualFlute() {
        super((Component)Component.translatable((String)"tombstone.gui.ritual_flute.title"));
    }

    protected void init() {
        this.halfWidth = this.width / 2;
        this.halfHeight = this.height / 2;
        this.guiLeft = (this.width - this.xSize) / 2;
        this.guiTop = (this.height - this.ySize) / 2;
        this.addRenderableWidget((GuiEventListener)new CustomButton(this.halfWidth - 25, this.halfHeight - 5, 50, 10, (Component)Component.translatable((String)"tombstone.gui.ritual_flute.ritual_mode"), btn -> {
            this.freeMode = !this.freeMode;
            btn.setMessage((Component)Component.translatable((String)(this.freeMode ? "tombstone.gui.ritual_flute.free_mode" : "tombstone.gui.ritual_flute.ritual_mode")));
            this.currentNotes.clear();
            this.inputBlocked = false;
            this.setMessage((Component)Component.translatable((String)"tombstone.gui.ritual_flute.mode_activated", (Object[])new Object[]{Component.translatable((String)("tombstone.gui.ritual_flute." + (this.freeMode ? "free" : "ritual") + "_mode"))}).withStyle(StyleType.COLOR_GREEN));
        }, () -> true));
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (!this.noRepeatKeys.add(keyCode)) {
            return false;
        }
        if (!this.freeMode && keyCode == 259) {
            this.currentNotes.clear();
            return true;
        }
        NoteInfo noteInfo = KEY_TO_NOTE_INFO.get(keyCode);
        if (noteInfo != null && this.lastPressedKeyTime < 17) {
            if (this.freeMode || this.currentNotes.size() < 8) {
                this.resetMessage();
                this.currentNotes.add(noteInfo);
                this.lastPressedKeyId = noteInfo.noteId;
                this.lastPressedKeyTime = 20;
                PacketHandler.sendToServer(new SMessageRitualFlutePlayedNote(noteInfo.noteId));
                if (!this.freeMode && this.currentNotes.size() == 8) {
                    int[] notes = new int[8];
                    for (int i = 0; i < this.currentNotes.size(); ++i) {
                        notes[i] = this.currentNotes.get((int)i).noteId;
                    }
                    PacketHandler.sendToServer(new SMessageRitualFluteValidation(notes));
                    this.inputBlocked = true;
                }
            }
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        this.noRepeatKeys.remove(keyCode);
        return super.keyReleased(keyCode, scanCode, modifiers);
    }

    public void onValidationResult(boolean valid) {
        if (valid) {
            this.setMessage((Component)Component.translatable((String)"tombstone.gui.ritual_flute.melody_success").withStyle(StyleType.COLOR_GREEN));
            this.isClosing = true;
        } else {
            this.setMessage((Component)Component.translatable((String)"tombstone.gui.ritual_flute.melody_failed").withStyle(StyleType.COLOR_RED));
            this.currentNotes.clear();
            this.inputBlocked = false;
        }
        Optional.ofNullable(Minecraft.getInstance().player).ifPresent(p -> p.playSound(valid ? SoundEvents.PLAYER_LEVELUP : SoundEvents.VILLAGER_NO, 1.0f, 1.0f));
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBlurredBackground(partialTicks);
        guiGraphics.fill(this.guiLeft - 3, this.guiTop - 3, this.guiLeft + this.xSize + 3, this.guiTop + this.ySize + 3, -1);
        guiGraphics.fill(this.guiLeft, this.guiTop, this.guiLeft + this.xSize, this.guiTop + this.ySize, -16777216);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.blit(BACKGROUND, this.guiLeft, this.guiTop, 0.0f, 0.0f, this.xSize, this.ySize, this.xSize, this.ySize);
        RenderSystem.disableBlend();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        int baseColor = -1875;
        guiGraphics.fill(this.halfWidth - 51, this.guiTop + 2, this.halfWidth + 51, this.guiTop + 14, -1);
        guiGraphics.fill(this.halfWidth - 50, this.guiTop + 3, this.halfWidth + 50, this.guiTop + 13, -8481796);
        guiGraphics.drawCenteredString(this.font, FontHelper.withFantasyFont((Component)Component.translatable((String)"tombstone.gui.ritual_flute.title")), this.halfWidth, this.guiTop + 4, baseColor);
        if (!this.freeMode) {
            guiGraphics.drawCenteredString(this.font, FontHelper.withFantasyFont((Component)Component.translatable((String)"tombstone.gui.ritual_flute.played_notes")), this.halfWidth, this.guiTop + 50, baseColor);
        }
        if (this.inputBlocked && !this.isClosing) {
            guiGraphics.drawCenteredString(this.font, (Component)Component.translatable((String)"tombstone.gui.ritual_flute.waiting_validation"), this.halfWidth, this.guiTop + 20, -1);
        } else if (this.messageDisplayTicks > 0) {
            guiGraphics.drawCenteredString(this.font, this.message, this.halfWidth, this.guiTop + 20, -1);
        }
        int squareSize = 20;
        int startLeft = this.guiLeft + (this.xSize - 196) / 2;
        if (!this.freeMode) {
            for (int i = 0; i < 8; ++i) {
                int startX = startLeft + i * 25;
                int startY = this.guiTop + 65;
                guiGraphics.fill(startX - 1, startY - 1, startX + squareSize + 1, startY + squareSize + 1, baseColor);
                guiGraphics.fill(startX, startY, startX + squareSize, startY + squareSize, -16777216);
                FontHelper.drawCentered(guiGraphics, this.font, (Component)(i < this.currentNotes.size() ? FontHelper.withFantasyFont((Component)Component.literal((String)this.currentNotes.get((int)i).noteName)) : Component.literal((String)"\ud83c\udfb5")), (float)startX + (float)squareSize / 2.0f, startY + 6, -8481796);
            }
        }
        for (NoteInfo noteInfo : KEY_TO_NOTE_INFO.values()) {
            int startX = startLeft + noteInfo.x;
            int startY = this.halfHeight + noteInfo.y;
            boolean pressed = noteInfo.noteId == this.lastPressedKeyId;
            guiGraphics.fill(startX - 1, startY - 1, startX + squareSize + 1, startY + squareSize + 1, baseColor);
            guiGraphics.fill(startX, startY, startX + squareSize, startY + squareSize, pressed ? -32 : -16777216);
            FontHelper.drawCentered(guiGraphics, this.font, (Component)Component.literal((String)noteInfo.keyName), (float)startX + (float)squareSize / 2.0f, startY + 2, -8481796);
            Component component = FontHelper.withFantasyFont((Component)Component.literal((String)noteInfo.noteName));
            float f = (float)startX + (float)squareSize / 2.0f;
            Objects.requireNonNull(this.font);
            FontHelper.drawCentered(guiGraphics, this.font, component, f, startY + 2 + 9, -8481796);
        }
        if (!this.freeMode) {
            guiGraphics.drawCenteredString(this.font, FontHelper.withFantasyFont((Component)Component.translatable((String)"tombstone.gui.ritual_flute.backward_to_reset")), this.halfWidth, this.halfHeight + 70, baseColor);
        }
    }

    private void setMessage(Component message) {
        this.message = message;
        this.messageDisplayTicks = 40;
    }

    private void resetMessage() {
        this.message = Component.empty();
        this.messageDisplayTicks = 0;
    }

    public void tick() {
        super.tick();
        if (this.messageDisplayTicks > 0 && --this.messageDisplayTicks == 0) {
            this.resetMessage();
            if (this.isClosing) {
                this.onClose();
            }
        }
        if (this.lastPressedKeyTime > 0 && --this.lastPressedKeyTime == 0) {
            this.lastPressedKeyId = -1;
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    private record NoteInfo(String noteName, String keyName, int noteId, int x, int y) {
    }
}

