/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.gui.CompendiumData;
import ovh.corail.tombstone.gui.CustomButton;
import ovh.corail.tombstone.gui.TBScreen;
import ovh.corail.tombstone.helper.FontHelper;
import ovh.corail.tombstone.helper.LangKey;

@OnlyIn(value=Dist.CLIENT)
public final class ScreenCompendium
extends TBScreen {
    private static final ResourceLocation BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"textures/gui/tomb.png");
    private static final ResourceLocation ARROW_UP = ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"textures/gui/arrow-up.png");
    private static final ResourceLocation ARROW_DOWN = ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"textures/gui/arrow-down.png");
    private static final int VISIBLE_LINES = 15;
    private CompendiumData currentInfo;
    @Nullable
    private CompendiumData.CompendiumLabel hoveredInfo = null;
    private int scrollOffset = 0;

    ScreenCompendium() {
        this(CompendiumData.CompendiumLabel.COMPENDIUM);
    }

    public ScreenCompendium(CompendiumData.CompendiumLabel compendiumLabel) {
        super((Component)LangKey.MESSAGE_COMPENDIUM.getText(new Object[0]));
        this.currentInfo = CompendiumData.getInfo(compendiumLabel);
    }

    @Override
    public void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)new CustomButton(this.halfWidth - 35, this.guiBottom - 25, 70, 15, (Component)LangKey.MESSAGE_BACK.getText(new Object[0]), pressable -> {
            if (this.currentInfo.isIndex()) {
                this.onClose();
            } else {
                this.updateInfo(CompendiumData.CompendiumLabel.COMPENDIUM);
            }
        }));
    }

    @Override
    protected ResourceLocation getBackground() {
        return BACKGROUND;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 0 && this.hoveredInfo != null) {
            this.updateInfo(this.hoveredInfo);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (scrollY < 0.0) {
            this.scrollOffset = Math.min(this.scrollOffset + 1, Math.max(0, this.currentInfo.getDescription().size() - 15));
        } else if (scrollY > 0.0) {
            this.scrollOffset = Math.max(this.scrollOffset - 1, 0);
        }
        return true;
    }

    private void updateInfo(CompendiumData.CompendiumLabel info) {
        this.currentInfo = CompendiumData.getInfo(info);
        this.scrollOffset = 0;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.drawTitle(guiGraphics, this.currentInfo.getTitle());
        if (!this.currentInfo.getIcon().isEmpty()) {
            guiGraphics.fill(this.guiLeft + 8, this.guiTop + 8, this.guiLeft + 26, this.guiTop + 26, 0x10FFFFFF);
            guiGraphics.blit(FRAME, this.guiLeft + 7, this.guiTop + 7, 0.0f, 0.0f, 21, 21, 21, 21);
            guiGraphics.renderItem(this.currentInfo.getIcon(), this.guiLeft + 9, this.guiTop + 9);
        }
        if (this.scrollOffset > 0) {
            guiGraphics.blit(ARROW_UP, this.halfWidth - 5, this.guiTop + 36, 0.0f, 0.0f, 10, 7, 10, 7);
        }
        this.drawDescription(guiGraphics);
        if (this.scrollOffset < this.currentInfo.getDescription().size() - 15) {
            guiGraphics.blit(ARROW_DOWN, this.halfWidth - 5, this.guiTop + 192, 0.0f, 0.0f, 10, 7, 10, 7);
        }
        float scale = 0.5f;
        float inverseScale = 2.0f;
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.scale(scale, scale, 1.0f);
        int minX = this.guiRight - 100;
        int minY = this.guiTop + 50;
        this.hoveredInfo = null;
        for (CompendiumData.CompendiumLabel link : this.currentInfo.getLinks()) {
            Component label = FontHelper.withFantasyFont(link.getTitle());
            int maxX = minX + this.font.width((FormattedText)label);
            Objects.requireNonNull(this.font);
            int maxY = minY + 9;
            boolean isHovered = false;
            if (this.hoveredInfo == null && mouseX >= minX && mouseX <= maxX && mouseY >= minY && mouseY <= maxY) {
                this.hoveredInfo = link;
                isHovered = true;
            }
            guiGraphics.drawString(this.font, label, (int)((float)minX * inverseScale), (int)((float)(minY + 1) * inverseScale), isHovered ? -1875 : -1);
            minY = maxY + 1;
        }
        poseStack.popPose();
    }

    private void drawDescription(GuiGraphics guiGraphics) {
        int x = this.guiLeft + 10;
        int y = this.guiTop + 50;
        List<FormattedCharSequence> lines = this.currentInfo.getDescription();
        for (int i = 0; i < 15 && i + this.scrollOffset < lines.size(); ++i) {
            FormattedCharSequence line = lines.get(i + this.scrollOffset);
            Objects.requireNonNull(Minecraft.getInstance().font);
            guiGraphics.drawString(this.font, line, x, y + i * 9, -1);
        }
    }
}

