/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.event;

import com.google.common.collect.ImmutableList;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.village.VillageSiege;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.PhantomSpawner;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.event.AnvilUpdateEvent;
import net.neoforged.neoforge.event.CommandEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;
import net.neoforged.neoforge.event.entity.living.LivingConversionEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import net.neoforged.neoforge.event.entity.living.LivingExperienceDropEvent;
import net.neoforged.neoforge.event.entity.living.LivingHealEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.entity.player.AnvilRepairEvent;
import net.neoforged.neoforge.event.entity.player.CriticalHitEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.entity.player.PlayerWakeUpEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.ExplosionEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.api.event.PhantomSpawnerEvent;
import ovh.corail.tombstone.capability.EnhancedFamiliarHandler;
import ovh.corail.tombstone.capability.FriendlyAnimalHandler;
import ovh.corail.tombstone.capability.ProtectedEntityHandler;
import ovh.corail.tombstone.capability.ServantUndeadHandler;
import ovh.corail.tombstone.capability.SpellCasterHandler;
import ovh.corail.tombstone.capability.TBPlayerCapabilityHandler;
import ovh.corail.tombstone.command.CommandTBAcceptTeleport;
import ovh.corail.tombstone.command.CommandTBRecovery;
import ovh.corail.tombstone.command.CommandTBTeleport;
import ovh.corail.tombstone.command.TombstoneCommand;
import ovh.corail.tombstone.compatibility.CompatibilityCosmeticArmor;
import ovh.corail.tombstone.compatibility.CompatibilityFirstAid;
import ovh.corail.tombstone.compatibility.SupportMods;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.effect.TombstoneEffect;
import ovh.corail.tombstone.entity.Cloud;
import ovh.corail.tombstone.helper.BackupService;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.CooldownHandler;
import ovh.corail.tombstone.helper.DeathHandler;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EngravableHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.GlobalClock;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.InventoryHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.LootHelper;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.PlacedBlocksTracker;
import ovh.corail.tombstone.helper.PlayerPreference;
import ovh.corail.tombstone.helper.ProxyHelper;
import ovh.corail.tombstone.helper.RegistryHelper;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.helper.TamableType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.helper.UpdaterHandler;
import ovh.corail.tombstone.helper.WorldHelper;
import ovh.corail.tombstone.item.ItemCastableMagic;
import ovh.corail.tombstone.network.CMessageEffectStarted;
import ovh.corail.tombstone.network.CMessageEnhancedFamiliar;
import ovh.corail.tombstone.network.CMessageGlobalTime;
import ovh.corail.tombstone.network.CMessageLogin;
import ovh.corail.tombstone.network.CMessagePrayer;
import ovh.corail.tombstone.network.CMessageProtection;
import ovh.corail.tombstone.network.CMessageServant;
import ovh.corail.tombstone.network.CMessageSpellCasting;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModDamages;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModEnchantments;
import ovh.corail.tombstone.registry.ModEntities;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModPerks;
import ovh.corail.tombstone.registry.ModStats;
import ovh.corail.tombstone.registry.ModTags;
import ovh.corail.tombstone.registry.ModTriggers;
import ovh.corail.tombstone.spawner.CustomPhantomSpawner;
import ovh.corail.tombstone.spawner.CustomVillageSiege;

@EventBusSubscriber(modid="tombstone", bus=EventBusSubscriber.Bus.GAME)
public final class EventHandler {
    private static final String END_CONQUERED_EFFECTS_NBT_LIST = "tb_end_conquered_effects";
    private static long LAST_BACKUP = -1L;

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onServerStarting(ServerStartingEvent event) {
        TimeHelper.init();
        if (SupportMods.COSMETIC_ARMOR.isLoaded()) {
            CompatibilityCosmeticArmor.instance.handle();
        }
        if (SupportMods.FIRST_AID.isLoaded()) {
            CompatibilityFirstAid.instance.handle();
        }
        BackupService.get();
        UpdaterHandler.instance.checkVersion();
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onServerStoppingEvent(ServerStoppingEvent event) {
        CallbackHandler.flushTasks();
        PlayerPreference.clear();
        CooldownHandler.INSTANCE.clear();
        BackupService.stop();
        TamableType.clear();
        DeathHandler.INSTANCE.clear(event.getServer());
        event.getServer().getPlayerList().getPlayers().stream().filter(EntityHelper::isValidServerPlayer).forEach(CooldownHandler.INSTANCE::storeCooldowns);
        WorldHelper.clear();
        LootHelper.clear();
        TBPlayerCapabilityHandler.clearAllServerCache();
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (EntityHelper.isValidServerPlayer((Entity)event.getEntity())) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            if (TBPlayerCapabilityHandler.hasWatcherKnowledge((Player)player, 4)) {
                TBPlayerCapabilityHandler.unlockWatcherKnowledge((Player)player, 3);
                TBPlayerCapabilityHandler.getWatcherKnowledge((Player)player).set(4, false);
            }
            CooldownHandler.INSTANCE.init(player);
            PacketHandler.sendToPlayer(new CMessageLogin(TimeHelper.getSpecialEvent(), GlobalClock.INSTANCE.getTime(player.server), CooldownHandler.INSTANCE.getClientCooldowns(player)), player);
            EntityHelper.syncPlayerCapability(player, true);
            EntityHelper.syncProtectedPlayerCapability(player);
            if (!EntityHelper.checkInvalidPlayerForLoot((ServerPlayer)new FakePlayer(player.serverLevel(), new GameProfile(UUID.randomUUID(), "FakeTest")))) {
                player.connection.disconnect((Component)Component.literal((String)"RealPlayer is not compatible with Corail Tombstone"));
            }
            try {
                Class.forName("xyz.bluspring.kilt.KiltMixinPlugin");
                player.connection.disconnect((Component)Component.literal((String)"Corail Tombstone is a Forge mod"));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                Class.forName("io.github.fabricators_of_create.porting_lib.core.PortingLib");
                player.connection.disconnect((Component)Component.literal((String)"Corail Tombstone is a Forge mod"));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (SupportMods.NO_HOLIDAYS.isLoaded()) {
                player.connection.disconnect((Component)Component.literal((String)"No Holidays is not compatible with Corail Tombstone"));
            }
            CallbackHandler.addFastCallback(() -> {
                ModTriggers.spring_bloom.trigger(player);
                ModTriggers.christmas.trigger(player);
                ModTriggers.halloween.trigger(player);
            });
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        if (EntityHelper.isValidServerPlayer((Entity)event.getEntity())) {
            ServerPlayer serverPlayer = (ServerPlayer)event.getEntity();
            DeathHandler.INSTANCE.storeGroundLocation(serverPlayer);
            CooldownHandler.INSTANCE.storeCooldowns((ServerPlayer)event.getEntity());
            TBPlayerCapabilityHandler.clearServerCache(serverPlayer);
        }
    }

    @SubscribeEvent
    public static void onRegisterCommand(RegisterCommandsEvent event) {
        Helper.initCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onUseCommand(CommandEvent event) {
        if (event.isCanceled() && TombstoneCommand.is((ParseResults<CommandSourceStack>)event.getParseResults())) {
            event.setCanceled(false);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onServerTick(ServerTickEvent.Post event) {
        GlobalClock globalClock = GlobalClock.INSTANCE;
        long serverGlobalTime = globalClock.getTime(event.getServer());
        if (serverGlobalTime % 20L == 0L) {
            PacketHandler.sendToAllPlayers(new CMessageGlobalTime(serverGlobalTime));
        }
        if (LAST_BACKUP < serverGlobalTime) {
            LAST_BACKUP = serverGlobalTime;
        } else if (((Boolean)ConfigTombstone.recovery.recoveryPlayerEnable.get()).booleanValue() && TimeHelper.minuteElapsed(serverGlobalTime, LAST_BACKUP) > (long)((Integer)ConfigTombstone.recovery.recoveryPlayerTimer.get()).intValue()) {
            LAST_BACKUP = serverGlobalTime;
            if (!event.getServer().getPlayerList().getPlayers().isEmpty()) {
                CommandTBRecovery.saveAllPlayers(event.getServer(), success -> {
                    if (((Boolean)ConfigTombstone.recovery.logAutoBackup.get()).booleanValue()) {
                        ModTombstone.LOGGER.debug((success ? LangKey.MESSAGE_RECOVERY_SAVE_ALL_PLAYERS_SUCCESS : LangKey.MESSAGE_RECOVERY_SAVE_ALL_PLAYERS_FAILED).asLog());
                    }
                });
            }
        }
        CommandTBAcceptTeleport.cleanTickets();
        CallbackHandler.tick();
        DeathHandler.INSTANCE.setGroundLocations(event.getServer());
        globalClock.serverTick();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onDetonate(ExplosionEvent.Detonate event) {
        event.getAffectedBlocks().removeIf(blockPos -> {
            BlockState state = event.getLevel().getBlockState(blockPos);
            return ModBlocks.isAnyGrave(state.getBlock()) || state.is(ModTags.Blocks.grave_marbles) || state.is(ModBlocks.abandoned_grave);
        });
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onBreak(BlockEvent.BreakEvent event) {
        if (EntityHelper.isValidServerPlayer((Entity)event.getPlayer()) && event.getPlayer().hasEffect(ModEffects.ghostly_shape)) {
            EffectHelper.clearEffect((LivingEntity)event.getPlayer(), ModEffects.ghostly_shape);
            ModTriggers.cancel_ghostly_shape.trigger((ServerPlayer)event.getPlayer());
        }
        if (event.getPlayer().getMainHandItem().is((Item)ModItems.ankh_of_prayer)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onWorldLoad(LevelEvent.Load event) {
        if (!event.getLevel().isClientSide()) {
            ServerLevel world = (ServerLevel)event.getLevel();
            ImmutableList.Builder builder = new ImmutableList.Builder();
            boolean valid = false;
            for (CustomSpawner spawner : world.customSpawners) {
                if (spawner instanceof PhantomSpawner && !(spawner instanceof CustomPhantomSpawner)) {
                    builder.add((Object)new CustomPhantomSpawner());
                    valid = true;
                    continue;
                }
                if (spawner instanceof VillageSiege && !(spawner instanceof CustomVillageSiege)) {
                    builder.add((Object)new CustomVillageSiege());
                    valid = true;
                    continue;
                }
                builder.add((Object)spawner);
            }
            if (valid) {
                world.customSpawners = builder.build();
            }
        }
        TamableType.init((Level)event.getLevel());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingIncomingDamage(LivingIncomingDamageEvent event) {
        LivingEntity attacker;
        MobEffectInstance boneShieldEffect;
        ServerPlayer player;
        if (EntityHelper.isValidPlayer((Entity)event.getEntity()) && event.getEntity().isDeadOrDying()) {
            event.setCanceled(true);
            return;
        }
        if (event.getEntity().level().isClientSide()) {
            return;
        }
        if (EntityHelper.isValidServerPlayer((Entity)event.getEntity()) && event.getEntity().isAlive() && (player = (ServerPlayer)event.getEntity()).isUsingItem() && player.getUseItem().getItem() instanceof ItemCastableMagic && Helper.RANDOM.nextInt(10) >= EntityHelper.getPerkLevelWithBonus((Player)player, ModPerks.resiliomancer) * 3) {
            EntityHelper.setGlobalItemCooldown((Player)player, player.getUseItem(), 40);
            player.stopUsingItem();
            LangKey.MESSAGE_SPELLCASTING_INTERRUPTED.sendMessage((Player)player, new Object[0]);
        }
        if ((boneShieldEffect = event.getEntity().getEffect(ModEffects.bone_shield)) != null && !event.getSource().is(DamageTypeTags.IS_EXPLOSION) && !event.getSource().is(DamageTypes.THORNS) && event.getSource().getEntity() != null) {
            LivingEntity target = event.getEntity();
            float reflectedDamages = event.getAmount() * Math.min(0.05f * (float)(boneShieldEffect.getAmplifier() + 1), 1.0f);
            event.setAmount(event.getAmount() - reflectedDamages);
            target.level().playSound(null, target.blockPosition(), SoundEvents.THORNS_HIT, SoundSource.NEUTRAL, 0.5f, 0.8f + Helper.RANDOM.nextFloat() * 0.4f);
            Entity entity = event.getSource().getDirectEntity();
            if (entity instanceof LivingEntity) {
                LivingEntity attacker2 = (LivingEntity)entity;
                if (reflectedDamages >= 1.0f) {
                    CallbackHandler.addFastCallback(() -> {
                        if (attacker2 != null && attacker2.isAlive() && target != null && target.isAlive()) {
                            Helper.hurtWithoutCooldown(attacker2, target.damageSources().thorns((Entity)target), reflectedDamages);
                        }
                    });
                }
            }
        }
        if ((EffectHelper.isUnstableIntangibilityActive(event.getEntity()) || event.getEntity().hasEffect(ModEffects.ghostly_shape)) && WorldHelper.isValidPos(event.getEntity().level(), event.getEntity().blockPosition())) {
            event.setCanceled(true);
            return;
        }
        Entity entity = event.getSource().getEntity();
        if (entity instanceof LivingEntity && !(attacker = (LivingEntity)entity).equals((Object)event.getEntity())) {
            if (attacker.hasEffect(ModEffects.diversion)) {
                EffectHelper.clearEffect(attacker, ModEffects.diversion);
            }
            if (event.getEntity().getType().is(EntityTypeTags.UNDEAD) && attacker.hasEffect(ModEffects.beyond_the_grave_bond)) {
                EffectHelper.clearEffect(attacker, ModEffects.beyond_the_grave_bond);
            }
            if (attacker.hasEffect(ModEffects.ghostly_shape)) {
                EffectHelper.clearEffect(attacker, ModEffects.ghostly_shape);
                if (EntityHelper.isValidServerPlayer((Entity)attacker)) {
                    ModTriggers.cancel_ghostly_shape.trigger((ServerPlayer)attacker);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingDamagePre(LivingDamageEvent.Pre event) {
        ServerPlayer serverPlayer;
        if (EntityHelper.isValidServerPlayer(event.getSource().getEntity())) {
            int gladiatorLevel;
            boolean isDarknessDamage;
            serverPlayer = (ServerPlayer)event.getSource().getEntity();
            boolean isLightDamage = event.getSource().is(ModDamages.HOLY);
            boolean bl = isDarknessDamage = !isLightDamage && (event.getSource().is(DamageTypes.WITHER) || event.getSource().is(DamageTypes.WITHER_SKULL) || event.getSource().is(DamageTypes.DRAGON_BREATH) || event.getSource().is(ModDamages.UNHOLY));
            if (isLightDamage || isDarknessDamage) {
                int alignmentLevel = TBPlayerCapabilityHandler.getAlignmentLevel((Player)serverPlayer);
                if (isLightDamage ? alignmentLevel > 0 : alignmentLevel < 0) {
                    event.setNewDamage(event.getNewDamage() * 0.5f);
                }
            }
            if ((gladiatorLevel = EntityHelper.getPerkLevelWithBonus((Player)serverPlayer, ModPerks.gladiator)) > 0) {
                event.setNewDamage(event.getNewDamage() * (1.0f + (float)gladiatorLevel * 0.05f));
            }
        }
        if (event.getSource().is(DamageTypeTags.IS_LIGHTNING) && event.getEntity().hasEffect(ModEffects.lightning_resistance)) {
            event.setNewDamage(event.getNewDamage() / 4.0f);
        }
        if (event.getSource().is(DamageTypeTags.IS_FREEZING) && event.getEntity().hasEffect(ModEffects.frost_resistance)) {
            event.setNewDamage(event.getNewDamage() / 4.0f);
        }
        if (EntityHelper.isValidServerPlayer((Entity)event.getEntity())) {
            LivingEntity livingEntity;
            Entity entity;
            int alignmentLevel;
            serverPlayer = (ServerPlayer)event.getEntity();
            int gladiatorLevel = EntityHelper.getPerkLevelWithBonus((Player)serverPlayer, ModPerks.guardian);
            if (gladiatorLevel > 0) {
                event.setNewDamage(event.getNewDamage() * (1.0f - (float)gladiatorLevel * 0.05f));
            }
            if ((alignmentLevel = TBPlayerCapabilityHandler.getAlignmentLevel((Player)serverPlayer)) != 0 && (entity = event.getSource().getEntity()) instanceof LivingEntity && (EntityHelper.isUndead(livingEntity = (LivingEntity)entity) ? alignmentLevel > 0 : alignmentLevel < 0)) {
                event.setNewDamage(event.getNewDamage() * (1.0f - 0.1f * (float)Math.abs(alignmentLevel)));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPreventDeathPre(LivingDamageEvent.Pre event) {
        if (!event.getEntity().isAlive() || event.getEntity().level().isClientSide()) {
            return;
        }
        if (event.getEntity().hasEffect(ModEffects.ghostly_shape) && WorldHelper.isValidPos(event.getEntity().level(), event.getEntity().blockPosition())) {
            event.setNewDamage(0.0f);
            return;
        }
        if (EntityHelper.isValidServerPlayer((Entity)event.getEntity()) && Optional.ofNullable(event.getSource()).map(DamageSource::getDirectEntity).map(e -> e.getType() == EntityType.SNOWBALL && e.getPersistentData().contains("slowing_bone")).orElse(false).booleanValue()) {
            EffectHelper.addEffect(event.getEntity(), (Holder<MobEffect>)MobEffects.MOVEMENT_SLOWDOWN, 200);
        }
        if (event.getEntity().getHealth() <= event.getNewDamage()) {
            Location location = Location.ORIGIN;
            if (ProtectedEntityHandler.hasCapability((Entity)event.getEntity()) && ProtectedEntityHandler.isActive((Entity)event.getEntity())) {
                ProtectedEntityHandler.apply(event.getEntity(), false);
                location = new Location(ProtectedEntityHandler.getSafeLocation(event.getEntity()));
            }
            if (!location.isOrigin()) {
                Location spawn;
                ServerLevel level;
                event.getEntity().setHealth(event.getEntity().getMaxHealth());
                event.getEntity().resetFallDistance();
                EffectHelper.clearBadEffects(event.getEntity());
                EffectHelper.addEffect(event.getEntity(), (Holder<MobEffect>)MobEffects.REGENERATION, 600);
                EffectHelper.addEffect(event.getEntity(), ModEffects.diversion, 600);
                MinecraftServer server = event.getEntity().getServer();
                ServerLevel serverLevel = level = server != null ? server.getLevel(location.dim) : null;
                if (level != null && !(spawn = new SpawnHelper(level, location.getPos()).findSpawnPlace()).isOrigin()) {
                    Helper.teleport(event.getEntity(), spawn, level);
                }
                EntityHelper.applyKillResult(event.getSource(), event.getEntity());
                event.setNewDamage(0.0f);
                return;
            }
            if (EntityHelper.isValidServerPlayer((Entity)event.getEntity())) {
                try {
                    if (EventHandler.handlePlayerDamage((ServerPlayer)event.getEntity(), event.getSource())) {
                        event.setNewDamage(0.0f);
                    }
                }
                catch (Throwable throwable) {}
            } else if (ModItems.receptacle_of_familiar.captureSoul(event.getEntity())) {
                event.setNewDamage(0.0f);
                event.getEntity().discard();
            }
        }
    }

    public static boolean handlePlayerDamage(ServerPlayer player, DamageSource source) throws CommandSyntaxException {
        boolean requirePrevention;
        ServerLevel targetWorld = player.serverLevel();
        BlockPos playerPos = player.blockPosition();
        boolean bl = requirePrevention = (Boolean)ConfigTombstone.player_death.preventDeathOutsideWorldBorder.get() != false && WorldHelper.isOutsideWorldBorders((Level)targetWorld, playerPos) || (Boolean)ConfigTombstone.player_death.preventDeathOutsideBuildHeight.get() != false && WorldHelper.isOutsideBuildHeight((Level)targetWorld, playerPos);
        if (requirePrevention) {
            LangKey.MESSAGE_CONFIG_PREVENT_DEATH.sendMessage((Player)player, new Object[0]);
        } else if (ModItems.voodoo_poppet.preventDeath(player)) {
            requirePrevention = true;
        } else {
            ItemStack receptacle_of_soul = InventoryHelper.findFirstInInventory((Player)player, p -> p.is((Item)ModItems.receptacle_of_soul));
            if (!receptacle_of_soul.isEmpty()) {
                requirePrevention = true;
                receptacle_of_soul.shrink(1);
                LangKey.MESSAGE_SOUL_PREVENT_DEATH.sendMessage((Player)player, new Object[0]);
            }
        }
        if (requirePrevention) {
            EffectHelper.clearBadEffects((LivingEntity)player);
            player.setHealth(player.getMaxHealth());
            EffectHelper.addEffect((LivingEntity)player, ModEffects.ghostly_shape, 10);
            player.resetFallDistance();
            PlayerPreference playerPreference = PlayerPreference.get(player);
            Location spawnPos = new SpawnHelper(targetWorld, WorldHelper.getCloserValidPos((Level)targetWorld, playerPos)).withPlayerPreference(playerPreference).findSpawnPlace();
            if (spawnPos.isOrigin()) {
                Location lastGroundLocation = DeathHandler.INSTANCE.getGroundLocation(player);
                if (!lastGroundLocation.isOrigin() && (targetWorld = targetWorld.getServer().getLevel(lastGroundLocation.dim)) != null) {
                    spawnPos = new SpawnHelper(targetWorld, lastGroundLocation.getPos()).withPlayerPreference(playerPreference).findGravePlace();
                }
                if (spawnPos.isOrigin()) {
                    assert (player.getServer() != null);
                    Pair<ServerLevel, BlockPos> respawnPoint = CommandTBTeleport.getRespawnPoint(player.getServer(), player);
                    targetWorld = (ServerLevel)respawnPoint.getLeft();
                    spawnPos = new SpawnHelper(targetWorld, (BlockPos)respawnPoint.getRight()).withPlayerPreference(playerPreference).findSpawnPlace();
                }
            }
            if (!spawnPos.isOrigin()) {
                Helper.teleport(player, spawnPos, targetWorld);
            }
            return true;
        }
        if (((Boolean)ConfigTombstone.recovery.backupOnDeath.get()).booleanValue() && !player.isSpectator()) {
            CommandTBRecovery.savePlayer(player, success -> ModTombstone.LOGGER.info((success ? LangKey.MESSAGE_RECOVERY_SAVE_PLAYER_SUCCESS : LangKey.MESSAGE_RECOVERY_SAVE_PLAYER_FAILED).getText(player.getName()).getString()));
        }
        return false;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onCheckHidden(LivingEvent.LivingVisibilityEvent event) {
        LivingEntity livingEntity;
        Entity entity;
        double modifierLowPriority = 1.0;
        if (event.getEntity().hasEffect(ModEffects.diversion) || event.getEntity().hasEffect(ModEffects.ghostly_shape)) {
            modifierLowPriority = 0.0;
        } else if (event.getEntity().hasEffect(ModEffects.beyond_the_grave_bond) && (entity = event.getLookingEntity()) instanceof LivingEntity && (livingEntity = (LivingEntity)entity).getType().is(EntityTypeTags.UNDEAD)) {
            modifierLowPriority = 0.0;
        } else {
            MobEffectInstance bait = event.getEntity().getEffect(ModEffects.bait);
            if (bait != null) {
                modifierLowPriority *= Math.min((double)bait.getAmplifier() + 1.0, 2.0);
            }
        }
        event.modifyVisibility(modifierLowPriority);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onCheckDiscretion(LivingEvent.LivingVisibilityEvent event) {
        int lvl;
        double modifierDiscretion = Optional.ofNullable(event.getEntity().getEffect(ModEffects.discretion)).map(effect -> Mth.clamp((double)((double)(effect.getAmplifier() + 1) * 0.1), (double)0.01, (double)1.0)).orElse(0.0);
        double modifierHighPriority = 1.0 - modifierDiscretion;
        if (EntityHelper.isValidPlayer((Entity)event.getEntity()) && (lvl = EntityHelper.getPerkLevelWithBonus((Player)event.getEntity(), ModPerks.shadowalker)) > 0) {
            modifierHighPriority *= 1.0 - (double)lvl * 0.1;
        }
        event.modifyVisibility(modifierHighPriority);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (EntityHelper.isValidServerPlayer((Entity)event.getEntity()) && !event.getEntity().isSpectator()) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            EntityHelper.syncPlayerCapability(player);
            EntityHelper.syncProtectedPlayerCapability(player);
            DeathHandler.INSTANCE.handleRespawn(player);
            NBTStackHelper.getEffectList(EntityHelper.getPersistentTag((Player)player), END_CONQUERED_EFFECTS_NBT_LIST, e -> true).forEach(arg_0 -> ((ServerPlayer)player).addEffect(arg_0));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onClone(PlayerEvent.Clone event) {
        Collection originalEffects;
        if (!EntityHelper.isValidServerPlayer((Entity)event.getOriginal()) || !EntityHelper.isValidServerPlayer((Entity)event.getEntity())) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.getEntity();
        ServerPlayer original = (ServerPlayer)event.getOriginal();
        TBPlayerCapabilityHandler.onClone(original, player);
        ProtectedEntityHandler.setActive((Entity)player, ProtectedEntityHandler.isActive((Entity)original));
        if (Helper.isModLoad("gravestone")) {
            original.getInventory().items.stream().filter(stack -> "gravestone:obituary".equals(RegistryHelper.getRegistryString(stack.getItem()))).forEach(stack -> stack.shrink(stack.getCount()));
        }
        if (((Boolean)ConfigTombstone.compatibility.preserveEffectsOnReturnEndConquered.get()).booleanValue() && !event.isWasDeath() && original.level().dimension() == Level.END && player.getActiveEffects().isEmpty() && !(originalEffects = original.getActiveEffects()).isEmpty()) {
            NBTStackHelper.setEffectlist(EntityHelper.getPersistentTag(event.getEntity()), END_CONQUERED_EFFECTS_NBT_LIST, originalEffects.stream());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void onPlayerDeath(LivingDeathEvent event) {
        if (!EntityHelper.isValidServerPlayer((Entity)event.getEntity())) {
            if (!event.isCanceled() && event.getEntity() != null) {
                EntityHelper.applyKillResult(event.getSource(), event.getEntity());
            }
            return;
        }
        ServerPlayer player = (ServerPlayer)event.getEntity();
        if (event.isCanceled()) {
            ModTombstone.LOGGER.warn("The death event of the player " + player.getName().getString() + " was canceled by another mod");
        } else {
            DeathHandler.INSTANCE.onPlayerDead(player, event.getSource());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingExperienceDrop(LivingExperienceDropEvent event) {
        if (EntityHelper.isValidPlayer((Entity)event.getEntity())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onHandleSoulbound(LivingDropsEvent event) {
        if (EntityHelper.isValidServerPlayer((Entity)event.getEntity()) && !Helper.isRuleKeepInventory((Entity)event.getEntity())) {
            DeathHandler.INSTANCE.handleSoulbound((ServerPlayer)event.getEntity(), event.getDrops());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW, receiveCanceled=true)
    public static void onDrops(LivingDropsEvent event) {
        if (!EntityHelper.isValidServerPlayer((Entity)event.getEntity()) || Helper.isRuleKeepInventory((Entity)event.getEntity())) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.getEntity();
        if (event.isCanceled()) {
            ModTombstone.LOGGER.warn("The drop event of the player " + player.getGameProfile().getName() + " was canceled by another mod");
            return;
        }
        DeathHandler.INSTANCE.handleLoot(player, event.getDrops(), event.getSource());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onAnvilUpdate(AnvilUpdateEvent event) {
        boolean valid;
        if (event.getLeft().isEmpty() || event.getRight().isEmpty()) {
            return;
        }
        boolean bl = valid = event.getLeft().is((Item)ModItems.grave_plate) && event.getRight().is(Tags.Items.INGOTS_IRON) || ModItems.tablet_of_assistance.isEnchanted(event.getLeft()) && !ModItems.tablet_of_assistance.isAncient(event.getLeft()) && event.getRight().is((Item)ModItems.grave_dust);
        if (valid) {
            String newName = Optional.ofNullable(event.getName()).map(String::trim).orElse("");
            event.setOutput(EngravableHelper.setEngravedName(event.getLeft().copy(), newName));
            event.setCost(1L);
            event.setMaterialCost(1);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onAnvilRepair(AnvilRepairEvent event) {
        if (EntityHelper.isValidServerPlayer((Entity)event.getEntity()) && event.getLeft().is((Item)ModItems.grave_plate) && event.getRight().is(Tags.Items.INGOTS_IRON) && EngravableHelper.isEngraved(event.getOutput())) {
            ModTriggers.engrave_grave_plate.trigger((ServerPlayer)event.getEntity());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        ItemInteractionResult result;
        boolean requireNerfGhostlyShape;
        if (!event.isCanceled() && EntityHelper.isValidServerPlayer((Entity)event.getEntity()) && event.getHand() == InteractionHand.MAIN_HAND && (requireNerfGhostlyShape = event.getEntity().hasEffect(ModEffects.ghostly_shape)) && Optional.ofNullable((IItemHandler)event.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, event.getPos(), null)).isPresent()) {
            EffectHelper.clearEffect((LivingEntity)event.getEntity(), ModEffects.ghostly_shape);
            ModTriggers.cancel_ghostly_shape.trigger((ServerPlayer)event.getEntity());
        }
        BlockState blockState = event.getLevel().getBlockState(event.getPos());
        Block block = blockState.getBlock();
        if (!event.isCanceled() && EntityHelper.isValidPlayer(event.getEntity()) && ModBlocks.isDecorativeGrave(block) && event.getEntity().getOffhandItem().is(ModTags.Items.magic_books) && (result = blockState.useItemOn(event.getEntity().getOffhandItem(), event.getLevel(), event.getEntity(), event.getHand(), event.getHitVec())).consumesAction()) {
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
            if (!event.getLevel().isClientSide()) {
                CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger((ServerPlayer)event.getEntity(), event.getPos(), event.getEntity().getOffhandItem());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingUpdate(EntityTickEvent.Pre event) {
        LivingEntity livingEntity;
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).level().isClientSide() && TimeHelper.atInterval(livingEntity.level(), 20)) {
            if (((Boolean)ConfigTombstone.client.showShieldParticle.get()).booleanValue() && ProtectedEntityHandler.hasCapability((Entity)livingEntity) && ProtectedEntityHandler.isActive((Entity)livingEntity)) {
                ProxyHelper.produceShield(livingEntity);
            }
            if (livingEntity.hasEffect(ModEffects.bone_shield)) {
                ProxyHelper.produceBoneShield(livingEntity);
            }
        }
    }

    @SubscribeEvent
    public static void onTrackingStart(PlayerEvent.StartTracking event) {
        LivingEntity target;
        Entity entity;
        if (EntityHelper.isValidServerPlayer((Entity)event.getEntity()) && (entity = event.getTarget()) instanceof LivingEntity && (target = (LivingEntity)entity).isAlive()) {
            CompoundTag tag;
            TamableType tamableType;
            ServerPlayer player = (ServerPlayer)event.getEntity();
            if (ProtectedEntityHandler.hasCapability((Entity)target)) {
                PacketHandler.sendToPlayer(new CMessageProtection(target.getId(), ProtectedEntityHandler.isActive((Entity)target)), player);
            }
            if (EnhancedFamiliarHandler.hasCapability((Entity)target) && EnhancedFamiliarHandler.isEnhanced((Entity)target)) {
                PacketHandler.sendToPlayer(new CMessageEnhancedFamiliar(target.getId()), player);
            }
            if (FriendlyAnimalHandler.hasCapability((Entity)target)) {
                FriendlyAnimalHandler.getOwnerId(event.getTarget()).ifPresent(uuid -> PacketHandler.sendToPlayer(new CMessageServant(target.getId(), (UUID)uuid, false), player));
            }
            if ((tamableType = TamableType.getType(target)) == TamableType.UNDEAD) {
                EntityHelper.getServantOwnerId((Entity)target).ifPresent(uuid -> PacketHandler.sendToPlayer(new CMessageServant(target.getId(), (UUID)uuid, true), player));
            }
            if (SpellCasterHandler.hasCapability(target) && SpellCasterHandler.isCasting(target)) {
                PacketHandler.sendToPlayer(new CMessageSpellCasting(target.getId(), SpellCasterHandler.getCastingColor(target)), player);
            }
            for (MobEffectInstance effectInstance : target.getActiveEffectsMap().values()) {
                TombstoneEffect tombstoneEffect;
                Object object = effectInstance.getEffect().value();
                if (!(object instanceof TombstoneEffect) || !(tombstoneEffect = (TombstoneEffect)((Object)object)).isRequiringSync()) continue;
                PacketHandler.sendToPlayer(new CMessageEffectStarted(target.getId(), effectInstance), player);
            }
            MobEffectInstance effectPrayer = target.getEffect(ModEffects.prayer);
            if (effectPrayer != null && (tag = target.getPersistentData()).hasUUID("prayer") && tag.contains("pray_type", 2)) {
                PacketHandler.sendToPlayer(new CMessagePrayer(target.getId(), tag.getUUID("prayer"), tag.getShort("pray_type"), effectPrayer.getDuration()), player);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onEffectApplied(MobEffectEvent.Applicable event) {
        if (event.getEffectInstance() != null) {
            Holder effect = event.getEffectInstance().getEffect();
            if (effect == ModEffects.ghostly_shape || effect == ModEffects.preservation || effect == ModEffects.true_sight || effect == ModEffects.beyond_the_grave_bond) {
                if (!EntityHelper.isValidPlayer((Entity)event.getEntity())) {
                    event.setResult(MobEffectEvent.Applicable.Result.DO_NOT_APPLY);
                }
            } else if (effect == ModEffects.frostbite) {
                if (!event.getEntity().canFreeze()) {
                    event.setResult(MobEffectEvent.Applicable.Result.DO_NOT_APPLY);
                }
            } else if (effect == ModEffects.decrepitude && event.getEntity().getType().is(EntityTypeTags.UNDEAD)) {
                event.setResult(MobEffectEvent.Applicable.Result.DO_NOT_APPLY);
            }
            if (event.getEntity().hasEffect(ModEffects.purification) && EffectHelper.isBadEffect((MobEffect)effect.value())) {
                event.setResult(MobEffectEvent.Applicable.Result.DO_NOT_APPLY);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        Holder holder;
        if (!event.getEntity().level().isClientSide && !EntityHelper.isValidServerPlayer((Entity)event.getEntity()) && event.getEffectInstance() != null && (holder = event.getEffectInstance().getEffect()) instanceof TombstoneEffect) {
            TombstoneEffect tombstoneEffect = (TombstoneEffect)holder;
            tombstoneEffect.onEffectFinished(event.getEntity(), event.getEffectInstance());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onEffectExpired(MobEffectEvent.Expired event) {
        Holder holder;
        if (!event.getEntity().level().isClientSide && !EntityHelper.isValidServerPlayer((Entity)event.getEntity()) && event.getEffectInstance() != null && (holder = event.getEffectInstance().getEffect()) instanceof TombstoneEffect) {
            TombstoneEffect tombstoneEffect = (TombstoneEffect)holder;
            tombstoneEffect.onEffectFinished(event.getEntity(), event.getEffectInstance());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onSyncOnChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (EntityHelper.isValidServerPlayer((Entity)event.getEntity())) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            EntityHelper.syncPlayerCapability(player);
            EntityHelper.syncProtectedPlayerCapability(player);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerInteractEntity(PlayerInteractEvent.EntityInteract event) {
        ItemStack heldStack = event.getEntity().getItemInHand(event.getHand());
        if (heldStack.is((Item)ModItems.gift) || heldStack.is((Item)ModItems.smoke_ball) || heldStack.is((Item)ModItems.dust_of_vanishing) || heldStack.is((Item)ModItems.dust_of_frost)) {
            event.setCancellationResult(heldStack.use(event.getLevel(), event.getEntity(), event.getHand()).getResult());
            event.setCanceled(true);
            return;
        }
        if (event.getTarget() instanceof LivingEntity && (heldStack.getItem() instanceof ItemCastableMagic || event.getHand() == InteractionHand.MAIN_HAND && heldStack.is((Item)ModItems.bone_needle))) {
            event.setCancellationResult(heldStack.interactLivingEntity(event.getEntity(), (LivingEntity)event.getTarget(), event.getHand()));
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        ItemStack heldStack = event.getEntity().getMainHandItem();
        if (heldStack.is((Item)ModItems.ankh_of_prayer)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPhantomTime(PhantomSpawnerEvent.TimeForCheck event) {
        if (((Boolean)ConfigTombstone.general.knowledgeReducePhantomSpawn.get()).booleanValue()) {
            event.modifyTimeForCheck((int)((float)event.getTimeForCheck() * (1.0f + (float)TBPlayerCapabilityHandler.getTotalPerkPoints(event.getPlayer()) * 0.1f)));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onProjectileImpact(ProjectileImpactEvent event) {
        Cloud cloud;
        ItemStack stack;
        if (event.getProjectile() != null && EntityType.SNOWBALL == event.getProjectile().getType() && event.getProjectile() instanceof Snowball && (stack = ((Snowball)event.getProjectile()).getItem()).is((Item)ModItems.smoke_ball) && (cloud = (Cloud)ModEntities.cloud.create(event.getProjectile().level())) != null) {
            event.getProjectile().discard();
            event.setCanceled(true);
            cloud.setColor(ModItems.smoke_ball.getColor(stack, 0));
            cloud.setPos(event.getProjectile().position());
            event.getProjectile().level().addFreshEntity((Entity)cloud);
            stack.shrink(1);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onEntitySpawn(EntityJoinLevelEvent event) {
        Entity entity;
        if (!event.getLevel().isClientSide() && (entity = event.getEntity()) instanceof PathfinderMob) {
            PathfinderMob pathfinderMob = (PathfinderMob)entity;
            if (FriendlyAnimalHandler.hasCapability((Entity)pathfinderMob)) {
                if (FriendlyAnimalHandler.hasOwner((Entity)pathfinderMob)) {
                    FriendlyAnimalHandler.setAI(pathfinderMob);
                }
            } else if (ServantUndeadHandler.hasCapability((Entity)pathfinderMob)) {
                if (ServantUndeadHandler.hasOwner((Entity)pathfinderMob)) {
                    ServantUndeadHandler.setAI(pathfinderMob);
                }
            } else if (pathfinderMob instanceof AbstractGolem) {
                AbstractGolem abstractGolem = (AbstractGolem)pathfinderMob;
                abstractGolem.targetSelector.getAvailableGoals().stream().map(WrappedGoal::getGoal).filter(NearestAttackableTargetGoal.class::isInstance).map(NearestAttackableTargetGoal.class::cast).filter(g -> Mob.class.equals((Object)g.targetType)).forEach(g -> {
                    Predicate<LivingEntity> predic = e -> !EntityHelper.isServant((Entity)e);
                    g.targetConditions.selector = g.targetConditions.selector == null ? predic : g.targetConditions.selector.and(predic);
                });
            }
            if (EnhancedFamiliarHandler.hasCapability((Entity)pathfinderMob) && EnhancedFamiliarHandler.isEnhanced((Entity)pathfinderMob)) {
                EnhancedFamiliarHandler.applyAttributes((LivingEntity)pathfinderMob);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onEntityHeal(LivingHealEvent event) {
        MobEffectInstance effectInstance = event.getEntity().getEffect(ModEffects.incurable);
        if (effectInstance != null) {
            if (effectInstance.getAmplifier() >= 9) {
                event.setCanceled(true);
            } else {
                event.setAmount(event.getAmount() * (1.0f - Math.min(0.1f * (float)(effectInstance.getAmplifier() + 1), 1.0f)));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onStartingLivingConversion(LivingConversionEvent.Pre event) {
        if (EntityHelper.isServant((Entity)event.getEntity())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onCriticalHit(CriticalHitEvent event) {
        int amplifier;
        ItemStack mainHandStack = event.getEntity().getMainHandItem();
        if (!mainHandStack.isEmpty() && (amplifier = Helper.getEnchantmentLevelForItem(ModEnchantments.ruthless_strike, mainHandStack, event.getEntity().level())) > 0) {
            event.setDamageMultiplier(event.getDamageMultiplier() * (1.0f + (float)amplifier * 0.15f));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onServerLevelTick(LevelTickEvent.Post event) {
        if (!TimeHelper.isDateAroundSpringBloom() || event.getLevel() == null || event.getLevel().isClientSide()) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)event.getLevel();
        ServerLevel overworld = serverLevel.getServer().overworld();
        if (overworld.isDay() || (double)overworld.getTimeOfDay(0.0f) != 0.5) {
            return;
        }
        EventHandler.generateThornVeil(serverLevel, false);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlayerWakeUp(PlayerWakeUpEvent event) {
        if (TimeHelper.isDateAroundSpringBloom() && EntityHelper.isValidServerPlayer((Entity)event.getEntity())) {
            ServerPlayer serverPlayer = (ServerPlayer)event.getEntity();
            MinecraftServer server = serverPlayer.getServer();
            assert (server != null);
            if (serverPlayer.equals(server.getPlayerList().getPlayers().getFirst())) {
                server.getAllLevels().forEach(serverLevel -> EventHandler.generateThornVeil(serverLevel, true));
            }
        }
    }

    private static void generateThornVeil(ServerLevel serverLevel, boolean wasSleeping) {
        new CopyOnWriteArrayList(serverLevel.blockEntityTickers).stream().filter(tileTicker -> {
            try {
                BlockEntity blockEntity = ((LevelChunk.BoundTickingBlockEntity)((LevelChunk.RebindableTickingBlockEntityWrapper)tileTicker).ticker).blockEntity;
                return ModBlocks.isDecorativeGrave(blockEntity.getBlockState().getBlock());
            }
            catch (Throwable throwable) {
                return false;
            }
        }).map(TickingBlockEntity::getPos).forEach(pos -> {
            if (!serverLevel.isLoaded(pos)) {
                return;
            }
            int rolls = Helper.RANDOM.nextInt(3);
            for (int i = 0; i < rolls; ++i) {
                if (Helper.RANDOM.nextBoolean()) continue;
                BlockPos expectedPos = pos.offset(Helper.RANDOM.nextInt(5) - 2, 0, Helper.RANDOM.nextInt(5) - 2);
                BlockState flower = ModBlocks.thornveil.defaultBlockState();
                BlockPos spawnPos = null;
                for (int y = 1; y > -2; --y) {
                    BlockState currentState;
                    BlockPos currentPos = expectedPos.offset(0, y, 0);
                    if (!serverLevel.isLoaded(currentPos) || !(currentState = serverLevel.getBlockState(currentPos)).isAir() && !currentState.canBeReplaced() || !flower.canSurvive((LevelReader)serverLevel, currentPos)) continue;
                    spawnPos = currentPos;
                    break;
                }
                if (spawnPos == null) continue;
                serverLevel.setBlockAndUpdate(spawnPos, flower);
                if (wasSleeping) continue;
                for (ServerPlayer serverPlayer : serverLevel.players()) {
                    if (!(serverPlayer.distanceToSqr(spawnPos.getCenter()) < 5.0)) continue;
                    ModTriggers.thornveil_spawn.trigger(serverPlayer);
                }
            }
        });
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onBlockPlaced(BlockEvent.EntityPlaceEvent event) {
        if (EntityHelper.isValidServerPlayer(event.getEntity())) {
            Item item;
            ItemStack mainHandStack;
            ServerPlayer serverPlayer = (ServerPlayer)event.getEntity();
            if (TimeHelper.isDateAroundSpringBloom() && (mainHandStack = serverPlayer.getMainHandItem()).is(ModTags.Items.seeds) && (item = mainHandStack.getItem()) instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                if (event.getPlacedBlock().is(blockItem.getBlock())) {
                    ModTriggers.spring_bloom_planted_seed.trigger(serverPlayer);
                }
            }
            if (event.getPlacedBlock().is(ModTags.Blocks.living_corals)) {
                int count = EntityHelper.getCustomStat(serverPlayer, ModStats.CORAL_CHANT);
                if (count < 2) {
                    return;
                }
                int radius = 3;
                PlacedBlocksTracker tracker = PlacedBlocksTracker.get(serverPlayer.serverLevel());
                boolean valid = BlockPos.betweenClosedStream((BlockPos)serverPlayer.blockPosition().offset(-radius, -1, -radius), (BlockPos)serverPlayer.blockPosition().offset(radius, 1, radius)).anyMatch(pos -> {
                    if (pos.equals((Object)serverPlayer.blockPosition())) {
                        return false;
                    }
                    BlockState state = serverPlayer.serverLevel().getBlockState(pos);
                    return state.is(ModTags.Blocks.living_corals) && !tracker.contains((BlockPos)pos);
                });
                if (valid) {
                    int plantedCorals;
                    tracker.isValidCoral = true;
                    int healedCorals = EntityHelper.getCustomStat(serverPlayer, ModStats.HEALED_CORAL);
                    if (healedCorals > (plantedCorals = EntityHelper.getCustomStat(serverPlayer, ModStats.PLANTED_CORAL))) {
                        EntityHelper.setCustomStat(serverPlayer, ModStats.PLANTED_CORAL, ++plantedCorals);
                        TBPlayerCapabilityHandler.rewardKnowledge(serverPlayer, 1);
                        if (plantedCorals == 1) {
                            LootHelper.rewardReadableScroll(serverPlayer, LootHelper.ReadableScrollType.CORAL_CHANT, 3);
                        } else if (plantedCorals == 30) {
                            LootHelper.rewardReadableScroll(serverPlayer, LootHelper.ReadableScrollType.CORAL_CHANT, 4);
                        }
                    }
                }
            }
        }
    }
}

