/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.entity.ai.spell;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.projectile.WitherSkull;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.entity.ai.spell.AbstractOffensiveSpellGoal;

public class WitherSkullSpellGoal
extends AbstractOffensiveSpellGoal {
    public WitherSkullSpellGoal(PathfinderMob caster) {
        super(caster);
    }

    @Override
    protected void performSpellCasting() {
        @Nullable LivingEntity target = this.caster.getTarget();
        if (target != null && target.isAlive()) {
            Vec3 vec3 = this.caster.getViewVector(1.0f);
            double d1 = target.getX() - (this.caster.getX() + vec3.x * 2.0);
            double d2 = target.getY(0.5) - (0.5 + this.caster.getY(0.5));
            double d3 = target.getZ() - (this.caster.getZ() + vec3.z * 2.0);
            Vec3 vec = new Vec3(d1, d2, d3);
            WitherSkull witherSkull = new WitherSkull(this.caster.level(), (LivingEntity)this.caster, vec);
            witherSkull.setOwner((Entity)this.caster);
            witherSkull.setPos(this.caster.getX() + vec3.x * 2.0, this.caster.getY(0.5) + 0.5, this.caster.getZ() + vec3.z * 2.0);
            this.caster.level().addFreshEntity((Entity)witherSkull);
        }
    }

    @Override
    protected int getCastWarmupTime() {
        return 40;
    }

    @Override
    protected int getCastingTime() {
        return 60;
    }

    @Override
    protected int getCastingInterval() {
        return 400;
    }

    @Override
    @Nullable
    protected SoundEvent getSpellPrepareSound() {
        return SoundEvents.WITHER_AMBIENT;
    }

    @Override
    protected int getSpellColor() {
        return 0x706666;
    }
}

