/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.advancement;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import ovh.corail.tombstone.advancement.StatelessTrigger;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModTriggers;

public final class ChristmasTrigger
extends StatelessTrigger {
    private static final String HAS_CHRISTMAS_GIFT_NBT_BOOL = "has_christmas_gift";

    @Override
    public void trigger(ServerPlayer player) {
        CompoundTag persistentTag = EntityHelper.getPersistentTag((Player)player);
        if (TimeHelper.isDateAroundChristmas()) {
            super.trigger(player);
            if (player.getStats().getValue(Stats.CUSTOM.get((Object)Stats.PLAY_TIME)) > TimeHelper.tickFromHour(1) && !persistentTag.getBoolean(HAS_CHRISTMAS_GIFT_NBT_BOOL)) {
                persistentTag.putBoolean(HAS_CHRISTMAS_GIFT_NBT_BOOL, true);
                ModTriggers.christmas_gift.trigger(player);
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)ModItems.christmas_gift));
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)ModItems.villager_gift));
            }
        } else {
            persistentTag.remove(HAS_CHRISTMAS_GIFT_NBT_BOOL);
        }
    }
}

