/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.irons_apothic.affix;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.muon.irons_apothic.affix.AffixSchoolMapper;
import dev.shadowsoffire.apotheosis.affix.Affix;
import dev.shadowsoffire.apotheosis.affix.AffixDefinition;
import dev.shadowsoffire.apotheosis.affix.AffixInstance;
import dev.shadowsoffire.apotheosis.loot.LootCategory;
import dev.shadowsoffire.apotheosis.loot.LootRarity;
import dev.shadowsoffire.placebo.util.StepFunction;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import java.util.Map;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.AttributeTooltipContext;

public class SpellLevelAffix
extends Affix {
    public static final Codec<SpellLevelAffix> CODEC = RecordCodecBuilder.create(inst -> inst.group(Affix.affixDef(), (App)ResourceLocation.CODEC.fieldOf("school").forGetter(a -> a.school.getId()), (App)LootRarity.mapCodec(LevelData.CODEC).fieldOf("values").forGetter(a -> a.values), (App)LootCategory.SET_CODEC.fieldOf("types").forGetter(a -> a.validTypes)).apply((Applicative)inst, SpellLevelAffix::new));
    protected final SchoolType school;
    protected final Map<LootRarity, LevelData> values;
    protected final Set<LootCategory> validTypes;

    public SpellLevelAffix(AffixDefinition definition, ResourceLocation schoolId, Map<LootRarity, LevelData> values, Set<LootCategory> types) {
        super(definition);
        this.school = SchoolRegistry.getSchool((ResourceLocation)schoolId);
        if (this.school == null) {
            throw new IllegalArgumentException("Invalid school ID provided for SpellLevelAffix: " + String.valueOf(schoolId));
        }
        this.values = values;
        this.validTypes = types;
    }

    public Codec<? extends Affix> getCodec() {
        return CODEC;
    }

    public MutableComponent getDescription(AffixInstance inst, AttributeTooltipContext ctx) {
        LevelData data = this.values.get(inst.rarity().get());
        if (data == null) {
            return Component.empty();
        }
        int bonus = data.level().getInt(inst.level());
        String schoolTranslationKey = "school." + this.school.getId().getNamespace() + "." + this.school.getId().getPath();
        return Component.translatable((String)"affix.irons_apothic.spell_level.desc", (Object[])new Object[]{Component.translatable((String)schoolTranslationKey).withStyle(this.school.getDisplayName().getStyle()), bonus});
    }

    public Component getAugmentingText(AffixInstance inst, AttributeTooltipContext ctx) {
        LevelData data = this.values.get(inst.rarity().get());
        if (data == null) {
            return Component.empty();
        }
        int currentBonus = data.level().getInt(inst.level());
        int minBonus = data.level().getInt(0.0f);
        int maxBonus = data.level().getInt(1.0f);
        String schoolTranslationKey = "school." + this.school.getId().getNamespace() + "." + this.school.getId().getPath();
        MutableComponent comp = Component.translatable((String)"affix.irons_apothic.spell_level.desc", (Object[])new Object[]{Component.translatable((String)schoolTranslationKey).withStyle(this.school.getDisplayName().getStyle()), currentBonus});
        if (minBonus != maxBonus) {
            MutableComponent minComp = Component.literal((String)String.valueOf(minBonus));
            MutableComponent maxComp = Component.literal((String)String.valueOf(maxBonus));
            comp.append((Component)Affix.valueBounds((Component)minComp, (Component)maxComp));
        }
        return comp;
    }

    public SchoolType getSchool() {
        return this.school;
    }

    public int getBonusLevel(LootRarity rarity, float level) {
        LevelData data = this.values.get(rarity);
        return data != null ? data.level().getInt(level) : 0;
    }

    public boolean canApplyTo(ItemStack stack, LootCategory cat, LootRarity rarity) {
        if (cat.isNone() || !this.values.containsKey(rarity)) {
            return false;
        }
        if (!this.validTypes.isEmpty() && !this.validTypes.contains(cat)) {
            return false;
        }
        Set<SchoolType> gearSchools = AffixSchoolMapper.getSpellSchoolsFromGear(stack);
        return gearSchools.contains(this.school);
    }

    public record LevelData(StepFunction level) {
        private static final Codec<LevelData> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)StepFunction.CODEC.optionalFieldOf("level", (Object)StepFunction.constant((float)1.0f)).forGetter(LevelData::level)).apply((Applicative)inst, LevelData::new));
    }
}

