/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.irons_apothic.affix;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.muon.irons_apothic.affix.AffixSchoolMapper;
import dev.muon.irons_apothic.category.LootCategories;
import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.affix.Affix;
import dev.shadowsoffire.apotheosis.affix.AffixDefinition;
import dev.shadowsoffire.apotheosis.affix.AffixInstance;
import dev.shadowsoffire.apotheosis.loot.LootCategory;
import dev.shadowsoffire.apotheosis.loot.LootRarity;
import dev.shadowsoffire.placebo.util.StepFunction;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import java.util.Map;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.AttributeTooltipContext;

public class ManaCostAffix
extends Affix {
    public static final Codec<ManaCostAffix> CODEC = RecordCodecBuilder.create(inst -> inst.group(Affix.affixDef(), (App)ResourceLocation.CODEC.fieldOf("school").forGetter(a -> a.school.getId()), (App)LootRarity.mapCodec((Codec)StepFunction.CODEC).fieldOf("values").forGetter(a -> a.values), (App)LootCategory.SET_CODEC.fieldOf("categories").forGetter(a -> a.categories)).apply((Applicative)inst, ManaCostAffix::new));
    protected final SchoolType school;
    protected final Map<LootRarity, StepFunction> values;
    protected final Set<LootCategory> categories;

    public ManaCostAffix(AffixDefinition definition, ResourceLocation schoolId, Map<LootRarity, StepFunction> values, Set<LootCategory> categories) {
        super(definition);
        this.school = SchoolRegistry.getSchool((ResourceLocation)schoolId);
        if (this.school == null) {
            throw new IllegalArgumentException("Invalid school ID provided for ManaCostAffix: " + String.valueOf(schoolId));
        }
        this.values = values;
        this.categories = categories;
    }

    public Codec<? extends Affix> getCodec() {
        return CODEC;
    }

    public boolean canApplyTo(ItemStack stack, LootCategory cat, LootRarity rarity) {
        if (cat != LootCategories.STAFF && cat != Apoth.LootCategories.MELEE_WEAPON && cat != LootCategories.SPELLBOOK) {
            return false;
        }
        if (!this.values.containsKey(rarity)) {
            return false;
        }
        if (!this.categories.isEmpty() && !this.categories.contains(cat)) {
            return false;
        }
        Set<SchoolType> gearSchools = AffixSchoolMapper.getSpellSchoolsFromGear(stack);
        return gearSchools.contains(this.school);
    }

    public MutableComponent getDescription(AffixInstance inst, AttributeTooltipContext ctx) {
        float reduction = this.getReductionPercent(inst.getRarity(), inst.level());
        String schoolTranslationKey = "school." + this.school.getId().getNamespace() + "." + this.school.getId().getPath();
        return Component.translatable((String)"affix.irons_apothic.mana_cost.desc", (Object[])new Object[]{Component.translatable((String)schoolTranslationKey).withStyle(this.school.getDisplayName().getStyle()), ManaCostAffix.fmt((float)(reduction * 100.0f))});
    }

    public Component getAugmentingText(AffixInstance inst, AttributeTooltipContext ctx) {
        MutableComponent comp = this.getDescription(inst, ctx);
        float minReduction = this.getReductionPercent(inst.getRarity(), 0.0f);
        float maxReduction = this.getReductionPercent(inst.getRarity(), 1.0f);
        MutableComponent minComp = Component.translatable((String)"%s%%", (Object[])new Object[]{ManaCostAffix.fmt((float)(minReduction * 100.0f))});
        MutableComponent maxComp = Component.translatable((String)"%s%%", (Object[])new Object[]{ManaCostAffix.fmt((float)(maxReduction * 100.0f))});
        return comp.append((Component)ManaCostAffix.valueBounds((Component)minComp, (Component)maxComp));
    }

    public SchoolType getSchool() {
        return this.school;
    }

    public float getReductionPercent(LootRarity rarity, float level) {
        StepFunction func = this.values.get(rarity);
        return func != null ? func.get(level) : 0.0f;
    }
}

