/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.irons_apothic.affix;

import dev.muon.irons_apothic.affix.ManaCostAffix;
import dev.muon.irons_apothic.affix.SpellEffectAffix;
import dev.muon.irons_apothic.affix.SpellLevelAffix;
import dev.muon.irons_apothic.affix.SpellTriggerAffix;
import dev.shadowsoffire.apotheosis.affix.Affix;
import dev.shadowsoffire.apotheosis.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.affix.AffixInstance;
import io.redspace.ironsspellbooks.api.events.ChangeManaEvent;
import io.redspace.ironsspellbooks.api.events.ModifySpellLevelEvent;
import io.redspace.ironsspellbooks.api.events.SpellDamageEvent;
import io.redspace.ironsspellbooks.api.events.SpellHealEvent;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.api.spells.SpellData;
import java.util.Map;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;

public class AffixEventHandler {
    public static void register() {
        NeoForge.EVENT_BUS.register((Object)new AffixEventHandler());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void dropsLowest(LivingDropsEvent e) {
        LivingEntity living;
        ItemStack sourceWeapon;
        Projectile spell;
        DamageSource src = e.getSource();
        Entity directEntity = src.getDirectEntity();
        Entity causingEntity = src.getEntity();
        boolean canTeleport = false;
        Vec3 targetPos = null;
        if (directEntity instanceof Projectile && (spell = (Projectile)directEntity).getOwner() != null && !(sourceWeapon = AffixHelper.getSourceWeapon((Entity)spell)).isEmpty() && (canTeleport = AffixHelper.streamAffixes((ItemStack)sourceWeapon).anyMatch(AffixInstance::enablesTelepathy))) {
            targetPos = spell.getOwner().position();
        }
        if (!canTeleport && causingEntity instanceof LivingEntity && (canTeleport = AffixHelper.streamAffixes((ItemStack)(sourceWeapon = (living = (LivingEntity)causingEntity).getMainHandItem())).anyMatch(AffixInstance::enablesTelepathy))) {
            targetPos = living.position();
        }
        if (canTeleport && targetPos != null) {
            for (ItemEntity item : e.getDrops()) {
                item.setPos(targetPos.x, targetPos.y, targetPos.z);
                item.setPickUpDelay(0);
            }
        }
    }

    @SubscribeEvent
    public void hookSpellDamageAffix(SpellDamageEvent event) {
        LivingEntity living;
        LivingEntity caster;
        if (event.getEntity().level().isClientSide()) {
            return;
        }
        Entity entity = event.getSpellDamageSource().getEntity();
        LivingEntity livingEntity = caster = entity instanceof LivingEntity ? (living = (LivingEntity)entity) : null;
        if (caster == null) {
            return;
        }
        for (ItemStack stack : caster.getAllSlots()) {
            AffixHelper.streamAffixes((ItemStack)stack).forEach(inst -> {
                Affix patt0$temp = inst.getAffix();
                if (patt0$temp instanceof SpellEffectAffix) {
                    SpellEffectAffix affix = (SpellEffectAffix)patt0$temp;
                    if (affix.target == SpellEffectAffix.SpellTarget.SPELL_DAMAGE_TARGET) {
                        affix.applyEffectInternal(event.getEntity(), (AffixInstance)inst);
                    } else if (affix.target == SpellEffectAffix.SpellTarget.SPELL_DAMAGE_SELF) {
                        affix.applyEffectInternal(caster, (AffixInstance)inst);
                    }
                } else {
                    Affix patt1$temp = inst.getAffix();
                    if (patt1$temp instanceof SpellTriggerAffix) {
                        SpellTriggerAffix affix = (SpellTriggerAffix)patt1$temp;
                        if (affix.trigger == SpellTriggerAffix.TriggerType.SPELL_DAMAGE) {
                            LivingEntity target = affix.target.map(targetType -> switch (targetType) {
                                default -> throw new MatchException(null, null);
                                case SpellTriggerAffix.TargetType.SELF -> caster;
                                case SpellTriggerAffix.TargetType.TARGET -> event.getEntity();
                            }).orElse(event.getEntity());
                            affix.triggerSpell(caster, target, (AffixInstance)inst);
                        }
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public void hookSpellHealAffix(SpellHealEvent event) {
        if (event.getEntity().level().isClientSide()) {
            return;
        }
        LivingEntity caster = event.getEntity();
        for (ItemStack stack : caster.getAllSlots()) {
            AffixHelper.streamAffixes((ItemStack)stack).forEach(inst -> {
                Affix patt0$temp = inst.getAffix();
                if (patt0$temp instanceof SpellEffectAffix) {
                    SpellEffectAffix affix = (SpellEffectAffix)patt0$temp;
                    if (affix.target == SpellEffectAffix.SpellTarget.SPELL_HEAL_TARGET) {
                        affix.applyEffectInternal(event.getTargetEntity(), (AffixInstance)inst);
                    } else if (affix.target == SpellEffectAffix.SpellTarget.SPELL_HEAL_SELF) {
                        affix.applyEffectInternal(caster, (AffixInstance)inst);
                    }
                } else {
                    Affix patt1$temp = inst.getAffix();
                    if (patt1$temp instanceof SpellTriggerAffix) {
                        SpellTriggerAffix affix = (SpellTriggerAffix)patt1$temp;
                        if (affix.trigger == SpellTriggerAffix.TriggerType.SPELL_HEAL) {
                            LivingEntity target = affix.target.map(targetType -> switch (targetType) {
                                default -> throw new MatchException(null, null);
                                case SpellTriggerAffix.TargetType.SELF -> caster;
                                case SpellTriggerAffix.TargetType.TARGET -> event.getTargetEntity();
                            }).orElse(event.getTargetEntity());
                            affix.triggerSpell(caster, target, (AffixInstance)inst);
                        }
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public void onChangeMana(ChangeManaEvent event) {
        if (event.getEntity().level().isClientSide()) {
            return;
        }
        Player player = event.getEntity();
        MagicData magicData = event.getMagicData();
        SpellData castingSpell = magicData.getCastingSpell();
        if (castingSpell == null || event.getNewMana() >= event.getOldMana()) {
            return;
        }
        AbstractSpell spell = castingSpell.getSpell();
        if (spell == null) {
            return;
        }
        SchoolType spellSchool = spell.getSchoolType();
        ItemStack mainHand = player.getMainHandItem();
        if (mainHand.isEmpty()) {
            return;
        }
        float totalReduction = 0.0f;
        Map affixes = AffixHelper.getAffixes((ItemStack)mainHand);
        for (AffixInstance instance : affixes.values()) {
            ManaCostAffix manaCostAffix;
            Affix affix;
            if (!instance.isValid() || !instance.affix().isBound() || !((affix = instance.getAffix()) instanceof ManaCostAffix) || (manaCostAffix = (ManaCostAffix)affix).getSchool() != spellSchool) continue;
            float reduction = manaCostAffix.getReductionPercent(instance.getRarity(), instance.level());
            totalReduction += reduction;
        }
        if (totalReduction > 0.0f) {
            float manaCost = event.getOldMana() - event.getNewMana();
            float reducedCost = manaCost * (1.0f - Math.min(totalReduction, 0.9f));
            float newManaValue = event.getOldMana() - reducedCost;
            event.setNewMana(newManaValue);
        }
    }

    @SubscribeEvent
    public void onSpellLevel(ModifySpellLevelEvent event) {
        LivingEntity entity = event.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = entity;
        AbstractSpell spell = event.getSpell();
        SchoolType school = spell.getSchoolType();
        int totalBonus = 0;
        for (ItemStack stack : livingEntity.getAllSlots()) {
            totalBonus += this.getSpellLevelBonus(stack, school);
        }
        int curiosBonus = CuriosApi.getCuriosInventory((LivingEntity)livingEntity).map(curiosHandler -> {
            int bonus = 0;
            for (SlotResult slotResult : curiosHandler.findCurios(stack -> !stack.isEmpty())) {
                bonus += this.getSpellLevelBonus(slotResult.stack(), school);
            }
            return bonus;
        }).orElse(0);
        if ((totalBonus += curiosBonus) > 0) {
            event.addLevels(totalBonus);
        }
    }

    private int getSpellLevelBonus(ItemStack stack, SchoolType school) {
        int bonus = 0;
        Map affixes = AffixHelper.getAffixes((ItemStack)stack);
        for (AffixInstance instance : affixes.values()) {
            SpellLevelAffix spellLevelAffix;
            Affix affix;
            if (!instance.isValid() || !instance.affix().isBound() || !((affix = instance.getAffix()) instanceof SpellLevelAffix) || (spellLevelAffix = (SpellLevelAffix)affix).getSchool() != school) continue;
            bonus += spellLevelAffix.getBonusLevel(instance.getRarity(), instance.level());
        }
        return bonus;
    }
}

