/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.irons_apothic;

import com.mojang.brigadier.CommandDispatcher;
import dev.muon.irons_apothic.affix.AffixEventHandler;
import dev.muon.irons_apothic.affix.MagicTelepathicAffix;
import dev.muon.irons_apothic.affix.ManaCostAffix;
import dev.muon.irons_apothic.affix.SchoolAttributeAffix;
import dev.muon.irons_apothic.affix.SpellEffectAffix;
import dev.muon.irons_apothic.affix.SpellLevelAffix;
import dev.muon.irons_apothic.affix.SpellTriggerAffix;
import dev.muon.irons_apothic.category.LootCategories;
import dev.muon.irons_apothic.category.SlotGroups;
import dev.muon.irons_apothic.command.IronsApothicCommands;
import dev.shadowsoffire.apotheosis.affix.AffixRegistry;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="irons_apothic")
public class IronsApothic {
    public static final String MODID = "irons_apothic";
    public static final Logger LOGGER = LogManager.getLogger();

    public IronsApothic(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        SlotGroups.register(modEventBus);
        LootCategories.register(modEventBus);
        AffixEventHandler.register();
        NeoForge.EVENT_BUS.addListener(this::registerCommands);
        LOGGER.info("Loading Iron's Apotheosis Compat");
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("Registering custom affix codecs...");
        AffixRegistry.INSTANCE.registerCodec(IronsApothic.loc("attribute"), SchoolAttributeAffix.CODEC);
        AffixRegistry.INSTANCE.registerCodec(IronsApothic.loc("spell_effect"), SpellEffectAffix.CODEC);
        AffixRegistry.INSTANCE.registerCodec(IronsApothic.loc("magic_telepathic"), MagicTelepathicAffix.CODEC);
        AffixRegistry.INSTANCE.registerCodec(IronsApothic.loc("spell_level"), SpellLevelAffix.CODEC);
        AffixRegistry.INSTANCE.registerCodec(IronsApothic.loc("spell_trigger"), SpellTriggerAffix.CODEC);
        AffixRegistry.INSTANCE.registerCodec(IronsApothic.loc("mana_cost"), ManaCostAffix.CODEC);
        LOGGER.info("Custom affix codecs registered.");
    }

    private void registerCommands(RegisterCommandsEvent event) {
        IronsApothicCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        LOGGER.info("Commands registered.");
    }

    public static ResourceLocation loc(String id) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)id);
    }
}

