/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.pylons.compat.harvest;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.level.block.Block;
import net.permutated.pylons.compat.harvest.Harvestable;
import net.permutated.pylons.compat.harvest.adapters.MinecraftNetherWart;
import net.permutated.pylons.compat.harvest.adapters.MinecraftSweetBerryBush;

public class HarvestCompat {
    private static final Map<Block, Harvestable> compat = new ConcurrentHashMap<Block, Harvestable>();

    private HarvestCompat() {
    }

    private static void register(Harvestable harvestable) {
        compat.put(harvestable.getBlock(), harvestable);
    }

    public static Harvestable getCompat(Block block) {
        return compat.get(block);
    }

    public static boolean hasCompat(Block block) {
        return compat.containsKey(block);
    }

    public static void init() {
        HarvestCompat.register(new MinecraftNetherWart());
        HarvestCompat.register(new MinecraftSweetBerryBush());
    }
}

