/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.adaptivetooltips.mixins;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.isxander.adaptivetooltips.BetterTooltips;
import dev.isxander.adaptivetooltips.helpers.ScrollTracker;
import dev.isxander.adaptivetooltips.helpers.TooltipWrapper;
import dev.isxander.adaptivetooltips.helpers.positioner.BedrockCenteringPositionModule;
import dev.isxander.adaptivetooltips.helpers.positioner.BestCornerPositionModule;
import dev.isxander.adaptivetooltips.helpers.positioner.PrioritizeTooltipTopPositionModule;
import dev.isxander.adaptivetooltips.helpers.positioner.TooltipPositionModule;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import org.joml.Vector2ic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GuiGraphics.class}, priority=1100)
public abstract class GuiGraphicsMixin {
    @Shadow
    public abstract PoseStack pose();

    @Shadow
    public abstract int guiWidth();

    @Shadow
    public abstract int guiHeight();

    @ModifyVariable(method={"renderTooltipInternal"}, at=@At(value="HEAD"), argsOnly=true)
    private List<ClientTooltipComponent> modifyTooltip(List<ClientTooltipComponent> tooltip, Font font, List<ClientTooltipComponent> dontuse, int x, int y, ClientTooltipPositioner positioner) {
        return TooltipWrapper.wrapComponents(tooltip, font, this.guiWidth(), this.guiHeight(), x, positioner);
    }

    @WrapOperation(method={"renderTooltipInternal"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/tooltip/ClientTooltipPositioner;positionTooltip(IIIIII)Lorg/joml/Vector2ic;")})
    private Vector2ic moveTooltip(ClientTooltipPositioner positioner, int screenWidth, int screenHeight, int x, int y, int width, int height, Operation<Vector2ic> operation, Font font, List<ClientTooltipComponent> tooltip, int mouseX, int mouseY) {
        Vector2ic currentPosition = (Vector2ic)operation.call(new Object[]{positioner, screenWidth, screenHeight, mouseX, mouseY, width, height});
        this.pose().pushPose();
        if (!(positioner instanceof DefaultTooltipPositioner) && ((Boolean)BetterTooltips.getConfig().onlyRepositionHoverTooltips.get()).booleanValue()) {
            return currentPosition;
        }
        for (TooltipPositionModule tooltipPositionModule : List.of(new PrioritizeTooltipTopPositionModule(), new BedrockCenteringPositionModule(), new BestCornerPositionModule())) {
            Optional<Vector2ic> position = tooltipPositionModule.repositionTooltip(currentPosition.x(), currentPosition.y(), width, height, x, y, this.guiWidth(), this.guiHeight());
            if (!position.isPresent()) continue;
            currentPosition = position.get();
        }
        ScrollTracker.scroll((GuiGraphics)this, tooltip, currentPosition.x(), currentPosition.y(), width, height, screenWidth, screenHeight);
        return currentPosition;
    }

    @Inject(method={"renderTooltipInternal"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;popPose()V", ordinal=0)})
    private void closeCustomMatrices(Font textRenderer, List<ClientTooltipComponent> tooltip, int x, int y, ClientTooltipPositioner positioner, CallbackInfo ci) {
        this.pose().popPose();
    }

    @ModifyConstant(method={"renderTooltipInternal"}, constant={@Constant(intValue=2)})
    private int removeFirstLinePadding(int padding) {
        if (((Boolean)BetterTooltips.getConfig().removeFirstLinePadding.get()).booleanValue()) {
            return 0;
        }
        return padding;
    }
}

