/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.adaptivetooltips.helpers.positioner;

import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2i;
import org.joml.Vector2ic;

public class YACLTooltipPositioner
implements ClientTooltipPositioner {
    private final ScreenRectangle clickableWidget;

    public YACLTooltipPositioner(ScreenRectangle clickableWidget) {
        this.clickableWidget = clickableWidget;
    }

    @NotNull
    public Vector2ic positionTooltip(int screenWidth, int screenHeight, int x, int y, int width, int height) {
        int centerX = this.clickableWidget.left() + this.clickableWidget.width() / 2;
        int aboveY = this.clickableWidget.top() - height - 4;
        int belowY = this.clickableWidget.top() + this.clickableWidget.height() + 4;
        int obstructionBottom = belowY + height - screenHeight;
        int obstructionTop = -aboveY;
        int yResult = belowY;
        if (obstructionBottom > 0) {
            yResult = obstructionBottom > obstructionTop ? aboveY : belowY;
        }
        int xResult = Mth.clamp((int)(centerX - width / 2), (int)-4, (int)(screenWidth - width - 4));
        return new Vector2i(xResult, yResult);
    }
}

