/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.adaptivetooltips.helpers;

import dev.isxander.adaptivetooltips.BetterTooltips;
import dev.isxander.adaptivetooltips.config.BetterTooltipsConfig;
import dev.isxander.adaptivetooltips.mixins.ClientTextTooltipAccessor;
import dev.isxander.adaptivetooltips.utils.TextUtil;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTextTooltip;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;

public class TooltipWrapper {
    public static List<FormattedCharSequence> wrapTooltipLines(int screenWidth, int screenHeight, Font textRenderer, List<? extends Component> lines, int x, ClientTooltipPositioner tooltipPositioner) {
        if (lines.stream().allMatch(text -> text.getString().isBlank())) {
            return List.of();
        }
        int maxWidth = TooltipWrapper.getMaxWidth(textRenderer, lines);
        int allowedMaxWidth = 0;
        switch ((BetterTooltipsConfig.WrapText)((Object)BetterTooltips.getConfig().wrapText.get())) {
            case OFF: {
                allowedMaxWidth = Integer.MAX_VALUE;
                break;
            }
            case SCREEN_WIDTH: {
                allowedMaxWidth = screenWidth - 15;
                break;
            }
            case REMAINING_WIDTH: {
                if (tooltipPositioner instanceof DefaultTooltipPositioner) {
                    allowedMaxWidth = screenWidth - x - 15;
                    if (x + 12 + maxWidth <= screenWidth) break;
                    allowedMaxWidth = Math.max(allowedMaxWidth, x - 20);
                    break;
                }
                allowedMaxWidth = Integer.MAX_VALUE;
                break;
            }
            case HALF_SCREEN_WIDTH: {
                allowedMaxWidth = screenWidth / 2;
                break;
            }
            case SMART: {
                if (lines.size() <= 1) {
                    allowedMaxWidth = screenWidth / 4 * 3;
                    break;
                }
                AtomicInteger idx = new AtomicInteger(0);
                Map<Integer, Integer> widths = lines.stream().map(arg_0 -> ((Font)textRenderer).width(arg_0)).map(width -> new AbstractMap.SimpleEntry<Integer, Integer>(idx.getAndIncrement(), (Integer)width)).filter(entry -> (Integer)entry.getValue() > 0).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
                ArrayList<AbstractMap.SimpleEntry<Integer, Integer>> arrayList = new ArrayList<AbstractMap.SimpleEntry<Integer, Integer>>();
                Iterator<Map.Entry<Integer, Integer>> iterator = widths.entrySet().iterator();
                int width2 = iterator.next().getValue();
                while (iterator.hasNext()) {
                    Map.Entry<Integer, Integer> entry2 = iterator.next();
                    int diff = entry2.getValue() - width2;
                    width2 = entry2.getValue();
                    arrayList.add(new AbstractMap.SimpleEntry<Integer, Integer>(entry2.getKey(), diff));
                }
                Optional<Integer> index = arrayList.stream().filter(entry -> (Integer)entry.getValue() <= 100).sorted(Comparator.comparingInt(entry -> -((Integer)entry.getValue()).intValue())).map(Map.Entry::getKey).findFirst();
                allowedMaxWidth = index.map(integer -> Math.min(textRenderer.width((FormattedText)lines.get((int)integer)), screenWidth / 4 * 3)).orElse(screenWidth / 4 * 3);
            }
        }
        if (maxWidth <= allowedMaxWidth) {
            return lines.stream().map(Component::getVisualOrderText).collect(Collectors.toList());
        }
        ArrayList<FormattedCharSequence> wrapped = new ArrayList<FormattedCharSequence>();
        for (Component component : lines) {
            wrapped.addAll(textRenderer.split((FormattedText)component, allowedMaxWidth));
        }
        return wrapped;
    }

    public static List<ClientTooltipComponent> wrapComponents(List<ClientTooltipComponent> components, Font font, int screenWidth, int screenHeight, int x, ClientTooltipPositioner tooltipPositioner) {
        ArrayList<ClientTooltipComponent> wrapped = new ArrayList<ClientTooltipComponent>();
        ArrayList<Component> groupedText = new ArrayList<Component>();
        for (ClientTooltipComponent component : components) {
            if (component instanceof ClientTextTooltip) {
                ClientTextTooltip textTooltip = (ClientTextTooltip)component;
                FormattedCharSequence charSequence = ((ClientTextTooltipAccessor)textTooltip).getText();
                MutableComponent text = TextUtil.toText(charSequence);
                groupedText.add((Component)text);
                continue;
            }
            if (!groupedText.isEmpty()) {
                wrapped.addAll(TooltipWrapper.convertComponentToTooltip(groupedText, font, screenWidth, screenHeight, x, tooltipPositioner));
                groupedText.clear();
            }
            wrapped.add(component);
        }
        if (!groupedText.isEmpty()) {
            wrapped.addAll(TooltipWrapper.convertComponentToTooltip(groupedText, font, screenWidth, screenHeight, x, tooltipPositioner));
            groupedText.clear();
        }
        return wrapped;
    }

    private static List<ClientTextTooltip> convertComponentToTooltip(List<Component> lines, Font font, int screenWidth, int screenHeight, int x, ClientTooltipPositioner tooltipPositioner) {
        return TooltipWrapper.wrapTooltipLines(screenWidth, screenHeight, font, lines, x, tooltipPositioner).stream().map(ClientTextTooltip::new).toList();
    }

    private static int getMaxWidth(Font textRenderer, List<? extends Component> lines) {
        int maxWidth = 0;
        for (Component component : lines) {
            int width = textRenderer.width((FormattedText)component);
            if (width <= maxWidth) continue;
            maxWidth = width;
        }
        return maxWidth;
    }
}

