/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.adaptivetooltips.helpers;

import dev.isxander.adaptivetooltips.BetterTooltips;
import dev.isxander.adaptivetooltips.config.BetterTooltipsConfig;
import dev.isxander.adaptivetooltips.mixins.BundleTooltipComponentAccessor;
import dev.isxander.adaptivetooltips.mixins.ClientTextTooltipAccessor;
import dev.isxander.adaptivetooltips.utils.TextUtil;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientBundleTooltip;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTextTooltip;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;

public class ScrollTracker {
    private static int targetVerticalScroll = 0;
    private static int targetHorizontalScroll = 0;
    private static float currentVerticalScroll = 0.0f;
    private static float currentHorizontalScroll = 0.0f;
    private static List<ClientTooltipComponent> trackedComponents = null;
    public static boolean renderedThisFrame = false;

    public static void addVerticalScroll(int amt) {
        if (BetterTooltips.getConfig().scrollDirection.get() == BetterTooltipsConfig.ScrollDirection.REVERSE) {
            amt = -amt;
        }
        targetVerticalScroll += amt * (Integer)BetterTooltips.getConfig().verticalScrollSensitivity.get();
    }

    public static void addHorizontalScroll(int amt) {
        if (BetterTooltips.getConfig().scrollDirection.get() == BetterTooltipsConfig.ScrollDirection.REVERSE) {
            amt = -amt;
        }
        targetHorizontalScroll += amt * (Integer)BetterTooltips.getConfig().horizontalScrollSensitivity.get();
    }

    public static float getVerticalScroll() {
        return currentVerticalScroll;
    }

    public static float getHorizontalScroll() {
        return currentHorizontalScroll;
    }

    public static void scroll(GuiGraphics graphics, List<ClientTooltipComponent> components, int x, int y, int width, int height, int screenWidth, int screenHeight) {
        ScrollTracker.tick(components, x, y, width, height, screenWidth, screenHeight, Minecraft.getInstance().getTimer());
        graphics.pose().translate(ScrollTracker.getHorizontalScroll(), ScrollTracker.getVerticalScroll(), 0.0f);
    }

    private static void tick(List<ClientTooltipComponent> components, int x, int y, int width, int height, int screenWidth, int screenHeight, DeltaTracker tickDelta) {
        renderedThisFrame = true;
        ScrollTracker.resetIfNeeded(components);
        if (height < screenHeight) {
            targetVerticalScroll = 0;
        }
        if (width < screenWidth) {
            targetHorizontalScroll = 0;
        }
        targetVerticalScroll = Mth.clamp((int)targetVerticalScroll, (int)Math.min(screenHeight - (y + height) - 4, 0), (int)Math.max(-y + 4, 0));
        targetHorizontalScroll = Mth.clamp((int)targetHorizontalScroll, (int)Math.min(screenWidth - (x + width) - 4, 0), (int)Math.max(-x + 4, 0));
        ScrollTracker.tickAnimation(tickDelta.getGameTimeDeltaTicks());
    }

    private static void tickAnimation(float tickDelta) {
        if (((Boolean)BetterTooltips.getConfig().smoothScrolling.get()).booleanValue()) {
            currentVerticalScroll = Mth.lerp((float)(tickDelta * 0.5f), (float)currentVerticalScroll, (float)targetVerticalScroll);
            currentHorizontalScroll = Mth.lerp((float)(tickDelta * 0.5f), (float)currentHorizontalScroll, (float)targetHorizontalScroll);
        } else {
            currentVerticalScroll = targetVerticalScroll;
            currentHorizontalScroll = targetHorizontalScroll;
        }
    }

    private static void resetIfNeeded(List<ClientTooltipComponent> components) {
        if (!ScrollTracker.isEqual(components, trackedComponents)) {
            ScrollTracker.reset();
        }
        trackedComponents = components;
    }

    public static void reset() {
        targetHorizontalScroll = 0;
        targetVerticalScroll = 0;
        currentHorizontalScroll = 0.0f;
        currentVerticalScroll = 0.0f;
    }

    private static boolean isEqual(List<ClientTooltipComponent> l1, List<ClientTooltipComponent> l2) {
        if (l1 == null || l2 == null) {
            return false;
        }
        Iterator<ClientTooltipComponent> iter1 = l1.iterator();
        Iterator<ClientTooltipComponent> iter2 = l2.iterator();
        while (iter1.hasNext() && iter2.hasNext()) {
            ClientTooltipComponent c2;
            ClientTooltipComponent c1 = iter1.next();
            if (c1 == (c2 = iter2.next())) continue;
            if (c1 instanceof ClientTextTooltip) {
                ClientTextTooltip ot1 = (ClientTextTooltip)c1;
                if (c2 instanceof ClientTextTooltip) {
                    ClientTextTooltip ot2 = (ClientTextTooltip)c2;
                    if (TextUtil.toText(((ClientTextTooltipAccessor)ot1).getText()).equals((Object)TextUtil.toText(((ClientTextTooltipAccessor)ot2).getText()))) continue;
                    return false;
                }
            }
            if (c1 instanceof ClientBundleTooltip) {
                ClientBundleTooltip bt1 = (ClientBundleTooltip)c1;
                if (c2 instanceof ClientBundleTooltip) {
                    ClientBundleTooltip bt2 = (ClientBundleTooltip)c2;
                    Iterator i1 = ((BundleTooltipComponentAccessor)bt1).getContents().items().iterator();
                    Iterator i2 = ((BundleTooltipComponentAccessor)bt2).getContents().items().iterator();
                    while (i1.hasNext() && i2.hasNext()) {
                        ItemStack stack2;
                        ItemStack stack1 = (ItemStack)i1.next();
                        if (ItemStack.matches((ItemStack)stack1, (ItemStack)(stack2 = (ItemStack)i2.next()))) continue;
                        return false;
                    }
                    if (!i1.hasNext() && !i2.hasNext()) continue;
                    return false;
                }
            }
            return false;
        }
        return !iter1.hasNext() && !iter2.hasNext();
    }
}

