/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.adaptivetooltips.config;

import net.minecraft.network.chat.Component;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.common.TranslatableEnum;

public class BetterTooltipsConfig {
    public final ModConfigSpec.BooleanValue overwriteVanillaWrapping;
    public final ModConfigSpec.BooleanValue prioritizeTooltipTop;
    public final ModConfigSpec.BooleanValue bedrockCentering;
    public final ModConfigSpec.BooleanValue bestCorner;
    public final ModConfigSpec.BooleanValue alwaysBestCorner;
    public final ModConfigSpec.BooleanValue preventVanillaClamping;
    public final ModConfigSpec.BooleanValue onlyRepositionHoverTooltips;
    public final ModConfigSpec.BooleanValue smoothScrolling;
    public final ModConfigSpec.IntValue verticalScrollSensitivity;
    public final ModConfigSpec.IntValue horizontalScrollSensitivity;
    public final ModConfigSpec.DoubleValue tooltipTransparency;
    public final ModConfigSpec.BooleanValue removeFirstLinePadding;
    public final ModConfigSpec.BooleanValue useYACLTooltipPositioner;
    public final ModConfigSpec.EnumValue<WrapText> wrapText;
    public final ModConfigSpec.EnumValue<ScrollDirection> scrollDirection;

    public BetterTooltipsConfig(ModConfigSpec.Builder builder) {
        builder.push("content_manipulation");
        this.wrapText = builder.defineEnum("wrapText", (Enum)WrapText.SCREEN_WIDTH);
        this.overwriteVanillaWrapping = builder.define("overwriteVanillaWrapping", false);
        builder.pop();
        builder.push("positioning");
        this.prioritizeTooltipTop = builder.define("prioritizeTooltipTop", true);
        this.bedrockCentering = builder.define("bedrockCentering", true);
        this.bestCorner = builder.define("bestCorner", false);
        this.alwaysBestCorner = builder.define("alwaysBestCorner", false);
        this.preventVanillaClamping = builder.define("preventVanillaClamping", true);
        this.onlyRepositionHoverTooltips = builder.define("onlyRepositionHoverTooltips", true);
        this.useYACLTooltipPositioner = builder.define("useYACLTooltipPositioner", false);
        builder.pop();
        builder.push("scrolling");
        this.smoothScrolling = builder.define("smoothScrolling", true);
        this.scrollDirection = builder.defineEnum("scrollDirection", (Enum)ScrollDirection.NATURAL);
        this.verticalScrollSensitivity = builder.defineInRange("verticalScrollSensitivity", 10, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.horizontalScrollSensitivity = builder.defineInRange("horizontalScrollSensitivity", 10, Integer.MIN_VALUE, Integer.MAX_VALUE);
        builder.pop();
        builder.push("style");
        this.tooltipTransparency = builder.defineInRange("tooltipTransparency", 1.0, 0.0, 1.0);
        this.removeFirstLinePadding = builder.define("removeFirstLinePadding", true);
        builder.pop();
    }

    public static enum WrapText implements TranslatableEnum
    {
        OFF,
        SCREEN_WIDTH,
        REMAINING_WIDTH,
        HALF_SCREEN_WIDTH,
        SMART;


        public Component getTranslatedName() {
            return Component.translatable((String)("better_tooltips.wrap_text_behaviour." + this.name().toLowerCase()));
        }
    }

    public static enum ScrollDirection implements TranslatableEnum
    {
        NATURAL,
        REVERSE;


        public Component getTranslatedName() {
            return Component.translatable((String)("better_tooltips.scroll_direction." + this.name().toLowerCase()));
        }
    }
}

